/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.widgets;

import aurora.ide.editor.core.ICategoryViewer;
import aurora.ide.editor.widgets.core.CategoryLabel;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;
import uncertain.schema.editor.AttributeValue;

public class PropertyHashCellModifier
implements ICellModifier {
    public static final String[] PROPERTY_TO_UPDATE = new String[]{"VALUE"};
    ICategoryViewer viewer;
    CellEditor cellEditor;

    public PropertyHashCellModifier(ICategoryViewer viewer) {
        this.viewer = viewer;
    }

    public boolean canModify(Object element, String property) {
        if (element instanceof CategoryLabel) {
            return false;
        }
        return "VALUE".equals(property);
    }

    public Object getValue(Object element, String property) {
        AttributeValue av = (AttributeValue)element;
        if ("VALUE".equals(property)) {
            return av.getValueString();
        }
        return av.getAttribute().getLocalName();
    }

    public void modify(Object element, String property, Object value) {
        TableItem item = (TableItem)element;
        AttributeValue av = (AttributeValue)item.getData();
        if (av instanceof CategoryLabel) {
            return;
        }
        String attributeName = av.getAttribute().getLocalName();
        Object oldValue = av.getContainer().get((Object)av.getAttribute().getLocalName());
        if ((oldValue == null || oldValue.equals("")) && (value == null || value.equals(""))) {
            return;
        }
        if (oldValue == null || oldValue != null && !oldValue.equals(value)) {
            av.getContainer().put((Object)attributeName, value);
            this.viewer.refresh(true);
        }
        if (value == null || value.equals("")) {
            av.getContainer().remove((Object)attributeName);
        }
    }
}

