/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.editor.widgets;

import aurora.ide.editor.core.ICategory;
import aurora.ide.editor.widgets.PropertyHashContentProvider;
import aurora.ide.editor.widgets.core.CategoryLabel;
import aurora.ide.helpers.LocaleMessage;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import uncertain.schema.Category;
import uncertain.schema.editor.AttributeValue;

public class PropertyHashSorter
extends ViewerSorter {
    private static final int ASCENDING = 0;
    private static final int DESCENDING = 1;
    private int order;
    private int column;
    private ICategory container;
    private PropertyHashContentProvider contentProvider;

    public PropertyHashSorter(ICategory container, PropertyHashContentProvider contentProvider) {
        this.container = container;
        this.contentProvider = contentProvider;
    }

    public void doSort(int column) {
        if (column == this.column) {
            this.order = 1 - this.order;
        } else {
            this.column = column;
            this.order = 0;
        }
    }

    public int category(Object element) {
        int result = 0;
        String cln = "";
        int side = this.order == 0 ? 1 : -1;
        AttributeValue av = (AttributeValue)element;
        if (element instanceof CategoryLabel) {
            result = (Integer)this.contentProvider.getCategorys().get(av.getValueString());
            result -= side;
        } else {
            Category category = av.getAttribute().getCategoryInstance();
            cln = category != null ? category.getLocalName() : LocaleMessage.getString("noncategory");
            result = (Integer)this.contentProvider.getCategorys().get(cln);
        }
        if (this.order == 1) {
            result = -result;
        }
        return result;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        String name2;
        String name1;
        int cat2;
        int cat1;
        if (this.container.isCategory() && (cat1 = this.category(e1)) != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        if (viewer == null || !(viewer instanceof ContentViewer)) {
            name1 = e1.toString();
            name2 = e2.toString();
        } else {
            IBaseLabelProvider prov = ((ContentViewer)viewer).getLabelProvider();
            if (prov instanceof ILabelProvider) {
                ILabelProvider lprov = (ILabelProvider)prov;
                name1 = lprov.getText(e1);
                name2 = lprov.getText(e2);
            } else if (prov instanceof ITableLabelProvider) {
                ITableLabelProvider lprov = (ITableLabelProvider)prov;
                name1 = lprov.getColumnText(e1, this.column);
                name2 = lprov.getColumnText(e2, this.column);
            } else {
                name1 = e1.toString();
                name2 = e2.toString();
            }
        }
        if (name1 == null) {
            name1 = "";
        }
        if (name2 == null) {
            name2 = "";
        }
        int result = this.getComparator().compare(name1, name2);
        if (this.order == 1) {
            result = -result;
        }
        return result;
    }
}

