/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.fake.uncertain.engine;

import aurora.datasource.DatabaseConnection;
import aurora.ide.helpers.LogUtil;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FakeDataSource
implements DataSource {
    private String name;
    private String driverClass;
    private String url;
    private String userName;
    private String password;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        throw new RuntimeException("unsupport methord");
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        throw new RuntimeException("unsupport methord");
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        throw new RuntimeException("unsupport methord");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new RuntimeException("unsupport methord");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new RuntimeException("unsupport methord");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new RuntimeException("unsupport methord");
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            Class.forName(this.getDriverClass());
            DriverManager.setLoginTimeout(5000);
            Connection conn = DriverManager.getConnection(this.url, this.userName, this.password);
            return conn;
        }
        catch (ClassNotFoundException e) {
            throw new SQLException(e);
        }
        catch (SQLException e) {
            LogUtil.getInstance().logError(this.url, e);
            throw e;
        }
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        try {
            Class.forName(this.getDriverClass());
            Connection conn = DriverManager.getConnection(this.url, username, password);
            return conn;
        }
        catch (ClassNotFoundException e) {
            throw new SQLException(e);
        }
        catch (SQLException e) {
            LogUtil.getInstance().logError(this.url, e);
            throw e;
        }
    }

    public static DataSource createDataSource(DatabaseConnection dbConfig) {
        FakeDataSource fakeDataSource = new FakeDataSource();
        fakeDataSource.setDriverClass(dbConfig.getDriverClass());
        fakeDataSource.setName(dbConfig.getName());
        fakeDataSource.setUrl(dbConfig.getUrl());
        fakeDataSource.setUserName(dbConfig.getUserName());
        fakeDataSource.setPassword(dbConfig.getPassword());
        return fakeDataSource;
    }
}

