/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.helpers;

import aurora.ide.AuroraPlugin;
import aurora.ide.fake.uncertain.engine.FakeUncertainEngine;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.project.AuroraProject;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import javax.sql.DataSource;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class DBConnectionUtil {
    private static final HashMap<IProject, FakeUncertainEngine> project_engine = new HashMap();

    static {
        AuroraPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                IResourceDelta delta = event.getDelta();
                if (delta == null) {
                    return;
                }
                try {
                    delta.accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            IResource resource = delta.getResource();
                            if (resource instanceof IFile) {
                                IFile file = (IFile)resource;
                                if ("datasource.config".equals(file.getName()) || "0.datasource.config".equals(file.getName())) {
                                    IProject project = file.getProject();
                                    FakeUncertainEngine fakeUncertainEngine = (FakeUncertainEngine)project_engine.get(project);
                                    if (fakeUncertainEngine != null) {
                                        fakeUncertainEngine.shutdown();
                                    }
                                }
                                return false;
                            }
                            return true;
                        }
                    });
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        });
    }

    private static FakeUncertainEngine createFakeUncertainEngine(IProject project) throws ApplicationException {
        AuroraProject ap = new AuroraProject(project);
        IContainer web_home = ap.getWeb_home();
        IFolder web_inf = ap.getWeb_inf();
        if (web_home == null || web_inf == null) {
            throw new ApplicationException("Aurora \u5de5\u7a0b\u8bbe\u7f6e\u4e0d\u6b63\u786e ");
        }
        FakeUncertainEngine fue = new FakeUncertainEngine(web_home.getLocation().toOSString(), web_inf.getLocation().toOSString());
        return fue;
    }

    public static Connection getDBConnection(IProject project, String datasourceName) throws ApplicationException {
        FakeUncertainEngine fue = DBConnectionUtil.getFakeUncertainEngine(project);
        DBConnectionUtil dBConnectionUtil = new DBConnectionUtil();
        dBConnectionUtil.getClass();
        Runner runnable = dBConnectionUtil.new Runner(fue, datasourceName);
        try {
            AuroraPlugin.getDefault().getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)runnable);
        }
        catch (InvocationTargetException e) {
            throw new ApplicationException("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25!\u8bf7\u67e5\u770bdatasource.config\u662f\u5426\u914d\u7f6e\u6b63\u786e.", e);
        }
        catch (InterruptedException e) {
            throw new ApplicationException("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25!\u8bf7\u67e5\u770bdatasource.config\u662f\u5426\u914d\u7f6e\u6b63\u786e.", e);
        }
        Connection conn = runnable.getConn();
        return conn;
    }

    public static Connection getDBConnection(IProject project) throws ApplicationException {
        return DBConnectionUtil.getDBConnection(project, null);
    }

    public static Connection getDBConnectionSyncExec(IProject project) throws ApplicationException {
        return DBConnectionUtil.getDBConnectionSyncExec(project, null);
    }

    public static Connection getDBConnectionSyncExec(IProject project, String datasourceName) throws ApplicationException {
        FakeUncertainEngine fue = DBConnectionUtil.getFakeUncertainEngine(project);
        DBConnectionUtil dBConnectionUtil = new DBConnectionUtil();
        dBConnectionUtil.getClass();
        final Runner runnable = dBConnectionUtil.new Runner(fue, datasourceName);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    AuroraPlugin.getDefault().getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)runnable);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        Connection conn = runnable.getConn();
        if (conn == null) {
            throw new ApplicationException("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25!\u8bf7\u67e5\u770bdatasource.config\u662f\u5426\u914d\u7f6e\u6b63\u786e.");
        }
        return conn;
    }

    public static FakeUncertainEngine getFakeUncertainEngine(IProject project) throws ApplicationException {
        FakeUncertainEngine fue = project_engine.get(project);
        if (fue == null || !fue.isRunning()) {
            fue = DBConnectionUtil.createFakeUncertainEngine(project);
            project_engine.put(project, fue);
        }
        return fue;
    }

    public static boolean testDBConnection(IProject project, String webHome) throws ApplicationException {
        return DBConnectionUtil.getDBConnection(project) != null;
    }

    private class Runner
    implements IRunnableWithProgress {
        private Connection conn;
        private FakeUncertainEngine fue;
        private String dsName;

        public Runner(FakeUncertainEngine fue, String dsName) {
            this.fue = fue;
            this.dsName = dsName;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("\u6b63\u5728\u5efa\u7acb\u6570\u636e\u5e93\u8fde\u63a5", 130);
            monitor.worked(30);
            if (!this.fue.isRunning()) {
                monitor.setTaskName("\u542f\u52a8Aurora\u5f15\u64ce");
                this.fue.startup();
            }
            if (!this.fue.isSuccess()) {
                throw new InterruptedException();
            }
            monitor.setTaskName("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5");
            monitor.worked(20);
            DataSource ds = this.fue.getDatasource(this.dsName);
            if (ds == null) {
                throw new InterruptedException();
            }
            monitor.worked(50);
            try {
                try {
                    Connection connection = ds.getConnection();
                    this.setConn(connection);
                }
                catch (SQLException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
            }
        }

        public Connection getConn() {
            return this.conn;
        }

        public void setConn(Connection conn) {
            this.conn = conn;
        }
    }
}

