/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.helpers;

import aurora.ide.bm.BMUtil;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.ProjectUtil;
import aurora.ide.project.propertypage.ProjectPropertyPage;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PathUtil {
    public static final IPath REQUEST_PATH = new Path("${/request/@context_path}");
    public static final IPath CRUD_PATH = REQUEST_PATH.append("/autocrud/");
    public static final List<String> AURORA_FILE_EXTENSION = Arrays.asList("bm", "screen", "svc");
    public static final List<String> AURORA_CONFIG_FILE_EXTENSION = Arrays.asList("xml", "proc", "config");

    public static IFile findFile(IFile file, String value) {
        IFile screenFile = PathUtil.findScreenFile(file, value);
        if (screenFile != null) {
            return screenFile;
        }
        Path path = new Path(value);
        boolean prefixOfRequest = CRUD_PATH.isPrefixOf((IPath)path);
        if (prefixOfRequest) {
            path = path.makeRelativeTo(CRUD_PATH);
        } else if (path.segmentCount() == 4 && "autocrud".equals(path.segment(1))) {
            path = path.removeFirstSegments(2);
        }
        String pkg = path.segment(0);
        if (pkg != null) {
            String[] split = pkg.split("\\?");
            if (split == null || split.length == 0) {
                return null;
            }
            pkg = split[0];
            try {
                IResource bm = BMUtil.getBMResourceFromClassPath(file.getProject(), pkg);
                if (bm instanceof IFile && bm.exists()) {
                    return (IFile)bm;
                }
            }
            catch (ApplicationException e) {
                DialogUtil.logErrorException(e);
                e.printStackTrace();
            }
        }
        return null;
    }

    public static IContainer findWebInf(IResource resource) {
        if (resource == null) {
            return null;
        }
        IFolder webINF = null;
        IProject project = resource.getProject();
        try {
            String web = project.getPersistentProperty(ProjectPropertyPage.WebQN);
            if (web != null) {
                IPath webINFPath = new Path(web).append("WEB-INF");
                webINF = project.getParent().getFolder(webINFPath);
            }
        }
        catch (CoreException web) {
            // empty catch block
        }
        if (webINF != null && webINF.exists()) {
            return webINF;
        }
        try {
            WebInfFinder finder = new WebInfFinder();
            project.accept((IResourceVisitor)finder);
            return finder.getFolder();
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static IContainer findBMHome(IResource resource) {
        if (resource == null) {
            return null;
        }
        IFolder bmHome = null;
        IProject project = resource.getProject();
        try {
            String bm = project.getPersistentProperty(ProjectPropertyPage.BMQN);
            Path bmPath = new Path(bm);
            bmHome = project.getParent().getFolder((IPath)bmPath);
        }
        catch (CoreException bm) {
            // empty catch block
        }
        if (bmHome != null && bmHome.exists()) {
            return bmHome;
        }
        IContainer webINF = PathUtil.findWebInf(resource);
        if (webINF != null && webINF.exists()) {
            IFolder classes = webINF.getFolder((IPath)new Path("classes"));
            return classes.exists() ? classes : null;
        }
        return null;
    }

    public static IFile findBMFileByPKG(Object pkg) {
        try {
            IResource file = BMUtil.getBMResourceFromClassPath((String)pkg);
            if (file instanceof IFile && "bm".equalsIgnoreCase(file.getFileExtension())) {
                return (IFile)file;
            }
        }
        catch (ApplicationException applicationException) {
            // empty catch block
        }
        return null;
    }

    public static IFile findScreenFile(IFile file, Object pkg) {
        if (pkg instanceof String) {
            IFile sourceFile;
            IPath sourceFilePath;
            String[] split;
            IContainer webInf = PathUtil.findWebInf((IResource)file);
            if (webInf == null) {
                return null;
            }
            IContainer webRoot = webInf.getParent();
            IContainer parent = file.getParent();
            IPath parentPath = parent.getFullPath();
            IPath rootPath = webRoot.getFullPath();
            Path path = new Path((String)pkg);
            boolean prefixOfRequest = REQUEST_PATH.isPrefixOf((IPath)path);
            if (prefixOfRequest) {
                path = path.makeRelativeTo(REQUEST_PATH);
            }
            if ((split = path.toString().split("\\?")) == null || split.length == 0) {
                return null;
            }
            path = new Path(split[0]);
            if (path.segmentCount() == 0) {
                return null;
            }
            IPath relativePath = parentPath.makeRelativeTo(rootPath);
            boolean prefixOf = relativePath.isPrefixOf((IPath)path);
            if (prefixOf || prefixOfRequest) {
                sourceFilePath = rootPath.append((IPath)path);
                if (sourceFilePath.segmentCount() < 2) {
                    return null;
                }
                sourceFile = file.getProject().getParent().getFile(sourceFilePath);
                if (sourceFile.exists()) {
                    return sourceFile;
                }
            } else {
                IFile sourceFile2 = parent.getFile((IPath)path);
                if (sourceFile2.exists()) {
                    return sourceFile2;
                }
            }
            if ((sourceFilePath = rootPath.append((IPath)path)).segmentCount() < 2) {
                return null;
            }
            sourceFile = file.getProject().getParent().getFile(sourceFilePath);
            if (sourceFile.exists()) {
                return sourceFile;
            }
        }
        return null;
    }

    public static String findScreenUrl(IFile file, Object pkg) {
        if (pkg instanceof String) {
            String[] split;
            Path requestPath = new Path("${/request/@context_path}");
            Path path = new Path((String)pkg);
            boolean prefixOfRequest = requestPath.isPrefixOf((IPath)path);
            if (prefixOfRequest) {
                path = path.makeRelativeTo((IPath)requestPath);
            }
            if ((split = path.toString().split("\\?")) == null || split.length == 0) {
                return "";
            }
            path = new Path(split[0]);
            if (path.segmentCount() == 0) {
                return "";
            }
            return path.toString();
        }
        return "";
    }

    public static String toBMPKG(IFile file) {
        IPath path = file.getProjectRelativePath().removeFileExtension();
        return PathUtil.toPKG(path);
    }

    public static String toPKG(IPath path) {
        String[] segments = path.segments();
        StringBuilder result = new StringBuilder();
        StringBuilder _result = new StringBuilder();
        int classes_idx = -1;
        int i = 0;
        while (i < segments.length) {
            _result.append(segments[i]);
            if (i != segments.length - 1) {
                _result.append(".");
            }
            if (classes_idx != -1) {
                result.append(segments[i]);
                if (i != segments.length - 1) {
                    result.append(".");
                }
            }
            if ("classes".equals(segments[i])) {
                classes_idx = i;
            }
            ++i;
        }
        if (result.length() == 0) {
            result = _result;
        }
        return result.toString();
    }

    public static String toRelativeClassesPKG(IPath path) {
        String[] segments = path.segments();
        StringBuilder result = new StringBuilder();
        int classes_idx = -1;
        int i = 0;
        while (i < segments.length) {
            if (classes_idx != -1) {
                result.append(segments[i]);
                if (i != segments.length - 1) {
                    result.append(".");
                }
            }
            if ("classes".equals(segments[i])) {
                classes_idx = i;
            }
            ++i;
        }
        return result.toString();
    }

    public static String getPKG(IPath path) {
        String fileExtension = path.getFileExtension();
        if ("bm".equalsIgnoreCase(fileExtension)) {
            return PathUtil.toPKG(path.removeFileExtension());
        }
        if ("screen".equalsIgnoreCase(fileExtension)) {
            return path.toString();
        }
        if ("svc".equalsIgnoreCase(fileExtension)) {
            return path.toString();
        }
        return "";
    }

    public static String getPathInScreen(IFile file) {
        IProject project = file.getProject();
        String webHome = "";
        try {
            webHome = ProjectUtil.getWebHome(project);
        }
        catch (ApplicationException e) {
            DialogUtil.logErrorException(e);
            e.printStackTrace();
        }
        Path webPath = new Path(webHome);
        IPath fullPath = file.getFullPath();
        IPath makeRelativeTo = fullPath.makeRelativeTo((IPath)webPath);
        return PathUtil.getPKG(makeRelativeTo);
    }

    public static boolean isAuroraFile(IFile file) {
        String fileExtension = PathUtil.getFileExtension(file);
        return PathUtil.isExists(file) && AURORA_FILE_EXTENSION.contains(fileExtension.toLowerCase());
    }

    public static String getFileExtension(IFile file) {
        String fileExtension = file.getFileExtension() == null ? "" : file.getFileExtension();
        return fileExtension;
    }

    private static boolean isExists(IFile file) {
        return file != null && file.exists();
    }

    public static boolean isBMFile(IFile file) {
        String fileExtension = PathUtil.getFileExtension(file);
        return PathUtil.isExists(file) && "bm".equals(fileExtension.toLowerCase());
    }

    public static boolean isConfigFile(IFile file) {
        String fileExtension = PathUtil.getFileExtension(file);
        return PathUtil.isExists(file) && AURORA_CONFIG_FILE_EXTENSION.contains(fileExtension.toLowerCase());
    }

    private static class WebInfFinder
    implements IResourceVisitor {
        private IFolder folder = null;

        private WebInfFinder() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (this.folder != null) {
                return false;
            }
            if (resource.getType() == 2) {
                if ("WEB-INF".equals(resource.getName())) {
                    this.folder = (IFolder)resource;
                    return false;
                }
                return true;
            }
            return resource.getType() != 1;
        }

        public IFolder getFolder() {
            return this.folder;
        }
    }
}

