/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.helpers;

import aurora.ide.AuroraProjectNature;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.AuroraResourceUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.helpers.SystemException;
import aurora.ide.project.propertypage.ProjectPropertyPage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectUtil {
    public static List<IProject> getALLAuroraProjects() {
        IProject[] projects;
        ArrayList<IProject> r = new ArrayList<IProject>();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = projects = workspace.getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            try {
                boolean hasAuroraNature = AuroraProjectNature.hasAuroraNature(p);
                if (hasAuroraNature) {
                    r.add(p);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
        return r;
    }

    public static boolean isDebugMode(IProject project) {
        if (project == null) {
            return false;
        }
        try {
            if ("true".equals(project.getPersistentProperty(ProjectPropertyPage.DebugModeQN))) {
                return true;
            }
        }
        catch (CoreException e) {
            DialogUtil.logErrorException(e);
        }
        return false;
    }

    public static String getWebHome(IProject project) throws ApplicationException {
        if (project == null) {
            throw new ApplicationException("project\u53c2\u6570\u662f\u7a7a\uff01");
        }
        String webHome = null;
        try {
            webHome = project.getPersistentProperty(ProjectPropertyPage.WebQN);
            if (ProjectPropertyPage.filtEmpty(webHome) == null) {
                webHome = ProjectUtil.autoGetWebHome(project);
                if (ProjectPropertyPage.filtEmpty(webHome) != null) {
                    return webHome;
                }
                if (ProjectUtil.openProjectPropertyPage(project) == 0) {
                    webHome = project.getPersistentProperty(ProjectPropertyPage.WebQN);
                }
            }
        }
        catch (CoreException e) {
            throw new SystemException(e);
        }
        return webHome;
    }

    public static String getBMHome(IProject project) throws ApplicationException {
        if (project == null) {
            throw new ApplicationException("project\u53c2\u6570\u662f\u7a7a\uff01");
        }
        String bmHome = null;
        try {
            bmHome = project.getPersistentProperty(ProjectPropertyPage.BMQN);
            if (ProjectPropertyPage.filtEmpty(bmHome) == null) {
                bmHome = ProjectUtil.autoGetBMHome(project);
                if (ProjectPropertyPage.filtEmpty(bmHome) != null) {
                    return bmHome;
                }
                if (ProjectUtil.openProjectPropertyPage(project) == 0) {
                    bmHome = project.getPersistentProperty(ProjectPropertyPage.BMQN);
                }
            }
        }
        catch (CoreException e) {
            throw new SystemException(e);
        }
        if (ProjectPropertyPage.filtEmpty(bmHome) == null) {
            throw new ApplicationException("\u8bbe\u7f6eBM\u76ee\u5f55\u5931\u8d25\uff01");
        }
        return bmHome;
    }

    public static String getWebHomeLocalPath(IProject project) throws ApplicationException {
        String webBaseDir = ProjectUtil.getWebHome(project);
        if (ProjectPropertyPage.filtEmpty(webBaseDir) == null) {
            throw new ApplicationException("\u83b7\u53d6Web\u76ee\u5f55\u5931\u8d25\uff01");
        }
        Path path = new Path(webBaseDir);
        return AuroraResourceUtil.getLocalPathFromIPath((IPath)path);
    }

    public static int openProjectPropertyPage(IProject project) {
        PreferenceDialog propertyDialog = PreferencesUtil.createPropertyDialogOn((Shell)Display.getCurrent().getActiveShell(), (IAdaptable)project, (String)"aurora.ide.projectproperty", (String[])new String[]{"aurora.ide.projectproperty"}, null);
        return propertyDialog.open();
    }

    public static String getBMHomeLocalPath(IProject project) throws ApplicationException {
        String bmBaseDir = ProjectUtil.getBMHome(project);
        if (ProjectUtil.filteEmptyString(bmBaseDir) == null) {
            throw new ApplicationException("\u83b7\u53d6BM\u76ee\u5f55\u5931\u8d25\uff01");
        }
        Path path = new Path(bmBaseDir);
        return AuroraResourceUtil.getLocalPathFromIPath((IPath)path);
    }

    public static String getLocalWebUrl(IProject project) throws ApplicationException {
        if (project == null) {
            throw new ApplicationException("project\u53c2\u6570\u662f\u7a7a\uff01");
        }
        String localWebUrl = null;
        try {
            localWebUrl = project.getPersistentProperty(ProjectPropertyPage.LoclaUrlHomeQN);
            if (ProjectPropertyPage.filtEmpty(localWebUrl) == null && ProjectUtil.openProjectPropertyPage(project) == 0) {
                localWebUrl = project.getPersistentProperty(ProjectPropertyPage.LoclaUrlHomeQN);
            }
        }
        catch (CoreException e) {
            throw new SystemException(e);
        }
        if (ProjectPropertyPage.filtEmpty(localWebUrl) == null) {
            throw new ApplicationException("\u6ca1\u8bbe\u7f6e\u672c\u673a\u670d\u52a1\u5668\u4e3b\u9875\u9762");
        }
        return localWebUrl;
    }

    public static String filteEmptyString(String str) {
        if ("".equals(str)) {
            return null;
        }
        return str;
    }

    public static String autoGetWebHome(IProject project) throws SystemException {
        String errorMessage;
        IResource webInf = AuroraResourceUtil.getResource((IContainer)project, "web-inf");
        if (webInf == null) {
            return null;
        }
        IContainer webDir = webInf.getParent();
        if (webDir.exists() && (errorMessage = ProjectPropertyPage.validWebHome(project, webDir.getFullPath())) == null) {
            String webDirPath = webDir.getFullPath().toString();
            try {
                project.setPersistentProperty(ProjectPropertyPage.WebQN, webDirPath);
            }
            catch (CoreException e) {
                throw new SystemException(e);
            }
            return webDirPath;
        }
        return null;
    }

    public static String autoGetBMHome(IProject project) throws SystemException {
        String errorMessage;
        IResource classesDir = AuroraResourceUtil.getResource((IContainer)project, "classes");
        if (classesDir == null) {
            return null;
        }
        if (classesDir.exists() && (errorMessage = ProjectPropertyPage.validBMHome(project, classesDir.getFullPath())) == null) {
            String classesDirPath = classesDir.getFullPath().toString();
            try {
                project.setPersistentProperty(ProjectPropertyPage.BMQN, classesDirPath);
            }
            catch (CoreException e) {
                throw new SystemException(e);
            }
            return classesDirPath;
        }
        return null;
    }

    public static String autoGetLocalWebUrl(IProject project) throws ApplicationException {
        String defaultUrl = "http://127.0.0.1:8080/" + project.getName();
        try {
            project.setPersistentProperty(ProjectPropertyPage.LoclaUrlHomeQN, defaultUrl);
        }
        catch (CoreException e) {
            throw new SystemException(e);
        }
        return defaultUrl;
    }

    public static IProject getIProjectFromSelection() {
        IResource selection = AuroraResourceUtil.getIResourceSelection();
        if (selection != null) {
            return selection.getProject();
        }
        return null;
    }

    public static IProject getIProjectFromActiveEditor() {
        IEditorInput input;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            activeWorkbenchWindow = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
        }
        if (!((input = activeWorkbenchWindow.getActivePage().getActiveEditor().getEditorInput()) instanceof IFileEditorInput)) {
            return null;
        }
        IFile ifile = ((IFileEditorInput)input).getFile();
        IProject project = ifile.getProject();
        return project;
    }

    public static List getBMSFromProject(IProject project) throws ApplicationException {
        LinkedList bmList = new LinkedList();
        if (project == null) {
            return bmList;
        }
        String bmHome = ProjectUtil.getBMHome(project);
        if (bmHome == null) {
            return bmList;
        }
        IResource bmRoot = ResourcesPlugin.getWorkspace().getRoot().findMember(bmHome);
        if (bmRoot == null || !bmRoot.exists() || !(bmRoot instanceof IContainer)) {
            return bmList;
        }
        IContainer parent = (IContainer)bmRoot;
        AuroraResourceUtil.iteratorResource(parent, bmList);
        return bmList;
    }
}

