/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.navigator;

import aurora.ide.AuroraProjectNature;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.navigator.BMFile;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class BMHierarchyViewerTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IFile file;
        if (!(receiver instanceof IResource)) {
            return false;
        }
        IResource resc = (IResource)receiver;
        IProject proejct = resc.getProject();
        try {
            if (proejct == null || !proejct.isOpen() || !AuroraProjectNature.hasAuroraNature(proejct)) {
                return false;
            }
        }
        catch (CoreException e) {
            DialogUtil.logErrorException(e);
            return false;
        }
        if (receiver instanceof BMFile) {
            return true;
        }
        if (receiver instanceof IFile && (file = (IFile)receiver).getName().toLowerCase().endsWith(".bm")) {
            return true;
        }
        if (!(receiver instanceof IContainer)) {
            return false;
        }
        IContainer container = (IContainer)receiver;
        try {
            return this.isValidDir(container);
        }
        catch (CoreException e) {
            DialogUtil.logErrorException(e);
            return false;
        }
    }

    private boolean isValidDir(IContainer container) throws CoreException {
        IResource[] childs = container.members();
        int i = 0;
        while (i < childs.length) {
            IResource child = childs[i];
            if (child instanceof IFile && child.getName().toLowerCase().endsWith(".bm")) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

