/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.preferencepages;

import aurora.ide.AuroraPlugin;
import aurora.ide.helpers.SystemException;
import java.io.IOException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;

public class AuroraTemplateManager {
    private static final String CUSTOM_TEMPLATES_KEY = "aurora.ide.customtemplates";
    private static AuroraTemplateManager instance;
    private TemplateStore store;
    private ContributionContextTypeRegistry registry;

    private AuroraTemplateManager() {
    }

    public static AuroraTemplateManager getInstance() {
        if (instance == null) {
            instance = new AuroraTemplateManager();
        }
        return instance;
    }

    public TemplateStore getTemplateStore() throws SystemException {
        if (this.store == null) {
            this.store = new ContributionTemplateStore(this.getContextTypeRegistry(), AuroraPlugin.getDefault().getPreferenceStore(), CUSTOM_TEMPLATES_KEY);
            try {
                this.store.load();
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
        }
        return this.store;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        if (this.registry == null) {
            this.registry = new ContributionContextTypeRegistry();
        }
        this.registry.addContextType("aurora.ide.new_screen");
        this.registry.addContextType("aurora.ide.sign");
        return this.registry;
    }

    public IPreferenceStore getPreferenceStore() {
        return AuroraPlugin.getDefault().getPreferenceStore();
    }
}

