/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.preferencepages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TagTree {
    private TagTree parent;
    private String namespace;
    private String tag;
    private List<TagTree> children = new ArrayList<TagTree>();

    public TagTree() {
    }

    public TagTree(TagTree parent, String namespace, String tag) {
        this.parent = parent;
        this.namespace = namespace;
        this.tag = tag;
    }

    public void Add(String namespace, String tag) {
        TagTree te2;
        for (TagTree te2 : this.children) {
            if (!te2.namespace.equals(namespace)) continue;
            TagTree t = new TagTree(te2, namespace, tag);
            if (!te2.children.contains(t)) {
                te2.children.add(t);
            }
            return;
        }
        te2 = new TagTree(this, namespace, namespace);
        te2.children.add(new TagTree(te2, namespace, tag));
        this.children.add(te2);
    }

    public boolean equals(Object anObject) {
        if (anObject instanceof TagTree) {
            TagTree tt = (TagTree)anObject;
            return tt.namespace.equals(this.namespace) && tt.tag.equals(this.tag);
        }
        return false;
    }

    public boolean contains(Object anObject) {
        if (anObject instanceof TagTree) {
            TagTree object = (TagTree)anObject;
            for (TagTree te : this.children) {
                if (!te.namespace.equals(object.tag)) continue;
                return true;
            }
        }
        return false;
    }

    public TagTree find(String namespace, String tag) {
        if (this.namespace.equals(namespace) && this.tag.equals(tag)) {
            return this;
        }
        if (this.children.size() == 0) {
            return null;
        }
        for (TagTree child : this.children) {
            TagTree t = child.find(namespace, tag);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public TagTree remove(String namespace, String tag) {
        TagTree t = this.find(namespace, tag);
        if (t != null) {
            t.getParent().getChildren().remove(t);
            if (t.getParent().getChildren().size() == 0) {
                return this.remove(t.getParent().getNamespace(), t.getParent().getTag());
            }
            return t;
        }
        return null;
    }

    public void sort(boolean ignoreCase) {
        List<TagTree> list = this.children;
        int i = 0;
        while (list != null && i < list.size()) {
            int j = i + 1;
            while (j < list.size()) {
                TagTree temp;
                if (!ignoreCase) {
                    if (list.get(i).getTag().compareTo(list.get(j).getTag()) > 0) {
                        temp = list.get(i);
                        list.set(i, list.get(j));
                        list.set(j, temp);
                    }
                } else if (list.get(i).getTag().compareToIgnoreCase(list.get(j).getTag()) > 0) {
                    temp = list.get(i);
                    list.set(i, list.get(j));
                    list.set(j, temp);
                }
                ++j;
            }
            list.get(i).sort(true);
            ++i;
        }
    }

    public Map<String, List<String>> getMap() {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (TagTree child : this.children) {
            map.put(child.namespace, new ArrayList());
            for (TagTree t : child.children) {
                ((List)map.get(child.namespace)).add(t.tag);
            }
        }
        return map;
    }

    public void removeAll() {
        this.children.clear();
    }

    public String toString() {
        return this.tag;
    }

    public TagTree getParent() {
        return this.parent;
    }

    public void setParent(TagTree parent) {
        this.parent = parent;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public List<TagTree> getChildren() {
        return this.children;
    }

    public void setChildren(List<TagTree> children) {
        this.children = children;
    }
}

