/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.refactor.screen;

import aurora.ide.refactor.screen.ScreenCustomerIDGen;
import aurora.ide.search.core.AbstractMatch;
import aurora.ide.search.core.CompositeMapMatch;
import aurora.ide.search.screen.custom.ScreenCustomService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import uncertain.composite.CompositeMap;

public class ScreenCustomerRefactoring
extends Refactoring {
    private IStructuredSelection selection;
    private List<IResource> scopes = new ArrayList<IResource>();
    private Map<IFile, TextFileChange> changeMap = new HashMap<IFile, TextFileChange>();

    public ScreenCustomerRefactoring(IStructuredSelection selection) {
        this.selection = selection;
        this.init(selection);
    }

    private void init(IStructuredSelection selection) {
        if (selection == null) {
            return;
        }
        for (Object next : selection) {
            if (!(next instanceof IResource) || !"screen".equalsIgnoreCase(((IResource)next).getFileExtension()) && ((IResource)next).getType() != 2) continue;
            this.scopes.add((IResource)next);
        }
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ArrayList<AbstractMatch> result = new ArrayList<AbstractMatch>();
        for (IResource scope : this.scopes) {
            ScreenCustomService service = new ScreenCustomService(scope);
            List<AbstractMatch> _result = service.service(pm);
            result.addAll(_result);
        }
        CompositeChange changes = new CompositeChange("aurora changes");
        changes.markAsSynthetic();
        ScreenCustomerIDGen gen = new ScreenCustomerIDGen();
        int i = 0;
        while (i < result.size()) {
            CompositeMapMatch object = (CompositeMapMatch)((Object)result.get(i));
            IFile file = (IFile)object.getElement();
            CompositeMap map = object.getMap();
            String id = gen.createID(file, map);
            TextFileChange textFileChange = this.getTextFileChange(file);
            int offset = object.getOriginalOffset();
            ReplaceEdit child = new ReplaceEdit(offset, 0, " " + id);
            textFileChange.addEdit((TextEdit)child);
            ++i;
        }
        changes.addAll((Change[])this.changeMap.values().toArray(new TextFileChange[this.changeMap.size()]));
        return changes;
    }

    private TextFileChange getTextFileChange(IFile file) {
        TextFileChange textFileChange = this.changeMap.get(file);
        if (textFileChange == null) {
            textFileChange = new TextFileChange("Screens Changes", file);
            textFileChange.setSaveMode(2);
            textFileChange.setEdit((TextEdit)new MultiTextEdit());
            this.changeMap.put(file, textFileChange);
        }
        return textFileChange;
    }

    public String getName() {
        return "screen custom";
    }
}

