/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.refactoring;

import aurora.ide.refactoring.TextFileChangeManager;
import aurora.ide.search.core.CompositeMapInDocument;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RemoveElementRefactoring
extends Refactoring {
    private CompositeMapInDocument[] lines;
    private TextFileChangeManager changeManager;

    public RemoveElementRefactoring(CompositeMapInDocument[] lines) {
        this.lines = lines;
        this.init(lines);
        this.changeManager = new TextFileChangeManager();
    }

    private void init(CompositeMapInDocument[] lines) {
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange changes = new CompositeChange("aurora changes");
        changes.markAsSynthetic();
        CompositeMapInDocument[] compositeMapInDocumentArray = this.lines;
        int n = this.lines.length;
        int n2 = 0;
        while (n2 < n) {
            CompositeMapInDocument line = compositeMapInDocumentArray[n2];
            IFile file = line.getFile();
            TextFileChange textFileChange = this.getTextFileChange(file);
            IRegion start = line.getStart();
            IRegion end = line.getEnd();
            int length = end.getOffset() - start.getOffset() + end.getLength();
            boolean overlapping = this.changeManager.isOverlapping(file, start.getOffset(), length);
            if (!overlapping) {
                ReplaceEdit child = new ReplaceEdit(start.getOffset(), length, "");
                try {
                    textFileChange.addEdit((TextEdit)child);
                }
                catch (MalformedTreeException malformedTreeException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        changes.addAll((Change[])this.changeManager.getAllChanges());
        return changes;
    }

    private TextFileChange getTextFileChange(IFile file) {
        return this.changeManager.getTextFileChange(file);
    }

    public String getName() {
        return "Remove ELement";
    }
}

