/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.action;

import aurora.ide.AuroraPlugin;
import aurora.ide.refactoring.ui.AuroraRefactoringWizard;
import aurora.ide.search.action.IActionChangedListener;
import aurora.ide.search.action.ISearchResultPageAction;
import aurora.ide.search.cache.CacheManager;
import aurora.ide.search.core.AbstractMatch;
import aurora.ide.search.core.AuroraSearchResult;
import aurora.ide.search.ui.LineElement;
import aurora.ide.search.ui.MessageFormater;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSearchResultPageAction
implements ISearchResultPageAction {
    private TreeSelection treeSelection;
    private TreeViewer treeViewer;
    private Shell shell;
    private int lastSize;
    private List<IActionChangedListener> listeners;

    @Override
    public void addActionChangedListener(IActionChangedListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IActionChangedListener>();
        }
        this.listeners.add(listener);
    }

    protected void notifyActionChanged() {
        if (this.listeners != null) {
            for (IActionChangedListener l : this.listeners) {
                l.actionChanged(this);
            }
        }
    }

    @Override
    public void selectionChanged(SelectionChangedEvent event) {
        Object source;
        this.treeSelection = null;
        this.treeViewer = null;
        ISelection selection = event.getSelection();
        if (selection instanceof TreeSelection) {
            this.treeSelection = (TreeSelection)selection;
        }
        if ((source = event.getSource()) instanceof TreeViewer) {
            this.treeViewer = (TreeViewer)source;
        }
    }

    public AbstractSearchResultPageAction(Shell shell) {
        this.shell = shell;
    }

    protected void excuteRefactoring(final Refactoring refactor) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                AuroraRefactoringWizard wizard = new AuroraRefactoringWizard(refactor);
                RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
                try {
                    op.run(AbstractSearchResultPageAction.this.shell, "Aurora Refactoring");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public boolean isRefactorSelectionEnabled() {
        boolean isEmpty;
        boolean bl = isEmpty = this.treeSelection != null && !this.treeSelection.isEmpty();
        if (isEmpty) {
            TreeSelection treeSelection = this.getTreeSelection();
            for (Object next : treeSelection) {
                if (next instanceof LineElement) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isRefactorAllEnabled() {
        return this.getSearchResult() != null;
    }

    @Override
    public void runAll() {
        try {
            AuroraPlugin.getDefault().getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        AbstractSearchResultPageAction.this.runAllInThread(monitor);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void runAllInThread(IProgressMonitor monitor) {
        if (this.isRefactorAllEnabled()) {
            monitor.beginTask("scaning changes count", -1);
            List<LineElement> lines = this.geAllLineElement();
            this.runInThread(lines, monitor);
        }
    }

    protected void runSelectionInThread(IProgressMonitor monitor) {
        if (this.isRefactorSelectionEnabled()) {
            monitor.beginTask("scaning changes count", -1);
            List lines = this.getSelectionLineElement();
            this.runInThread(lines, monitor);
        }
    }

    @Override
    public void runSelection() {
        try {
            AuroraPlugin.getDefault().getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        AbstractSearchResultPageAction.this.runSelectionInThread(monitor);
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public TreeSelection getTreeSelection() {
        return this.treeSelection;
    }

    public void setTreeSelection(TreeSelection treeSelection) {
        this.treeSelection = treeSelection;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void setTreeViewer(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    public AuroraSearchResult getSearchResult() {
        Object input;
        if (this.treeViewer != null && (input = this.treeViewer.getInput()) instanceof AuroraSearchResult) {
            return (AuroraSearchResult)((Object)input);
        }
        return null;
    }

    public Shell getShell() {
        return this.shell;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    protected List<LineElement> geAllLineElement() {
        Object[] elements;
        ArrayList<LineElement> lines = new ArrayList<LineElement>();
        AuroraSearchResult searchResult = this.getSearchResult();
        Object[] objectArray = elements = searchResult.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Match[] matches;
            Object o = objectArray[n2];
            Match[] matchArray = matches = searchResult.getMatches(o);
            int n3 = matches.length;
            int n4 = 0;
            while (n4 < n3) {
                LineElement lineElement;
                Match m = matchArray[n4];
                if (m instanceof AbstractMatch && (lineElement = ((AbstractMatch)m).getLineElement()) != null && !lines.contains(lineElement)) {
                    lines.add(lineElement);
                }
                ++n4;
            }
            ++n2;
        }
        return lines;
    }

    protected IDocument getDocument(IFile file) throws CoreException {
        return CacheManager.getDocument(file);
    }

    protected List getSelectionLineElement() {
        TreeSelection treeSelection = this.getTreeSelection();
        return treeSelection.toList();
    }

    protected void runInThread(final List lines, final IProgressMonitor monitor) {
        this.lastSize = 0;
        Job monitorUpdateJob = new Job("Aurora Search progress"){

            public IStatus run(IProgressMonitor inner) {
                monitor.beginTask("scaning changes", lines.size());
                while (!inner.isCanceled()) {
                    int infoSize = AbstractSearchResultPageAction.this.getInfoSize();
                    if (infoSize != 0) {
                        monitor.worked(infoSize - AbstractSearchResultPageAction.this.lastSize);
                        AbstractSearchResultPageAction.this.lastSize = infoSize;
                        Object[] args = new Object[]{AbstractSearchResultPageAction.this.getSubTaskName(), new Integer(AbstractSearchResultPageAction.this.lastSize), new Integer(lines.size())};
                        monitor.subTask(MessageFormater.format("Scanning file {1} of {2}: {0}", args));
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        return Status.OK_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        monitorUpdateJob.setSystem(true);
        monitorUpdateJob.schedule();
        try {
            Refactoring refactor = this.createRefactoring(lines, monitor);
            this.excuteRefactoring(refactor);
        }
        finally {
            monitorUpdateJob.cancel();
        }
    }

    protected abstract int getInfoSize();

    protected abstract String getSubTaskName();

    protected abstract Refactoring createRefactoring(List var1, IProgressMonitor var2);
}

