/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.action;

import aurora.ide.editor.textpage.ColorManager;
import aurora.ide.editor.textpage.IColorConstants;
import aurora.ide.editor.textpage.TextPage;
import aurora.ide.editor.textpage.scanners.XMLTagScanner;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.CompositeMapLocatorParser;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.SystemException;
import aurora.ide.search.core.AbstractSearchQuery;
import aurora.ide.search.core.AbstractSearchService;
import aurora.ide.search.core.SearchQueryFactory;
import aurora.ide.search.core.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;
import uncertain.schema.Element;
import uncertain.schema.IType;
import uncertain.schema.SimpleType;

public class FieldReferenceAction
implements IEditorActionDelegate {
    private IFile sourceFile;
    private TextPage textPage;
    private XMLTagScanner tagScanner;
    private TextSelection selection;
    private AbstractSearchQuery query;

    public void run(IAction action) {
        if (this.query != null) {
            NewSearchUI.runQueryInBackground((ISearchQuery)this.query);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean isEnable = this.checkSelection(selection);
        if (action != null) {
            action.setEnabled(isEnable);
        }
    }

    private boolean checkSelection(ISelection sel) {
        if (this.textPage == null) {
            return false;
        }
        if (!(sel instanceof TextSelection)) {
            return false;
        }
        this.selection = (TextSelection)sel;
        if (this.selection.getStartLine() != this.selection.getEndLine()) {
            return false;
        }
        Attribute attribute = this.getAttribute(this.selection);
        if (attribute == null) {
            return false;
        }
        this.query = this.createSearchQuery(attribute, this.selection);
        return this.query != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AbstractSearchQuery createSearchQuery(Attribute att, TextSelection selection) {
        String content = this.textPage.getContent();
        try {
            uncertain.schema.Attribute attrib;
            IDocument document = this.textPage.getInputDocument();
            int offset = selection.getOffset();
            CompositeMap map = this.locateCompositeMap(content, document.getLineOfOffset(offset));
            if (map == null) {
                return null;
            }
            Object value = map.get((Object)att.name);
            if (!att.value.equals(value)) return null;
            Element element = CompositeMapUtil.getElement(map);
            if (element == null) return null;
            List attrib_list = element.getAllAttributes();
            Iterator it = attrib_list.iterator();
            do {
                if (!it.hasNext()) {
                    return null;
                }
                attrib = (uncertain.schema.Attribute)it.next();
            } while (!att.name.equalsIgnoreCase(attrib.getName()));
            IType attributeType = attrib.getAttributeType();
            IFile sourceFile = this.getSourceFile(map, attrib);
            IResource scope = Util.getScope((IResource)sourceFile);
            if (scope == null) return null;
            if (sourceFile == null) {
                return null;
            }
            QualifiedName referenceTypeQName = ((SimpleType)attributeType).getReferenceTypeQName();
            if (!AbstractSearchService.datasetReference.equals((Object)referenceTypeQName)) return SearchQueryFactory.createSearchQuery(referenceTypeQName, scope, sourceFile, document.get(selection.getOffset(), selection.getLength()));
            scope = sourceFile;
            return SearchQueryFactory.createSearchQuery(referenceTypeQName, scope, sourceFile, document.get(selection.getOffset(), selection.getLength()));
        }
        catch (ApplicationException applicationException) {
            return null;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    private IFile getSourceFile(CompositeMap map, uncertain.schema.Attribute attrib) {
        IType attributeType = attrib.getAttributeType();
        if (attributeType instanceof SimpleType) {
            QualifiedName referenceTypeQName = ((SimpleType)attributeType).getReferenceTypeQName();
            if (AbstractSearchService.foreignFieldReference.equals((Object)referenceTypeQName)) {
                this.sourceFile = Util.findBMFile(map);
                return this.sourceFile;
            }
            if (AbstractSearchService.localFieldReference.equals((Object)referenceTypeQName) || AbstractSearchService.datasetReference.equals((Object)referenceTypeQName)) {
                this.sourceFile = this.getFile();
                return this.sourceFile;
            }
            if (AbstractSearchService.screenReference.equals((Object)referenceTypeQName)) {
                String valueIgnoreCase = CompositeMapUtil.getValueIgnoreCase(attrib, map);
                this.sourceFile = Util.findScreenFile(this.getFile(), valueIgnoreCase);
                return this.sourceFile;
            }
            if (AbstractSearchService.bmReference.equals((Object)referenceTypeQName)) {
                String valueIgnoreCase = CompositeMapUtil.getValueIgnoreCase(attrib, map);
                this.sourceFile = Util.findBMFileByPKG(valueIgnoreCase);
                return this.sourceFile;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Attribute getAttribute(TextSelection selection) {
        IDocument document = this.textPage.getInputDocument();
        int offset = selection.getOffset();
        int length = selection.getLength();
        String name = null;
        try {
            TextAttribute text;
            XMLTagScanner scanner = this.getXMLTagScanner();
            IToken token = null;
            ITypedRegion region = document.getPartition(offset);
            scanner.setRange(document, region.getOffset(), region.getLength());
            do {
                if ((token = scanner.nextToken()) == Token.EOF) {
                    return null;
                }
                if (!(token.getData() instanceof TextAttribute) || !(text = (TextAttribute)token.getData()).getForeground().getRGB().equals((Object)IColorConstants.ATTRIBUTE)) continue;
                name = document.get(scanner.getTokenOffset(), scanner.getTokenLength());
            } while (scanner.getTokenOffset() != offset - 1 || scanner.getTokenLength() != length + 2 || !(token.getData() instanceof TextAttribute) || !(text = (TextAttribute)token.getData()).getForeground().getRGB().equals((Object)IColorConstants.STRING));
            if (name == null) {
                return null;
            }
            Attribute attribute = new Attribute();
            attribute.name = name;
            attribute.value = document.get(offset, length);
            return attribute;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    private CompositeMap locateCompositeMap(String content, int line) throws ApplicationException {
        try {
            CompositeMapLocatorParser parser = new CompositeMapLocatorParser();
            ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes("UTF-8"));
            CompositeMap cm = parser.getCompositeMapFromLine(is, line);
            return cm;
        }
        catch (UnsupportedEncodingException e) {
            throw new SystemException(e);
        }
        catch (SAXException e) {
            throw new ApplicationException("\u8bf7\u68c0\u67e5\u6b64\u6587\u4ef6\u683c\u5f0f\u662f\u5426\u6b63\u786e.", e);
        }
        catch (IOException e) {
            throw new ApplicationException("\u8bf7\u68c0\u67e5\u6b64\u6587\u4ef6\u683c\u5f0f\u662f\u5426\u6b63\u786e.", e);
        }
    }

    private XMLTagScanner getXMLTagScanner() {
        if (this.tagScanner == null) {
            ColorManager manager = new ColorManager();
            this.tagScanner = new XMLTagScanner(manager);
            this.tagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(manager.getColor(IColorConstants.TAG))));
        }
        return this.tagScanner;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.textPage = targetEditor instanceof TextPage ? (TextPage)targetEditor : null;
    }

    public IFile getFile() {
        IFile file = this.textPage.getFile();
        if ("bm".equalsIgnoreCase(file.getFileExtension()) || "screen".equalsIgnoreCase(file.getFileExtension())) {
            return file;
        }
        return null;
    }

    private class Attribute {
        private String name;
        private String value;

        private Attribute() {
        }
    }
}

