/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.condition;

import aurora.ide.editor.textpage.IColorConstants;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.search.condition.MatchInfo;
import aurora.ide.search.condition.SearchCondition;
import aurora.ide.search.core.Util;
import aurora.ide.search.ui.LineElement;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import uncertain.composite.CompositeMap;
import uncertain.schema.Attribute;

public class AttributeCondition
extends SearchCondition {
    private String name;
    private String value;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public SearchCondition read(IDialogSettings s) {
        this.setCaseSensitive(s.getBoolean("isCaseSensitive"));
        this.setName(s.get("name"));
        this.setValue(s.get("value"));
        return this;
    }

    public void store(IDialogSettings s) {
        s.put("isCaseSensitive", this.isCaseSensitive());
        if (this.name != null) {
            s.put("name", this.name);
        }
        if (this.value != null) {
            s.put("value", this.value);
        }
    }

    public boolean isEquals(SearchCondition condition) {
        if (condition instanceof AttributeCondition) {
            String _value;
            String _name = this.name == null ? "" : this.name;
            String string = _value = this.value == null ? "" : this.value;
            return _name.equals(((AttributeCondition)condition).name) && _value.equals(((AttributeCondition)condition).value);
        }
        return super.isEquals(condition);
    }

    public MatchInfo match(CompositeMap map, IDocument document, LineElement l) {
        boolean valueMatch;
        boolean nameMatch = !"".equals(this.name) && this.name != null;
        boolean bl = valueMatch = !"".equals(this.value) && this.value != null;
        if (nameMatch && valueMatch) {
            return this.allMatch(map, document, l);
        }
        if (nameMatch) {
            return this.nameMatch(map, document, l);
        }
        if (valueMatch) {
            return this.valueMatch(map, document, l);
        }
        return MatchInfo.Not_Match;
    }

    private MatchInfo allMatch(CompositeMap map, IDocument document, LineElement l) {
        List mapAttributes = Util.getMapAttributes(map);
        MatchInfo info = new MatchInfo();
        info.setMap(map);
        if (mapAttributes != null) {
            FindReplaceDocumentAdapter dd = new FindReplaceDocumentAdapter(document);
            for (Attribute attrib : mapAttributes) {
                String _value = CompositeMapUtil.getValueIgnoreCase(attrib, map);
                if (_value == null) continue;
                boolean attribMatch = Util.stringMatch(this.name, attrib.getName(), this.isCaseSensitive(), this.isRegularExpression());
                boolean valueMatch = Util.stringMatch(this.value, _value, this.isCaseSensitive(), this.isRegularExpression());
                if (!attribMatch || !valueMatch) continue;
                try {
                    IRegion valueRegion;
                    IRegion documentRegion = Util.getDocumentRegion(l.getOffset(), l.getLength(), attrib.getName(), document, IColorConstants.ATTRIBUTE);
                    if (documentRegion == null || (valueRegion = Util.getValueRegion(documentRegion.getOffset(), l.getLength() - documentRegion.getOffset() + l.getOffset(), _value, document, IColorConstants.STRING)) == null) continue;
                    info.addRegion(valueRegion);
                    info.addRegion(documentRegion);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        if (info.getRegions().size() > 0) {
            return info;
        }
        return MatchInfo.Not_Match;
    }

    private MatchInfo nameMatch(CompositeMap map, IDocument document, LineElement l) {
        List mapAttributes = Util.getMapAttributes(map);
        MatchInfo info = new MatchInfo();
        info.setMap(map);
        if (mapAttributes != null) {
            FindReplaceDocumentAdapter dd = new FindReplaceDocumentAdapter(document);
            for (Attribute attrib : mapAttributes) {
                boolean attribMatch;
                String _value = CompositeMapUtil.getValueIgnoreCase(attrib, map);
                if (_value == null || !(attribMatch = Util.stringMatch(this.name, attrib.getName(), this.isCaseSensitive(), this.isRegularExpression()))) continue;
                try {
                    IRegion documentRegion = Util.getDocumentRegion(l.getOffset(), l.getLength(), attrib.getName(), document, IColorConstants.ATTRIBUTE);
                    if (documentRegion == null) continue;
                    info.addRegion(documentRegion);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        if (info.getRegions().size() > 0) {
            return info;
        }
        return MatchInfo.Not_Match;
    }

    private MatchInfo valueMatch(CompositeMap map, IDocument document, LineElement l) {
        List mapAttributes = Util.getMapAttributes(map);
        MatchInfo info = new MatchInfo();
        info.setMap(map);
        if (mapAttributes != null) {
            FindReplaceDocumentAdapter dd = new FindReplaceDocumentAdapter(document);
            for (Attribute attrib : mapAttributes) {
                boolean valueMatch;
                String _value = CompositeMapUtil.getValueIgnoreCase(attrib, map);
                if (_value == null || !(valueMatch = Util.stringMatch(this.value, _value, this.isCaseSensitive(), this.isRegularExpression()))) continue;
                try {
                    IRegion valueRegion;
                    IRegion documentRegion = Util.getDocumentRegion(l.getOffset(), l.getLength(), attrib.getName(), document, IColorConstants.ATTRIBUTE);
                    if (documentRegion == null || (valueRegion = Util.getValueRegion(documentRegion.getOffset(), l.getLength() - documentRegion.getOffset() + l.getOffset(), _value, document, IColorConstants.STRING)) == null) continue;
                    info.addRegion(valueRegion);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        if (info.getRegions().size() > 0) {
            return info;
        }
        return MatchInfo.Not_Match;
    }
}

