/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.core;

import aurora.ide.search.condition.AuroraSearchPattern;
import aurora.ide.search.core.AbstractSearchQuery;
import aurora.ide.search.core.AbstractSearchResult;
import aurora.ide.search.core.AbstractSearchService;
import aurora.ide.search.core.AuroraSearchResult;
import aurora.ide.search.core.AuroraSearchService;
import aurora.ide.search.core.ISearchService;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.search.ui.text.FileTextSearchScope;

public class AuroraSearchQuery
extends AbstractSearchQuery {
    private AuroraSearchResult fResult;
    private IResource[] roots;
    private ISearchService service;
    private AuroraSearchPattern pattern;

    public AuroraSearchQuery(IResource[] roots, AuroraSearchPattern pattern) {
        this.roots = roots;
        this.pattern = pattern;
    }

    public AuroraSearchQuery(FileTextSearchScope createTextSearchScope, AuroraSearchPattern pattern) {
        this(createTextSearchScope.getRoots(), pattern);
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        return super.run(monitor);
    }

    public String getLabel() {
        return "Aurora Search Query";
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    protected AbstractSearchResult getAruroraSearchResult() {
        if (this.fResult == null) {
            AuroraSearchResult result;
            this.fResult = result = new AuroraSearchResult(this);
        }
        return this.fResult;
    }

    protected ISearchService getSearchService() {
        if (this.service == null) {
            this.service = new AuroraSearchService(this.roots, this.pattern, this);
        }
        return this.service;
    }

    protected void setSearchService(ISearchService service) {
        this.service = service;
    }

    protected IResource[] getRoots() {
        return this.roots;
    }

    protected IResource getSourceFile() {
        return null;
    }

    protected Object getPattern() {
        return this.service == null ? null : ((AbstractSearchService)this.service).getSearchPattern(this.roots, null);
    }

    protected String getSearchInLabel() {
        StringBuilder builder = new StringBuilder();
        if (this.roots != null) {
            IResource[] iResourceArray = this.roots;
            int n = this.roots.length;
            int n2 = 0;
            while (n2 < n) {
                IResource root = iResourceArray[n2];
                if (root.getType() == 8) {
                    builder.append("workspace");
                } else {
                    builder.append(root.getName());
                }
                builder.append(",");
                ++n2;
            }
            int lastIndexOf = builder.lastIndexOf(",");
            if (-1 != lastIndexOf) {
                builder.deleteCharAt(lastIndexOf);
            }
        }
        return builder.toString();
    }
}

