/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.core;

import aurora.ide.search.core.AbstractSearchQuery;
import aurora.ide.search.core.AbstractSearchResult;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public class AuroraSearchResult
extends AbstractSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    private ISearchQuery query;
    private final Match[] EMPTY_ARR = new Match[0];

    public AuroraSearchResult(ISearchQuery query) {
        this.query = query;
    }

    public String getLabel() {
        Object pattern;
        int matchCount = this.getMatchCount();
        if (this.query instanceof AbstractSearchQuery && (pattern = ((AbstractSearchQuery)this.query).getPattern()) != null) {
            String in = ((AbstractSearchQuery)this.query).getSearchInLabel();
            Object[] args = new String[]{pattern.toString(), String.valueOf(matchCount), in};
            return MessageFormat.format("''{0}'' - {1} matches in {2}", args);
        }
        return matchCount + " matches";
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public ISearchQuery getQuery() {
        return this.query;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        return this.getMatches(file);
    }

    public IFile getFile(Object element) {
        if (element instanceof IFile) {
            return (IFile)element;
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        IEditorInput ei = editor.getEditorInput();
        if (ei instanceof IFileEditorInput) {
            IFileEditorInput fi = (IFileEditorInput)ei;
            return match.getElement().equals(fi.getFile());
        }
        return false;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IEditorInput ei = editor.getEditorInput();
        if (ei instanceof IFileEditorInput) {
            IFileEditorInput fi = (IFileEditorInput)ei;
            return this.getMatches(fi.getFile());
        }
        return this.EMPTY_ARR;
    }
}

