/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.core;

import aurora.ide.helpers.CompositeMapLocatorParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uncertain.composite.CompositeMap;

public class NoNamespaceMapParser
extends CompositeMapLocatorParser {
    private Map namespaceMapping;

    public NoNamespaceMapParser(Map namespaceMapping) {
        this.namespaceMapping = namespaceMapping;
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
        String[] prefix;
        if (this.namespaceMapping != null && "".equals(namespaceURI) && "".equals(localName) && (prefix = this.getPrefix(rawName)) != null) {
            String namespace = "";
            for (Object key : this.namespaceMapping.keySet()) {
                if (!prefix[0].equals(this.namespaceMapping.get(key))) continue;
                namespace = (String)key;
                break;
            }
            super.startElement(namespace, prefix[1], rawName, atts);
            return;
        }
        super.startElement(namespaceURI, rawName, rawName, atts);
    }

    public void startDocument() {
        super.startDocument();
        if (this.namespaceMapping != null) {
            this.setUri_mapping(this.namespaceMapping);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
    }

    private String[] getPrefix(String rawName) {
        String[] split;
        if (rawName != null && (split = rawName.split(":")).length == 2) {
            return split;
        }
        return null;
    }

    public CompositeMap parseStream(InputStream stream) throws SAXException, IOException {
        SAXParserFactory parser_factory = SAXParserFactory.newInstance();
        parser_factory.setNamespaceAware(false);
        parser_factory.setValidating(false);
        SAXParser parser = null;
        try {
            parser = parser_factory.newSAXParser();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException("error when creating SAXParser", ex);
        }
        parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
        parser.parse(stream, (DefaultHandler)this);
        CompositeMap root = this.getRoot();
        root.setNamespaceMapping(this.namespaceMapping);
        return root;
    }
}

