/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.reference;

import aurora.ide.search.core.AbstractSearchQuery;
import aurora.ide.search.core.AbstractSearchResult;
import aurora.ide.search.core.AbstractSearchService;
import aurora.ide.search.core.AuroraSearchReferenceResult;
import aurora.ide.search.core.ISearchService;
import aurora.ide.search.reference.ReferenceSearchService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.search.ui.ISearchQuery;

public class FileReferenceQuery
extends AbstractSearchQuery {
    private AuroraSearchReferenceResult fResult;
    private IResource scope;
    private IFile sourceFile;
    private ISearchService service;

    public FileReferenceQuery(IResource scope, IFile sourceFile) {
        this.scope = scope;
        this.sourceFile = sourceFile;
    }

    public String getLabel() {
        return "File Reference : " + this.sourceFile.getName();
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    protected AbstractSearchResult getAruroraSearchResult() {
        if (this.fResult == null) {
            AuroraSearchReferenceResult result;
            this.fResult = result = new AuroraSearchReferenceResult(this);
        }
        return this.fResult;
    }

    protected ISearchService getSearchService() {
        if (this.service == null) {
            this.service = new ReferenceSearchService(this.scope, (Object)this.sourceFile, (ISearchQuery)this);
        }
        return this.service;
    }

    protected void setSearchService(ISearchService service) {
        this.service = service;
    }

    protected IResource getScope() {
        return this.scope;
    }

    protected IResource getSourceFile() {
        return this.sourceFile;
    }

    protected Object getPattern() {
        return this.service == null ? null : ((AbstractSearchService)this.service).getSearchPattern(new IResource[]{this.scope}, this.sourceFile);
    }

    protected IResource[] getRoots() {
        return new IResource[]{this.scope};
    }

    protected String getSearchInLabel() {
        return this.scope.getProject().getName();
    }
}

