/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.ui;

import aurora.ide.search.ui.SearchLabelProvider;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class DecoratingSearchLabelProvider
extends DecoratingStyledCellLabelProvider
implements IPropertyChangeListener,
ILabelProvider {
    private static final String HIGHLIGHT_BG_COLOR_NAME = "org.eclipse.jdt.ui.ColoredLabels.match_highlight";
    public static final StyledString.Styler HIGHLIGHT_STYLE = StyledString.createColorRegistryStyler(null, (String)"org.eclipse.jdt.ui.ColoredLabels.match_highlight");

    public DecoratingSearchLabelProvider(SearchLabelProvider provider) {
        super((DelegatingStyledCellLabelProvider.IStyledLabelProvider)provider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null);
    }

    public void initialize(ColumnViewer viewer, ViewerColumn column) {
        PlatformUI.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getColorRegistry().addListener((IPropertyChangeListener)this);
        this.setOwnerDrawEnabled(DecoratingSearchLabelProvider.showColoredLabels());
        super.initialize(viewer, column);
    }

    public void dispose() {
        super.dispose();
        PlatformUI.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getColorRegistry().removeListener((IPropertyChangeListener)this);
    }

    private void refresh() {
        ColumnViewer viewer = this.getViewer();
        if (viewer == null) {
            return;
        }
        boolean showColoredLabels = DecoratingSearchLabelProvider.showColoredLabels();
        if (showColoredLabels != this.isOwnerDrawEnabled()) {
            this.setOwnerDrawEnabled(showColoredLabels);
            viewer.refresh();
        } else if (showColoredLabels) {
            viewer.refresh();
        }
    }

    protected StyleRange prepareStyleRange(StyleRange styleRange, boolean applyColors) {
        if (!applyColors && styleRange.background != null) {
            styleRange = super.prepareStyleRange(styleRange, applyColors);
            styleRange.borderStyle = 4;
            return styleRange;
        }
        return super.prepareStyleRange(styleRange, applyColors);
    }

    public static boolean showColoredLabels() {
        return PlatformUI.getPreferenceStore().getBoolean("USE_COLORED_LABELS");
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals("QUALIFIER_COLOR") || property.equals("COUNTER_COLOR") || property.equals("DECORATIONS_COLOR") || property.equals(HIGHLIGHT_BG_COLOR_NAME) || property.equals("USE_COLORED_LABELS")) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    DecoratingSearchLabelProvider.this.refresh();
                }
            });
        }
    }

    public String getText(Object element) {
        return this.getStyledText(element).getString();
    }
}

