/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.ui;

import aurora.ide.search.action.AddAttributeAction;
import aurora.ide.search.action.ChangeElementAction;
import aurora.ide.search.action.IActionChangedListener;
import aurora.ide.search.action.ISearchResultPageAction;
import aurora.ide.search.action.RemoveAttributeAction;
import aurora.ide.search.action.RemoveElementAction;
import aurora.ide.search.action.ReplaceAttributeAction;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RefactorActionComposite
extends Composite
implements ISelectionChangedListener,
IActionChangedListener {
    private List<Button> radios = new ArrayList<Button>();
    private ISearchResultPageAction[] actions = new ISearchResultPageAction[6];
    private Button refactorSelection;
    private Button refactorAll;

    public RefactorActionComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.createActions(parent, style);
    }

    private void createActions(Composite parent, int style) {
        Group radioGroup = new Group((Composite)this, 0);
        radioGroup.setLayout((Layout)new GridLayout(5, false));
        radioGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.createRemove(radioGroup, (Composite)radioGroup);
        this.createSetAttribute(radioGroup, (Composite)radioGroup);
        this.createChangeElement(radioGroup, (Composite)radioGroup);
        this.createRemoveAttribute(radioGroup, (Composite)radioGroup);
        this.createReplaceAttributeName(radioGroup, (Composite)radioGroup);
        this.createReplaceAttributeValue(radioGroup, (Composite)radioGroup);
        this.refactorSelection = new Button((Composite)this, 8);
        this.refactorSelection.setText("Refactor Selection");
        this.refactorSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RefactorActionComposite.this.getAction().runSelection();
            }
        });
        this.refactorAll = new Button((Composite)this, 8);
        this.refactorAll.setText("Refactor All");
        this.refactorAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RefactorActionComposite.this.getAction().runAll();
            }
        });
        this.updateButton(false, false);
    }

    private void createRemove(Group radioGroup, Composite actionParent) {
        Button radio = this.createButton((Composite)radioGroup, 16, "Remove Element", 0, true);
        this.radios.add(radio);
        this.addSelectionListener(radio);
        Label label = new Label(actionParent, 16384);
        label.setLayoutData((Object)new GridData(4, 4, false, false, 4, 1));
        this.actions[0] = new RemoveElementAction(this.getShell());
    }

    private void addSelectionListener(Button radio) {
        radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISearchResultPageAction action = RefactorActionComposite.this.getAction();
                RefactorActionComposite.this.actionChanged(action);
            }
        });
    }

    private void createSetAttribute(Group radioGroup, Composite actionParent) {
        Button radio = this.createButton((Composite)radioGroup, 16, "Add Attribute:", 1, false);
        this.radios.add(radio);
        this.addSelectionListener(radio);
        Text name = this.createInputBox(actionParent, "attribute name");
        Text value = this.createInputBox(actionParent, "value");
        AddAttributeAction action = new AddAttributeAction(this.getShell());
        action.setControl(name, value);
        action.addActionChangedListener(this);
        this.actions[1] = action;
    }

    private void createChangeElement(Group radioGroup, Composite actionParent) {
        Button radio = this.createButton((Composite)radioGroup, 16, "Change element", 2, false);
        this.radios.add(radio);
        this.addSelectionListener(radio);
        Text namespace = this.createInputBox(actionParent, "namespace");
        Text name = this.createInputBox(actionParent, "element name");
        ChangeElementAction action = new ChangeElementAction(this.getShell());
        action.setControl(namespace, name);
        action.addActionChangedListener(this);
        this.actions[2] = action;
    }

    private void createRemoveAttribute(Group radioGroup, Composite actionParent) {
        Button radio = this.createButton((Composite)radioGroup, 16, "Remove Attribute:", 3, false);
        this.radios.add(radio);
        this.addSelectionListener(radio);
        Text name = this.createInputBox(actionParent, "attribute name");
        Label label = new Label(actionParent, 16384);
        label.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        RemoveAttributeAction action = new RemoveAttributeAction(this.getShell());
        action.setControl(name);
        action.addActionChangedListener(this);
        this.actions[3] = action;
    }

    private void createReplaceAttributeName(Group radioGroup, Composite actionParent) {
        Button radio = this.createButton((Composite)radioGroup, 16, "Replace Attribute Name", 4, false);
        this.radios.add(radio);
        this.addSelectionListener(radio);
        Text replace = this.createInputBox(actionParent, "replace");
        Text with = this.createInputBox(actionParent, "with");
        ReplaceAttributeAction action = new ReplaceAttributeAction(this.getShell(), "name");
        action.setControl(replace, with);
        action.addActionChangedListener(this);
        this.actions[4] = action;
    }

    private void createReplaceAttributeValue(Group radioGroup, Composite actionParent) {
        Button radio = this.createButton((Composite)radioGroup, 16, "Replace Attribute Value", 5, false);
        this.radios.add(radio);
        this.addSelectionListener(radio);
        Text replace = this.createInputBox(actionParent, "replace");
        Text with = this.createInputBox(actionParent, "with");
        ReplaceAttributeAction action = new ReplaceAttributeAction(this.getShell(), "value");
        action.setControl(replace, with);
        action.addActionChangedListener(this);
        this.actions[5] = action;
    }

    private Text createInputBox(Composite actionParent, String text) {
        Label label = new Label(actionParent, 16384);
        label.setText(text);
        label.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        Text box = new Text(actionParent, 2052);
        GridData data = new GridData(4, 4, true, false, 1, 1);
        box.setLayoutData((Object)data);
        return box;
    }

    private Button createButton(Composite parent, int style, String text, int data, boolean isSelected) {
        Button button = new Button(parent, style);
        button.setText(text);
        button.setData((Object)new Integer(data));
        button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        button.setSelection(isSelected);
        return button;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISearchResultPageAction action;
        ISearchResultPageAction[] iSearchResultPageActionArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            action = iSearchResultPageActionArray[n2];
            action.selectionChanged(event);
            ++n2;
        }
        action = this.getAction();
        this.actionChanged(action);
    }

    public void actionChanged(ISearchResultPageAction action) {
        if (!this.getAction().equals(action)) {
            return;
        }
        boolean isAll = action == null ? false : action.isRefactorAllEnabled();
        boolean isSelection = action == null ? false : action.isRefactorSelectionEnabled();
        this.updateButton(isAll, isSelection);
    }

    private ISearchResultPageAction getAction() {
        int index = -1;
        for (Button b : this.radios) {
            if (!b.getSelection()) continue;
            index = (Integer)b.getData();
            break;
        }
        if (index >= 0 && index < this.actions.length) {
            ISearchResultPageAction action = this.actions[index];
            return action;
        }
        return null;
    }

    private void updateButton(boolean isAll, boolean isSelection) {
        this.refactorSelection.setEnabled(isSelection);
        this.refactorAll.setEnabled(isAll);
    }
}

