/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.ui;

import aurora.ide.search.condition.AttributeCondition;
import aurora.ide.search.condition.AuroraSearchPattern;
import aurora.ide.search.condition.ElementCondition;
import aurora.ide.search.condition.NameSpaceCondition;
import aurora.ide.search.condition.SearchCondition;
import aurora.ide.search.condition.SearchForCondition;
import aurora.ide.search.core.AuroraSearchQuery;
import aurora.ide.search.ui.SearchPageManager;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkingSet;

public class SearchPage
extends DialogPage
implements ISearchPage {
    public static final String ID = "aurora.search.SearchPage";
    private Button[] fSearchFor;
    private Combo namespacePattern;
    private Button namespaceCaseSensitive;
    private Combo elementPattern;
    private Button elementCaseSensitive;
    private Combo attributePattern;
    private Combo attValuePattern;
    private Button attributeCaseSensitive;
    private ISearchPageContainer fContainer;
    private SearchPageManager pageManager = new SearchPageManager();
    private boolean fSearchDerived = false;
    private boolean fFirstTime = true;
    private Button namespaceRegEx;
    private Button attributeRegEx;
    private Button elementRegEx;

    public SearchPage() {
    }

    public SearchPage(String title) {
        super(title);
    }

    public SearchPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.readConfiguration();
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.horizontalSpacing = 10;
        result.setLayout((Layout)layout);
        Control searchFor = this.createSearchFor(result);
        searchFor.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Control expressionComposite = this.createExpression(result);
        expressionComposite.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        Label separator = new Label(result, 0);
        separator.setVisible(false);
        GridData data = new GridData(4, 4, false, false, 2, 1);
        data.heightHint = this.convertHeightInCharsToPixels(1) / 3;
        separator.setLayoutData((Object)data);
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
        this.handleChanged();
    }

    private Control createSearchFor(Composite parent) {
        Group result = new Group(parent, 0);
        result.setText("Search for");
        result.setLayout((Layout)new GridLayout(3, true));
        this.fSearchFor = new Button[]{this.createButton((Composite)result, 16, "element", 1, true), this.createButton((Composite)result, 16, "child", 2, false), this.createButton((Composite)result, 16, "parent", 3, false)};
        return result;
    }

    private Button createButton(Composite parent, int style, String text, int data, boolean isSelected) {
        Button button = new Button(parent, style);
        button.setText(text);
        button.setData((Object)new Integer(data));
        button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        button.setSelection(isSelected);
        return button;
    }

    private Control createExpression(Composite parent) {
        Group result = new Group(parent, 0);
        result.setText("Search String(* = any string,? = any character)");
        result.setLayout((Layout)new GridLayout(6, true));
        Label label = new Label((Composite)result, 16384);
        label.setText("Namespace");
        label.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.namespacePattern = new Combo((Composite)result, 2052);
        this.namespacePattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPage.this.handleChanged();
            }
        });
        this.namespacePattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchPage.this.handleChanged();
            }
        });
        GridData data = new GridData(4, 4, true, false, 3, 1);
        data.widthHint = this.convertWidthInCharsToPixels(20);
        this.namespacePattern.setLayoutData((Object)data);
        this.namespaceCaseSensitive = new Button((Composite)result, 32);
        this.namespaceCaseSensitive.setText("Case sensitive");
        this.namespaceCaseSensitive.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.namespaceRegEx = new Button((Composite)result, 32);
        this.namespaceRegEx.setText("Regular e&xpression");
        this.namespaceRegEx.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.namespaceRegEx.setFont(result.getFont());
        label = new Label((Composite)result, 16384);
        label.setText("Element");
        label.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.elementPattern = new Combo((Composite)result, 2052);
        this.elementPattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPage.this.handleChanged();
            }
        });
        this.elementPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchPage.this.handleChanged();
            }
        });
        data = new GridData(4, 4, true, false, 3, 1);
        data.widthHint = this.convertWidthInCharsToPixels(20);
        this.elementPattern.setLayoutData((Object)data);
        this.elementCaseSensitive = new Button((Composite)result, 32);
        this.elementCaseSensitive.setText("Case sensitive");
        this.elementCaseSensitive.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.elementRegEx = new Button((Composite)result, 32);
        this.elementRegEx.setText("Regular e&xpression");
        this.elementRegEx.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.elementRegEx.setFont(result.getFont());
        label = new Label((Composite)result, 16384);
        label.setText("Contains Attribute");
        label.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.attributePattern = new Combo((Composite)result, 2052);
        this.attributePattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPage.this.handleChanged();
            }
        });
        this.attributePattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchPage.this.handleChanged();
            }
        });
        data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = this.convertWidthInCharsToPixels(20);
        this.attributePattern.setLayoutData((Object)data);
        label = new Label((Composite)result, 16384);
        label.setText("value");
        label.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.attValuePattern = new Combo((Composite)result, 2052);
        this.attValuePattern.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchPage.this.handleChanged();
            }
        });
        this.attValuePattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchPage.this.handleChanged();
            }
        });
        data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = this.convertWidthInCharsToPixels(20);
        this.attValuePattern.setLayoutData((Object)data);
        this.attributeCaseSensitive = new Button((Composite)result, 32);
        this.attributeCaseSensitive.setText("Case sensitive");
        this.attributeCaseSensitive.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.attributeRegEx = new Button((Composite)result, 32);
        this.attributeRegEx.setText("Regular e&xpression");
        this.attributeRegEx.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.attributeRegEx.setFont(result.getFont());
        return result;
    }

    private void handleChanged() {
        AuroraSearchPattern createSearchPattern = this.createSearchPattern();
        List<SearchCondition> conditions = createSearchPattern.getConditions();
        this.getContainer().setPerformActionEnabled(conditions.size() > 0);
    }

    public boolean performAction() {
        this.addSearchHistory();
        return this.performNewSearch();
    }

    private void addSearchHistory() {
        NameSpaceCondition namespaceCondition = this.getNameSpaceCondition();
        this.pageManager.addPreviousSearchCondition(this.pageManager.getPreviousSearchNameSpace(), namespaceCondition);
        ElementCondition elementCondition = this.getElementCondition();
        this.pageManager.addPreviousSearchCondition(this.pageManager.getPreviousSearchElement(), elementCondition);
        AttributeCondition attCondition = this.getAttributeCondition();
        this.pageManager.addPreviousSearchCondition(this.pageManager.getPreviousSearchAttribute(), attCondition);
    }

    private AttributeCondition getAttributeCondition() {
        AttributeCondition attCondition = new AttributeCondition();
        attCondition.setName(this.attributePattern.getText());
        attCondition.setValue(this.attValuePattern.getText());
        attCondition.setCaseSensitive(this.attributeCaseSensitive.getSelection());
        attCondition.setRegularExpression(this.attributeRegEx.getSelection());
        return attCondition;
    }

    private ElementCondition getElementCondition() {
        ElementCondition elementCondition = new ElementCondition();
        elementCondition.setElementName(this.elementPattern.getText());
        elementCondition.setCaseSensitive(this.elementCaseSensitive.getSelection());
        elementCondition.setRegularExpression(this.elementRegEx.getSelection());
        return elementCondition;
    }

    private NameSpaceCondition getNameSpaceCondition() {
        NameSpaceCondition namespaceCondition = new NameSpaceCondition();
        namespaceCondition.setNameSpace(this.namespacePattern.getText());
        namespaceCondition.setCaseSensitive(this.namespaceCaseSensitive.getSelection());
        namespaceCondition.setRegularExpression(this.namespaceRegEx.getSelection());
        return namespaceCondition;
    }

    private boolean performNewSearch() {
        AuroraSearchPattern pattern = this.createSearchPattern();
        FileTextSearchScope createTextSearchScope = this.createTextSearchScope();
        AuroraSearchQuery textSearchJob = new AuroraSearchQuery(createTextSearchScope, pattern);
        NewSearchUI.runQueryInBackground((ISearchQuery)textSearchJob);
        return true;
    }

    private AuroraSearchPattern createSearchPattern() {
        AttributeCondition attributeCondition;
        ElementCondition elementCondition;
        String type = null;
        Button[] buttonArray = this.fSearchFor;
        int n = this.fSearchFor.length;
        int n2 = 0;
        while (n2 < n) {
            Button b = buttonArray[n2];
            boolean selection = b.getSelection();
            if (selection) {
                type = b.getText();
                break;
            }
            ++n2;
        }
        AuroraSearchPattern pattern = new AuroraSearchPattern(new SearchForCondition(type));
        NameSpaceCondition nameSpaceCondition = this.getNameSpaceCondition();
        if (!"".equals(nameSpaceCondition.getNameSpace())) {
            pattern.addCondition(nameSpaceCondition);
        }
        if (!"".equals((elementCondition = this.getElementCondition()).getElementName())) {
            pattern.addCondition(elementCondition);
        }
        if (!"".equals((attributeCondition = this.getAttributeCondition()).getName()) || !"".equals(attributeCondition.getValue())) {
            pattern.addCondition(attributeCondition);
        }
        return pattern;
    }

    public void setContainer(ISearchPageContainer container) {
        this.fContainer = container;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.fFirstTime) {
                this.fFirstTime = false;
                if (this.namespacePattern != null) {
                    this.namespacePattern.setItems(this.pageManager.getPreviousNameSpace());
                    this.namespacePattern.select(0);
                }
                if (this.elementPattern != null) {
                    this.elementPattern.setItems(this.pageManager.getPreviousElement());
                    this.elementPattern.select(0);
                }
                if (this.attributePattern != null) {
                    this.attributePattern.setItems(this.pageManager.getPreviousAttributeNames());
                    this.attributePattern.select(0);
                }
                if (this.attValuePattern != null) {
                    this.attValuePattern.setItems(this.pageManager.getPreviousAttributeValues());
                    this.attValuePattern.select(0);
                }
            }
            if (this.namespacePattern != null) {
                this.namespacePattern.setFocus();
            }
        }
        this.handleChanged();
        super.setVisible(visible);
    }

    private void readConfiguration() {
        this.pageManager.readConfiguration("NAMESPACE_HISTORY_SIZE", this.pageManager.getPreviousSearchNameSpace());
        this.pageManager.readConfiguration("ELEMENT_HISTORY_SIZE", this.pageManager.getPreviousSearchElement());
        this.pageManager.readConfiguration("ATTRIBUTE_HISTORY_SIZE", this.pageManager.getPreviousSearchAttribute());
    }

    private void writeConfiguration() {
        this.pageManager.writeConfiguration("NAMESPACE_HISTORY_SIZE", this.pageManager.getPreviousSearchNameSpace());
        this.pageManager.writeConfiguration("ELEMENT_HISTORY_SIZE", this.pageManager.getPreviousSearchElement());
        this.pageManager.writeConfiguration("ATTRIBUTE_HISTORY_SIZE", this.pageManager.getPreviousSearchAttribute());
    }

    public void dispose() {
        this.writeConfiguration();
        super.dispose();
    }

    public FileTextSearchScope createTextSearchScope() {
        switch (this.getContainer().getSelectedScope()) {
            case 0: {
                return FileTextSearchScope.newWorkspaceScope((String[])this.getExtensions(), (boolean)this.fSearchDerived);
            }
            case 1: {
                return this.getSelectedResourcesScope();
            }
            case 3: {
                return this.getEnclosingProjectScope();
            }
            case 2: {
                IWorkingSet[] workingSets = this.getContainer().getSelectedWorkingSets();
                return FileTextSearchScope.newSearchScope((IWorkingSet[])workingSets, (String[])this.getExtensions(), (boolean)this.fSearchDerived);
            }
        }
        return FileTextSearchScope.newWorkspaceScope((String[])this.getExtensions(), (boolean)this.fSearchDerived);
    }

    private ISearchPageContainer getContainer() {
        return this.fContainer;
    }

    private FileTextSearchScope getSelectedResourcesScope() {
        HashSet<IResource> resources = new HashSet<IResource>();
        ISelection sel = this.getContainer().getSelection();
        if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
            for (Object curr : (IStructuredSelection)sel) {
                IResource resource;
                if (curr instanceof IWorkingSet) {
                    IWorkingSet workingSet = (IWorkingSet)curr;
                    if (workingSet.isAggregateWorkingSet() && workingSet.isEmpty()) {
                        return FileTextSearchScope.newWorkspaceScope((String[])this.getExtensions(), (boolean)this.fSearchDerived);
                    }
                    IAdaptable[] elements = workingSet.getElements();
                    int i = 0;
                    while (i < elements.length) {
                        IResource resource2 = (IResource)elements[i].getAdapter(IResource.class);
                        if (resource2 != null && resource2.isAccessible()) {
                            resources.add(resource2);
                        }
                        ++i;
                    }
                    continue;
                }
                if (!(curr instanceof IAdaptable) || (resource = (IResource)((IAdaptable)curr).getAdapter(IResource.class)) == null || !resource.isAccessible()) continue;
                resources.add(resource);
            }
        }
        IResource[] arr = resources.toArray(new IResource[resources.size()]);
        return FileTextSearchScope.newSearchScope((IResource[])arr, (String[])this.getExtensions(), (boolean)this.fSearchDerived);
    }

    private String[] getExtensions() {
        return new String[]{"*.bm", "*.svc", "*.screen"};
    }

    final void updateOKStatus() {
        this.getContainer().setPerformActionEnabled(true);
    }

    private FileTextSearchScope getEnclosingProjectScope() {
        String[] enclosingProjectName = this.getContainer().getSelectedProjectNames();
        if (enclosingProjectName == null) {
            return FileTextSearchScope.newWorkspaceScope((String[])this.getExtensions(), (boolean)this.fSearchDerived);
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource[] res = new IResource[enclosingProjectName.length];
        int i = 0;
        while (i < res.length) {
            res[i] = root.getProject(enclosingProjectName[i]);
            ++i;
        }
        return FileTextSearchScope.newSearchScope((IResource[])res, (String[])this.getExtensions(), (boolean)this.fSearchDerived);
    }
}

