/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.search.ui;

import aurora.ide.search.core.AbstractMatch;
import aurora.ide.search.ui.DecoratingSearchLabelProvider;
import aurora.ide.search.ui.EditorOpener;
import aurora.ide.search.ui.ISearchContentProvider;
import aurora.ide.search.ui.LineElement;
import aurora.ide.search.ui.MessageFormater;
import aurora.ide.search.ui.RefactorActionComposite;
import aurora.ide.search.ui.SearchImages;
import aurora.ide.search.ui.SearchLabelProvider;
import aurora.ide.search.ui.TableContentProvider;
import aurora.ide.search.ui.TreeContentProvider;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class SearchResultPage
extends AbstractTextSearchViewPage {
    private static final int DEFAULT_ELEMENT_LIMIT = 1000;
    private static final String limited_format_matches = "{0} (showing {1} of {2} matches)";
    private static final String limited_format_files = "{0} (showing {1} of {2} files)";
    private EditorOpener opener = new EditorOpener();
    private ISearchContentProvider provider;
    private SashForm sashForm;
    private TreeViewer treeViewer;

    protected void elementsChanged(Object[] objects) {
        this.provider.elementsChanged(objects);
    }

    protected void evaluateChangedElements(Match[] matches, Set changedElements) {
        if (this.showLineMatches()) {
            int i = 0;
            while (i < matches.length) {
                changedElements.add(((AbstractMatch)matches[i]).getLineElement());
                ++i;
            }
        } else {
            super.evaluateChangedElements(matches, changedElements);
        }
    }

    protected void clear() {
        this.provider.clear();
    }

    public SearchResultPage() {
        this.setElementLimit(new Integer(1000));
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        TreeContentProvider provider = new TreeContentProvider(this, (AbstractTreeViewer)viewer);
        SearchLabelProvider lp = new SearchLabelProvider(this, 1);
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingSearchLabelProvider(lp));
        viewer.setComparator((ViewerComparator)new DecoratorIgnoringViewerSorter((ILabelProvider)lp));
        viewer.setContentProvider((IContentProvider)provider);
        this.provider = provider;
    }

    protected void configureTableViewer(TableViewer viewer) {
        SearchLabelProvider lp = new SearchLabelProvider(this, 2);
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingSearchLabelProvider(lp));
        viewer.setComparator((ViewerComparator)new DecoratorIgnoringViewerSorter((ILabelProvider)lp));
        TableContentProvider provider = new TableContentProvider(this, viewer);
        viewer.setContentProvider((IContentProvider)provider);
        this.provider = provider;
    }

    protected void showMatch(Match match, int offset, int length, boolean activate) throws PartInitException {
        IFile file = (IFile)match.getElement();
        IWorkbenchPage page = this.getSite().getPage();
        if (offset >= 0 && length != 0) {
            this.opener.openAndSelect(page, file, offset, length, activate);
        } else {
            this.opener.open(page, file, activate);
        }
    }

    protected void handleOpen(OpenEvent event) {
        Object firstElement;
        if (this.showLineMatches() && (firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement()) instanceof IFile && this.getDisplayedMatchCount(firstElement) == 0) {
            try {
                this.opener.open(this.getSite().getPage(), (IFile)firstElement, false);
            }
            catch (PartInitException e) {
                ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Open File", (String)"Opening the file failed.", (IStatus)e.getStatus());
            }
            return;
        }
        super.handleOpen(event);
    }

    public String getLabel() {
        String label = super.getLabel();
        StructuredViewer viewer = this.getViewer();
        if (viewer instanceof TableViewer) {
            TableViewer tv = (TableViewer)viewer;
            AbstractTextSearchResult result = this.getInput();
            if (result != null) {
                int itemCount = ((IStructuredContentProvider)tv.getContentProvider()).getElements((Object)this.getInput()).length;
                if (this.showLineMatches()) {
                    int matchCount = this.getInput().getMatchCount();
                    if (itemCount < matchCount) {
                        return MessageFormater.format(limited_format_matches, new Object[]{label, new Integer(itemCount), new Integer(matchCount)});
                    }
                } else {
                    int fileCount = this.getInput().getElements().length;
                    if (itemCount < fileCount) {
                        return MessageFormater.format(limited_format_files, new Object[]{label, new Integer(itemCount), new Integer(fileCount)});
                    }
                }
            }
        }
        return label;
    }

    public int getDisplayedMatchCount(Object element) {
        if (this.showLineMatches()) {
            if (element instanceof LineElement) {
                LineElement lineEntry = (LineElement)element;
                return lineEntry.getNumberOfMatches(this.getInput());
            }
            return 0;
        }
        return super.getDisplayedMatchCount(element);
    }

    public Match[] getDisplayedMatches(Object element) {
        if (this.showLineMatches()) {
            if (element instanceof LineElement) {
                LineElement lineEntry = (LineElement)element;
                return lineEntry.getMatches(this.getInput());
            }
            return new Match[0];
        }
        return super.getDisplayedMatches(element);
    }

    private boolean showLineMatches() {
        return this.getLayout() == 2 && this.getInput() != null;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        this.sashForm = new SashForm(parent, 256);
        this.sashForm.SASH_WIDTH = 3;
        this.treeViewer = super.createTreeViewer((Composite)this.sashForm);
        RefactorActionComposite actions = new RefactorActionComposite((Composite)this.sashForm, 2048);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)actions);
        this.sashForm.setWeights(new int[]{1, 1});
        this.maxSashForm();
        return this.treeViewer;
    }

    protected TableViewer createTableViewer(Composite parent) {
        if (this.sashForm != null) {
            this.sashForm.dispose();
        }
        return super.createTableViewer(parent);
    }

    private void maxSashForm() {
        if (this.sashForm.getMaximizedControl() == null) {
            this.sashForm.setMaximizedControl(this.treeViewer.getControl());
        } else {
            this.sashForm.setMaximizedControl(null);
        }
    }

    protected void fillToolbar(IToolBarManager tbm) {
        super.fillToolbar(tbm);
        if (this.getLayout() == 2) {
            Action action = new Action(){

                public void run() {
                    SearchResultPage.this.maxSashForm();
                }
            };
            action.setImageDescriptor(SearchImages.getImageDescriptor("search_action.gif"));
            action.setToolTipText("Refactor Action");
            tbm.add((IAction)action);
        }
    }

    public static class DecoratorIgnoringViewerSorter
    extends ViewerComparator {
        private final ILabelProvider fLabelProvider;

        public DecoratorIgnoringViewerSorter(ILabelProvider labelProvider) {
            this.fLabelProvider = labelProvider;
        }

        public int category(Object element) {
            if (element instanceof IContainer) {
                return 1;
            }
            return 2;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (e1 instanceof LineElement && e2 instanceof LineElement) {
                LineElement m1 = (LineElement)e1;
                LineElement m2 = (LineElement)e2;
                return m1.getOffset() - m2.getOffset();
            }
            String name1 = this.fLabelProvider.getText(e1);
            String name2 = this.fLabelProvider.getText(e2);
            if (name1 == null) {
                name1 = "";
            }
            if (name2 == null) {
                name2 = "";
            }
            return this.getComparator().compare(name1, name2);
        }
    }
}

