/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.statistics.viewer;

import aurora.ide.api.statistics.IStatisticsManager;
import aurora.ide.api.statistics.map.StatisticsMap;
import aurora.ide.api.statistics.model.Dependency;
import aurora.ide.api.statistics.model.ProjectObject;
import aurora.ide.builder.ResourceUtil;
import aurora.ide.helpers.CompositeMapUtil;
import aurora.ide.helpers.LoadSchemaManager;
import aurora.ide.project.propertypage.ProjectPropertyPage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import uncertain.composite.CompositeMap;
import uncertain.composite.QualifiedName;
import uncertain.schema.Attribute;
import uncertain.schema.Element;
import uncertain.schema.ISchemaManager;
import uncertain.schema.IType;
import uncertain.schema.SimpleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectDependency
implements IStatisticsManager {
    private static ObjectDependency objectDependency;
    private IFile sourceFile;
    private IProject project;
    private List<ProjectObject> poList;

    public static ObjectDependency getInstance() {
        if (objectDependency == null) {
            objectDependency = new ObjectDependency();
        }
        return objectDependency;
    }

    public List<Dependency> getDependency(ProjectObject po, List<ProjectObject> poList, StatisticsMap sm, QualifiedName qName) {
        ArrayList<Dependency> dependencys = new ArrayList<Dependency>();
        ISchemaManager schemaManager = LoadSchemaManager.getSchemaManager();
        Element element = schemaManager.getElement(sm.getMap());
        if (element == null) {
            return new ArrayList<Dependency>();
        }
        this.poList = poList;
        this.sourceFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(po.getPath()));
        this.project = this.sourceFile.getProject();
        for (Object o : element.getAllAttributes()) {
            ProjectObject p;
            String s;
            Attribute attrib = (Attribute)o;
            IType attributeType = attrib.getAttributeType();
            if (!(attributeType instanceof SimpleType) || !qName.equals((Object)((SimpleType)attributeType).getReferenceTypeQName()) || (s = CompositeMapUtil.getValueIgnoreCase(attrib, sm.getMap())) == null) continue;
            if (s.lastIndexOf("?") >= 0) {
                s = s.split("\\?")[0];
            }
            IFile df = null;
            if (qName.equals((Object)IStatisticsManager.BmReference)) {
                df = this.getDependencyBm(s);
            } else if (qName.equals((Object)IStatisticsManager.ScreenReference)) {
                df = this.getDependencyScreen(s);
            } else if (qName.equals((Object)IStatisticsManager.UrlReference)) {
                df = this.getDependencyUrl(s);
            }
            IPath path = this.getFilePath(df);
            if (path == null || (p = this.findProjectObject(path.toString())) == null) continue;
            Dependency d = new Dependency();
            d.setDependencyObject(p);
            dependencys.add(d);
        }
        return dependencys;
    }

    private IPath getFilePath(IFile file) {
        if (file == null) {
            return null;
        }
        return new Path(file.getProject().getName()).append(file.getProjectRelativePath());
    }

    private ProjectObject findProjectObject(String path) {
        if (path == null) {
            return null;
        }
        for (ProjectObject p : this.poList) {
            if (!p.getPath().equals(path)) continue;
            return p;
        }
        return null;
    }

    private IFile getDependencyBm(String referenceValue) {
        IFile dependencyFile = ResourceUtil.getBMFile(this.project, referenceValue);
        if (dependencyFile != null && dependencyFile.exists()) {
            return dependencyFile;
        }
        return null;
    }

    private IFile getDependencyScreen(String referenceValue) {
        IFile dependencyFile = null;
        if (referenceValue.toLowerCase().endsWith(".screen")) {
            try {
                Path webPath = new Path(this.project.getPersistentProperty(ProjectPropertyPage.WebQN));
                dependencyFile = ResourcesPlugin.getWorkspace().getRoot().getFile(webPath.append("/" + referenceValue));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        if (dependencyFile != null && dependencyFile.exists()) {
            return dependencyFile;
        }
        return null;
    }

    private IFile getDependencyUrl(String referenceValue) {
        int q;
        int p;
        IFile dependencyFile = null;
        String special = "${/request/@context_path}";
        int loc = referenceValue.indexOf(special);
        if (loc >= 0 && (p = (referenceValue = referenceValue.substring(loc + special.length())).lastIndexOf(".")) < (q = referenceValue.lastIndexOf("/"))) {
            referenceValue = referenceValue.substring(0, q);
        }
        if (referenceValue.toLowerCase().endsWith(".svc") || referenceValue.toLowerCase().endsWith(".screen")) {
            try {
                Path webPath = new Path(this.project.getPersistentProperty(ProjectPropertyPage.WebQN));
                dependencyFile = ResourcesPlugin.getWorkspace().getRoot().getFile(webPath.append("/" + referenceValue));
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        } else {
            int q2 = referenceValue.lastIndexOf("/");
            if (q2 >= 0) {
                referenceValue = referenceValue.substring(q2);
            }
            dependencyFile = ResourceUtil.getBMFile(this.project, referenceValue);
        }
        if (dependencyFile != null && dependencyFile.exists()) {
            return dependencyFile;
        }
        return null;
    }

    public String getValueIgnoreCase(Attribute a, CompositeMap cMap) {
        return CompositeMapUtil.getValueIgnoreCase(a, cMap);
    }
}

