/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.statistics.viewer;

import aurora.ide.api.statistics.map.ObjectStatisticsResult;
import aurora.ide.statistics.viewer.ObjectNode;
import java.text.DecimalFormat;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

class ObjectViewLabelProvider
implements ITableLabelProvider {
    ObjectViewLabelProvider() {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof ObjectStatisticsResult && columnIndex == 0) {
            return ((ObjectStatisticsResult)element).getType();
        }
        if (element instanceof ObjectNode) {
            ObjectNode node = (ObjectNode)element;
            switch (columnIndex) {
                case 0: {
                    return node.category;
                }
                case 1: {
                    return node.fileName;
                }
                case 2: {
                    return node.path;
                }
                case 3: {
                    return this.conversion(node.fileSize);
                }
                case 4: {
                    return this.conversion(node.scriptSize);
                }
                case 5: {
                    return node.tagCount;
                }
                case 6: {
                    return node.refInCount;
                }
                case 7: {
                    return node.refOutCount;
                }
            }
        }
        return null;
    }

    private String conversion(String value) {
        if (value.matches("\\d+")) {
            DecimalFormat df = new DecimalFormat("0.00");
            double v = Double.parseDouble(value);
            if (value.length() > 3 && value.length() <= 6) {
                return String.valueOf(df.format(v /= 1024.0)) + " KB";
            }
            if (value.length() > 6) {
                return String.valueOf(df.format(v /= 1048576.0)) + " MB";
            }
            return String.valueOf((int)v) + " Byte";
        }
        return value;
    }
}

