/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.statistics.viewer;

import aurora.ide.api.statistics.map.ObjectStatisticsResult;
import aurora.ide.api.statistics.map.StatisticsResult;
import aurora.ide.api.statistics.model.StatisticsProject;
import aurora.ide.statistics.viewer.ProjectNode;
import java.util.ArrayList;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

class ProjectViewContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    ProjectViewContentProvider() {
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof StatisticsProject) {
            String[] ps = StatisticsProject.PROPERTIES;
            Object[] nodes = new ProjectNode[ps.length];
            int i = 0;
            while (i < ps.length) {
                nodes[i] = new ProjectNode();
                ((ProjectNode)nodes[i]).name = ps[i];
                ((ProjectNode)nodes[i]).value = ((StatisticsProject)parentElement).getProperty(i);
                ((ProjectNode)nodes[i]).parent = parentElement;
                ++i;
            }
            return nodes;
        }
        if (parentElement instanceof ObjectStatisticsResult) {
            ObjectStatisticsResult osr = (ObjectStatisticsResult)parentElement;
            ProjectNode fileCount = this.createProjectNode("files", osr, osr.getFileCount(), osr.getFileCount(), osr.getFileCount(), osr.getFileCount());
            ProjectNode fileSize = this.createProjectNode("file size", osr, osr.getMaxFileSize(), osr.getMinFileSize(), osr.getTotalFileSize(), osr.getAverageFileSize());
            ProjectNode scriptSize = this.createProjectNode("script size", osr, osr.getMaxScriptSize(), osr.getMinScriptSize(), osr.getTotalScriptSize(), osr.getAverageScriptSize());
            ProjectNode tagCount = this.createProjectNode("tags", osr, osr.getMaxTagCount(), osr.getMinTagCount(), osr.getTotalTagCount(), osr.getAverageTagCount());
            return new ProjectNode[]{fileSize, scriptSize, fileCount, tagCount};
        }
        return null;
    }

    private ProjectNode createProjectNode(String nodeName, Object parent, int max, int min, int total, int average) {
        ProjectNode node = new ProjectNode();
        node.name = nodeName;
        node.parent = parent;
        node.max = this.toString(max);
        node.min = this.toString(min);
        node.value = this.toString(total);
        node.average = this.toString(average);
        return node;
    }

    private String toString(int i) {
        return String.valueOf(i);
    }

    public Object getParent(Object element) {
        if (element instanceof ProjectNode) {
            return ((ProjectNode)element).parent;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof StatisticsProject || element instanceof ObjectStatisticsResult;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof StatisticsResult) {
            ObjectStatisticsResult bmStatisticsResult = ((StatisticsResult)inputElement).getBMStatisticsResult();
            ObjectStatisticsResult sreenStatisticsResult = ((StatisticsResult)inputElement).getSreenStatisticsResult();
            ObjectStatisticsResult svcStatisticsResult = ((StatisticsResult)inputElement).getSVCStatisticsResult();
            StatisticsProject project = ((StatisticsResult)inputElement).getProject();
            ArrayList<Object> result = new ArrayList<Object>();
            if (project != null) {
                result.add(project);
            }
            if (bmStatisticsResult != null) {
                result.add(bmStatisticsResult);
            }
            if (sreenStatisticsResult != null) {
                result.add(sreenStatisticsResult);
            }
            if (svcStatisticsResult != null) {
                result.add(svcStatisticsResult);
            }
            return result.toArray(new Object[result.size()]);
        }
        return null;
    }
}

