/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.statistics.viewer;

import aurora.ide.AuroraPlugin;
import aurora.ide.api.statistics.DatabaseAction;
import aurora.ide.api.statistics.Statistician;
import aurora.ide.api.statistics.Status;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.DBManager;
import aurora.ide.statistics.viewer.StatisticsView;
import java.sql.Connection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SaveToDBJob
extends Job {
    private Statistician statistician;
    private StatisticsView statisticsView;

    public SaveToDBJob(Statistician statistician, StatisticsView statisticsView) {
        super("StatisticsViewSaveToDB");
        this.statistician = statistician;
        this.statisticsView = statisticsView;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IProject project = AuroraPlugin.getWorkspace().getRoot().getProject(this.statistician.getProject().getEclipseProjectName());
        if (!project.exists()) {
            this.showMessage("\u5de5\u7a0b\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u4fdd\u5b58");
            return org.eclipse.core.runtime.Status.CANCEL_STATUS;
        }
        monitor.beginTask("\u6570\u636e\u4fdd\u5b58\u4e2d....", 80);
        try {
            monitor.worked(10);
            monitor.setTaskName("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5");
            DBManager dm = new DBManager(project);
            Connection connection = dm.getConnection();
            monitor.worked(20);
            monitor.setTaskName("\u4fdd\u5b58\u7edf\u8ba1\u6570\u636e");
            Status save = this.statistician.save(connection);
            if (save.getStatus() == 1) {
                monitor.worked(10);
                monitor.setTaskName("\u6570\u636e\u4fdd\u5b58\u5931\u8d25 \uff1a" + save.getMessage());
                if (save.getMessage().startsWith("ORA-02289:")) {
                    monitor.setTaskName("\u521b\u5efa\u4fdd\u5b58\u9700\u8981\u7684\u8868");
                    connection = dm.getConnection();
                    DatabaseAction.createTables((Connection)connection);
                    monitor.worked(10);
                    monitor.setTaskName("\u4fdd\u5b58\u7edf\u8ba1\u6570\u636e");
                    save = this.statistician.save(connection);
                }
            }
            monitor.worked(20);
            monitor.setTaskName("\u6570\u636e\u4fdd\u5b58\u6210\u529f");
            this.statisticsView.setSaveToDBActionEnabled(true);
            this.statisticsView.setSaveToXLSActionEnabled(true);
            IStatus iStatus = org.eclipse.core.runtime.Status.OK_STATUS;
            return iStatus;
        }
        catch (ApplicationException e) {
            this.showMessage(e.getMessage());
        }
        finally {
            monitor.done();
        }
        return org.eclipse.core.runtime.Status.CANCEL_STATUS;
    }

    private void showMessage(final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"\u7edf\u8ba1\u5206\u6790", (String)message);
            }
        });
    }
}

