/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.statistics.viewer;

import aurora.ide.AuroraPlugin;
import aurora.ide.api.statistics.IRunningListener;
import aurora.ide.api.statistics.IStatisticsManager;
import aurora.ide.api.statistics.RepositoryInfo;
import aurora.ide.api.statistics.Statistician;
import aurora.ide.api.statistics.cvs.CVSEntryLineTag;
import aurora.ide.api.statistics.cvs.CVSRepositoryLocation;
import aurora.ide.api.statistics.cvs.CVSTag;
import aurora.ide.api.statistics.cvs.FolderSyncInfo;
import aurora.ide.api.statistics.map.PreferencesTag;
import aurora.ide.api.statistics.map.StatisticsResult;
import aurora.ide.api.statistics.model.ProjectObject;
import aurora.ide.api.statistics.model.StatisticsProject;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.LoadSchemaManager;
import aurora.ide.search.cache.CacheManager;
import aurora.ide.search.core.AuroraFileFinder;
import aurora.ide.search.ui.MessageFormater;
import aurora.ide.statistics.repo.CVSFileReader;
import aurora.ide.statistics.viewer.ObjectDependency;
import aurora.ide.statistics.viewer.StatisticsView;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import uncertain.composite.CompositeMap;

public class StatisticianRunner
implements IRunningListener {
    private StatisticsView statisticsView;
    private int fNumberOfFilesToScan;
    private String fCurrentFileName;
    private int fNumberOfScannedFiles;
    private IProgressMonitor monitor;
    private boolean isStatistician = false;

    public StatisticianRunner(StatisticsView statisticsView) {
        this.statisticsView = statisticsView;
    }

    public void noProjectRun(final Object[] objects) {
        Job job = new Job("Aurora Statistician Progress"){

            public IStatus run(IProgressMonitor monitor) {
                StatisticianRunner.this.monitor = monitor;
                Statistician st = StatisticianRunner.this.noProjectStatistician();
                StatisticianRunner.this.privateRunning(st, objects, monitor);
                StatisticianRunner.this.statisticsView.setSaveToXLSActionEnabled(true);
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private void privateRunning(Statistician st, Object[] objects, final IProgressMonitor monitor) {
        this.fNumberOfFilesToScan = objects.length;
        Job monitorUpdateJob = new Job("Aurora Statistician Progress"){
            private int fLastNumberOfScannedFiles;
            {
                super($anonymous0);
                this.fLastNumberOfScannedFiles = 0;
            }

            public IStatus run(IProgressMonitor inner) {
                while (!inner.isCanceled()) {
                    if (StatisticianRunner.this.fCurrentFileName != null) {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                this.updateMonitor(monitor);
                            }
                        });
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        return Status.OK_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }

            private void updateMonitor(IProgressMonitor monitor2) {
                Object[] args = new Object[]{StatisticianRunner.this.fCurrentFileName, new Integer(StatisticianRunner.this.fNumberOfScannedFiles), new Integer(StatisticianRunner.this.fNumberOfFilesToScan)};
                if (StatisticianRunner.this.isStatistician) {
                    monitor2.subTask("\u5206\u6790 :" + MessageFormater.format("Scanning file {1} of {2}: {0}", args));
                } else {
                    monitor2.subTask("\u7edf\u8ba1 :" + MessageFormater.format("Scanning file {1} of {2}: {0}", args));
                }
                int steps = StatisticianRunner.this.fNumberOfScannedFiles - this.fLastNumberOfScannedFiles;
                if (steps < 0) {
                    this.fLastNumberOfScannedFiles = 0;
                    steps = StatisticianRunner.this.fNumberOfScannedFiles - this.fLastNumberOfScannedFiles;
                }
                monitor2.worked(steps);
                this.fLastNumberOfScannedFiles += steps;
            }
        };
        monitor.beginTask("\u6587\u4ef6\u7edf\u8ba1\u5206\u6790", this.fNumberOfFilesToScan * 2);
        monitorUpdateJob.setSystem(true);
        monitorUpdateJob.schedule();
        try {
            this.setPreferencesTag();
            st.addRuningListener((IRunningListener)this);
            Statistician statistician = this.fillStatistician(st, objects, monitor);
            this.isStatistician = true;
            StatisticsResult doStatistic = statistician.doStatistic();
            this.statisticsView.setInput(doStatistic, statistician);
        }
        finally {
            this.isStatistician = false;
            monitorUpdateJob.cancel();
            monitor.done();
        }
    }

    public Statistician fillStatistician(Statistician st, Object[] objects, IProgressMonitor monitor) {
        int i = 1;
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (monitor.isCanceled()) {
                return st;
            }
            if (o instanceof IFile) {
                this.fCurrentFileName = ((IFile)o).getName();
                this.fNumberOfScannedFiles = i;
                ProjectObject po = this.createProjectObject((IFile)o);
                if (po != null) {
                    st.addProjectObject(po);
                }
            }
            ++i;
            ++n2;
        }
        return st;
    }

    private void setPreferencesTag() {
        IPreferenceStore store = AuroraPlugin.getDefault().getPreferenceStore();
        if (store.getDefaultString("statistician.checked").trim().equals("")) {
            StringBuffer defaultStore = new StringBuffer();
            Map defaultMap = PreferencesTag.INSTANCE().getDefaultMap();
            for (String n : defaultMap.keySet()) {
                defaultStore.append("*");
                defaultStore.append(n);
                defaultStore.append("!");
                for (String t : (List)defaultMap.get(n)) {
                    defaultStore.append(t);
                    defaultStore.append("!");
                }
            }
            store.setDefault("statistician.checked", defaultStore.toString());
            store.setValue("statistician.checked", defaultStore.toString());
        }
        String[] ss = store.getString("statistician.checked").split("!");
        HashMap map = new HashMap();
        String nameSpace = "";
        ArrayList<String> list = null;
        String[] stringArray = ss;
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!"".equals(s.trim())) {
                if (s.indexOf("*") == 0) {
                    if (list != null) {
                        map.put(nameSpace, list);
                    }
                    nameSpace = s.substring(1);
                    list = new ArrayList<String>();
                } else {
                    list.add(s.substring(s.indexOf(":") > 0 ? s.indexOf(":") + 1 : 0));
                }
            }
            ++n2;
        }
        map.put(nameSpace, list);
        PreferencesTag.INSTANCE().setNamespaceMap(map);
    }

    public ProjectObject createProjectObject(IFile file) {
        String type = this.getProjectObjectType(file);
        if (type.equals("unsupport")) {
            return null;
        }
        ProjectObject po = new ProjectObject();
        po.setType(type);
        po.setName(file.getName());
        po.setPath(new Path(file.getProject().getName()).append(file.getProjectRelativePath()).toString());
        try {
            CompositeMap compositeMap = CacheManager.getCompositeMap(file);
            po.setRootMap(compositeMap);
            return po;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (ApplicationException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String getProjectObjectType(IFile file) {
        String fileExtension = file.getFileExtension();
        return ProjectObject.getType((String)fileExtension);
    }

    private Statistician noProjectStatistician() {
        return new Statistician(StatisticsProject.NONE_PROJECT, LoadSchemaManager.getSchemaManager(), (IStatisticsManager)ObjectDependency.getInstance());
    }

    public boolean notice(ProjectObject po, int poIndex) {
        this.fCurrentFileName = po.getName();
        this.fNumberOfScannedFiles = poIndex + 1;
        return this.monitor == null || !this.monitor.isCanceled();
    }

    public void projectRun(final Object[] objects) {
        Job job = new Job("Aurora Statistician Progress"){

            public IStatus run(IProgressMonitor monitor) {
                StatisticianRunner.this.monitor = monitor;
                Statistician st = StatisticianRunner.this.projectStatistician(objects[0]);
                if (st != null) {
                    AuroraFileFinder finder = new AuroraFileFinder();
                    try {
                        ((IProject)objects[0]).accept((IResourceVisitor)finder);
                        List<IResource> result = finder.getResult();
                        StatisticianRunner.this.privateRunning(st, result.toArray(new IResource[result.size()]), monitor);
                        StatisticianRunner.this.statisticsView.setSaveToDBActionEnabled(true);
                        StatisticianRunner.this.statisticsView.setSaveToXLSActionEnabled(true);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    protected Statistician projectStatistician(Object object) {
        if (object instanceof IProject) {
            IProject project = (IProject)object;
            StatisticsProject sp = new StatisticsProject(project.getName(), project.getName());
            RepositoryInfo repInfo = this.createCVSInfo(project);
            if (repInfo == null) {
                repInfo = this.createSVNInfo(project);
            }
            if (repInfo != null) {
                sp.setRepositoryPath(repInfo.getRepoPath());
                sp.setRepositoryRevision(repInfo.getRevision());
                sp.setRepositoryType(repInfo.getType());
                sp.setStorer(repInfo.getUserName());
            }
            return new Statistician(sp, LoadSchemaManager.getSchemaManager(), (IStatisticsManager)ObjectDependency.getInstance());
        }
        return this.noProjectStatistician();
    }

    private RepositoryInfo createCVSInfo(IProject project) {
        FolderSyncInfo readFolderSync = CVSFileReader.readFolderSync((IContainer)project);
        if (readFolderSync == null) {
            return null;
        }
        String repository = readFolderSync.getRepository();
        String root = readFolderSync.getRoot();
        String projectCVSPath = String.valueOf(root) + "/" + repository;
        CVSEntryLineTag tag = readFolderSync.getTag();
        String tagLabel = CVSTag.getTagLabel((CVSTag)tag);
        CVSRepositoryLocation location = new CVSRepositoryLocation(projectCVSPath);
        RepositoryInfo info = new RepositoryInfo(projectCVSPath, tagLabel);
        info.setUserName(location.getUserName());
        info.setType("CVS");
        return info;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RepositoryInfo createSVNInfo(IProject project) {
        File file = project.getFolder(".svn").getFile("entries").getLocation().toFile();
        try {
            FileInputStream fis = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fis), 512);
            String revision = "";
            String url = "";
            int i = 0;
            while (true) {
                if (i >= 5) {
                    RepositoryInfo repositoryInfo = new RepositoryInfo(url, revision);
                    repositoryInfo.setType("SVN");
                    repositoryInfo.setUserName("");
                    return repositoryInfo;
                }
                String line = reader.readLine();
                if (line == null) {
                    return null;
                }
                if (i == 3) {
                    Integer.valueOf(line);
                    revision = line;
                } else if (i == 4) {
                    url = line;
                }
                ++i;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

