/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.statistics.viewer;

import aurora.ide.AuroraPlugin;
import aurora.ide.api.statistics.Statistician;
import aurora.ide.api.statistics.map.StatisticsResult;
import aurora.ide.api.statistics.model.ProjectObject;
import aurora.ide.api.statistics.model.StatisticsProject;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.i18n.Messages;
import aurora.ide.search.ui.EditorOpener;
import aurora.ide.statistics.viewer.LoadFromDBJob;
import aurora.ide.statistics.viewer.ObjectNode;
import aurora.ide.statistics.viewer.ObjectViewContentProvider;
import aurora.ide.statistics.viewer.ObjectViewLabelProvider;
import aurora.ide.statistics.viewer.ObjectViewerFilter;
import aurora.ide.statistics.viewer.ObjectViewerSorter;
import aurora.ide.statistics.viewer.ProjectViewContentProvider;
import aurora.ide.statistics.viewer.ProjectViewLabelProvider;
import aurora.ide.statistics.viewer.SaveToDBJob;
import aurora.ide.statistics.viewer.StatisticianRunner;
import aurora.ide.statistics.viewer.TreeViewerAutoFitListener;
import aurora.ide.statistics.wizard.dialog.LoadDataWizard;
import aurora.ide.statistics.wizard.dialog.SaveDataWizard;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.ui.part.ViewPart;

public class StatisticsView
extends ViewPart {
    public static final String ID = "aurora.ide.viewer.statistics.StatisticsView";
    private static final String[] pViewColTitles = new String[]{Messages.StatisticsView_Project_Name, Messages.StatisticsView_Value, Messages.StatisticsView_MAX_Value, Messages.StatisticsView_MIN_Value, Messages.StatisticsView_AVG_Value};
    private static final String[] pViewColTooltips = new String[]{Messages.StatisticsView_Project_Name, Messages.StatisticsView_Value_Of_Num, Messages.StatisticsView_MAX_Value, Messages.StatisticsView_MIN_Value, Messages.StatisticsView_AVG_Value};
    private static final String[] oViewColTitles = new String[]{Messages.StatisticsView_Type, Messages.StatisticsView_File_Name, Messages.StatisticsView_Path, Messages.StatisticsView_File_Size, Messages.StatisticsView_Script_Size, Messages.StatisticsView_Tag_Num, Messages.StatisticsView_Reference, Messages.StatisticsView_Referenced};
    private static final String[] oViewColTooltips = new String[]{Messages.StatisticsView_Type, Messages.StatisticsView_File_Name, Messages.StatisticsView_Path, Messages.StatisticsView_File_Size, Messages.StatisticsView_Script_Size, Messages.StatisticsView_Tag_Num, Messages.StatisticsView_Reference, Messages.StatisticsView_Referenced};
    private TreeViewer projectViewer;
    private TreeViewer objectViewer;
    private ObjectViewerFilter filter;
    private Action fileSelectionAction;
    private Action projectSelectionAction;
    private Action saveToXLSAction;
    private Action saveToDBAction;
    private Action dbLoadAction;
    private Statistician statistician;
    private ObjectNode selectNode;

    public void createPartControl(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 128);
        TabItem item = new TabItem(tabFolder, 0);
        item.setText("Objects");
        item.setToolTipText("Project Objects:bm,screen,svc...");
        Composite objectComp = new Composite((Composite)tabFolder, 0);
        objectComp.setLayout((Layout)new GridLayout(2, false));
        Label lbl = new Label(objectComp, 0);
        lbl.setText("\u6587\u4ef6\u540d\uff1a");
        Text txt = new Text(objectComp, 2048);
        txt.setLayoutData((Object)new GridData(768));
        txt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StatisticsView.this.objectViewer.removeFilter((ViewerFilter)StatisticsView.this.filter);
                StatisticsView.this.filter = new ObjectViewerFilter(((Text)e.getSource()).getText());
                StatisticsView.this.objectViewer.addFilter((ViewerFilter)StatisticsView.this.filter);
                StatisticsView.this.objectViewer.getControl().setRedraw(false);
                StatisticsView.this.objectViewer.expandAll();
                StatisticsView.this.objectViewer.getControl().setRedraw(true);
            }
        });
        this.createObjectViewer(objectComp);
        item.setControl((Control)objectComp);
        item = new TabItem(tabFolder, 0);
        item.setText("Project");
        item.setToolTipText("Project Descripttion.");
        this.createProjectViewer((Composite)tabFolder);
        item.setControl(this.projectViewer.getControl());
        this.makeActions();
        this.contributeToActionBars();
        this.saveToDBAction.setEnabled(false);
        this.saveToXLSAction.setEnabled(false);
    }

    private void createObjectViewer(Composite parent) {
        this.objectViewer = new TreeViewer(parent, 68352);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        this.objectViewer.getTree().setLayoutData((Object)gd);
        this.objectViewer.setContentProvider((IContentProvider)new ObjectViewContentProvider());
        this.objectViewer.setLabelProvider((IBaseLabelProvider)new ObjectViewLabelProvider());
        this.objectViewer.addTreeListener((ITreeViewerListener)new TreeViewerAutoFitListener());
        this.filter = new ObjectViewerFilter("");
        this.objectViewer.addFilter((ViewerFilter)this.filter);
        Tree tree = this.objectViewer.getTree();
        int i = 0;
        while (i < oViewColTitles.length) {
            TreeColumn treeColumn = new TreeColumn(tree, 0);
            treeColumn.setMoveable(true);
            treeColumn.setResizable(true);
            treeColumn.setText(oViewColTitles[i]);
            treeColumn.setToolTipText(oViewColTooltips[i]);
            treeColumn.pack();
            treeColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){
                boolean asc = true;

                public void widgetSelected(SelectionEvent e) {
                    TreeColumn tc = (TreeColumn)e.getSource();
                    StatisticsView.this.setSorter(tc.getText(), this.asc);
                    this.asc = !this.asc;
                    StatisticsView.this.objectViewer.expandAll();
                }
            });
            ++i;
        }
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        this.objectViewer.expandAll();
        this.objectViewer.getTree().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (e.button == 1 && StatisticsView.this.selectNode != null) {
                    ObjectNode osr = StatisticsView.this.selectNode;
                    try {
                        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(osr.path));
                        EditorOpener editorOpener = new EditorOpener();
                        editorOpener.open(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), file, true);
                    }
                    catch (PartInitException e1) {
                        DialogUtil.logErrorException(e1);
                    }
                }
            }
        });
        this.objectViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeSelection ts = (TreeSelection)event.getSelection();
                if (ts.getFirstElement() instanceof ObjectNode) {
                    StatisticsView.this.selectNode = (ObjectNode)ts.getFirstElement();
                }
            }
        });
    }

    private void setSorter(String text, boolean asc) {
        if (text.equals(Messages.StatisticsView_File_Name)) {
            this.objectViewer.setSorter((ViewerSorter)(asc ? ObjectViewerSorter.FILENAME_ASC : ObjectViewerSorter.FILENAME_DESC));
        } else if (text.equals(Messages.StatisticsView_Path)) {
            this.objectViewer.setSorter((ViewerSorter)(asc ? ObjectViewerSorter.PATH_ASC : ObjectViewerSorter.PATH_DESC));
        } else if (text.equals(Messages.StatisticsView_File_Size)) {
            this.objectViewer.setSorter((ViewerSorter)(asc ? ObjectViewerSorter.FILESIZE_ASC : ObjectViewerSorter.FILESIZE_DESC));
        } else if (text.equals(Messages.StatisticsView_Script_Size)) {
            this.objectViewer.setSorter((ViewerSorter)(asc ? ObjectViewerSorter.SCRIPTSIZE_ASC : ObjectViewerSorter.SCRIPTSIZE_DESC));
        } else if (text.equals(Messages.StatisticsView_Tag_Num)) {
            this.objectViewer.setSorter((ViewerSorter)(asc ? ObjectViewerSorter.TAGCOUNT_ASC : ObjectViewerSorter.TAGCOUNT_DESC));
        } else if (text.equals(Messages.StatisticsView_Reference)) {
            this.objectViewer.setSorter((ViewerSorter)(asc ? ObjectViewerSorter.REFINCOUNT_ASC : ObjectViewerSorter.REFINCOUNT_DESC));
        } else if (text.equals(Messages.StatisticsView_Referenced)) {
            this.objectViewer.setSorter((ViewerSorter)(asc ? ObjectViewerSorter.REFOUTCOUNT_ASC : ObjectViewerSorter.REFOUTCOUNT_DESC));
        } else {
            return;
        }
    }

    private void createProjectViewer(Composite parent) {
        this.projectViewer = new TreeViewer(parent, 66306);
        this.projectViewer.setContentProvider((IContentProvider)new ProjectViewContentProvider());
        this.projectViewer.setLabelProvider((IBaseLabelProvider)new ProjectViewLabelProvider());
        this.projectViewer.addTreeListener((ITreeViewerListener)new TreeViewerAutoFitListener());
        Tree tree = this.projectViewer.getTree();
        int i = 0;
        while (i < pViewColTitles.length) {
            TreeColumn treeColumn = new TreeColumn(tree, 0);
            treeColumn.setMoveable(true);
            treeColumn.setResizable(true);
            treeColumn.setText(pViewColTitles[i]);
            treeColumn.setToolTipText(pViewColTooltips[i]);
            treeColumn.pack();
            ++i;
        }
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                StatisticsView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.objectViewer.getControl());
        this.objectViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.objectViewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.fileSelectionAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.projectSelectionAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.fileSelectionAction);
        manager.add((IAction)this.projectSelectionAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.fileSelectionAction);
        manager.add((IAction)this.projectSelectionAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.saveToXLSAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.dbLoadAction);
        manager.add((IAction)this.saveToDBAction);
        manager.add((IContributionItem)new Separator());
    }

    public void setInput(final StatisticsResult statisticsResult, Statistician statistician) {
        this.statistician = statistician;
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                StatisticsView.this.objectViewer.setInput((Object)statisticsResult);
                StatisticsView.this.objectViewer.expandAll();
                TreeViewerAutoFitListener.packColumns(StatisticsView.this.objectViewer);
                StatisticsView.this.projectViewer.setInput((Object)statisticsResult);
                StatisticsView.this.projectViewer.expandAll();
                TreeViewerAutoFitListener.packColumns(StatisticsView.this.projectViewer);
            }
        });
    }

    private void makeActions() {
        this.saveToDBAction = new Action(){

            public void run() {
                if (StatisticsView.this.statistician == null || StatisticsProject.NONE_PROJECT.equals(StatisticsView.this.statistician.getProject()) || StatisticsView.this.statistician.getProject().getEclipseProjectName() == null) {
                    StatisticsView.this.showMessage(Messages.StatisticsView_Can_Not_Save);
                    return;
                }
                SaveDataWizard wizard = new SaveDataWizard(StatisticsView.this.statistician);
                WizardDialog dialog = new WizardDialog(StatisticsView.this.getSite().getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    StatisticsView.this.statistician.setProject(wizard.getProject());
                    SaveToDBJob job = new SaveToDBJob(StatisticsView.this.statistician, StatisticsView.this);
                    job.setUser(true);
                    job.schedule();
                    StatisticsView.this.setSaveToDBActionEnabled(false);
                    StatisticsView.this.setSaveToXLSActionEnabled(false);
                }
            }
        };
        this.saveToDBAction.setToolTipText(Messages.StatisticsView_Save_To_DB);
        this.saveToDBAction.setImageDescriptor(AuroraPlugin.getImageDescriptor("icons/export.png"));
        this.dbLoadAction = new Action(){

            public void run() {
                LoadDataWizard wizard = new LoadDataWizard();
                WizardDialog dialog = new WizardDialog(StatisticsView.this.getSite().getShell(), (IWizard)wizard);
                int reslut = dialog.open();
                if (reslut == 0) {
                    LoadFromDBJob job = new LoadFromDBJob(wizard.getProject(), wizard.getStatisticsProject(), StatisticsView.this);
                    job.setUser(true);
                    job.schedule();
                    StatisticsView.this.setSaveToDBActionEnabled(false);
                    StatisticsView.this.setSaveToXLSActionEnabled(false);
                }
            }
        };
        this.dbLoadAction.setToolTipText(Messages.StatisticsView_Load_From_DB);
        this.dbLoadAction.setImageDescriptor(AuroraPlugin.getImageDescriptor("icons/import.png"));
        this.fileSelectionAction = new Action(){

            public void run() {
                ResourceSelectionDialog dialog = new ResourceSelectionDialog(StatisticsView.this.getSite().getShell(), (IAdaptable)AuroraPlugin.getWorkspace().getRoot(), Messages.StatisticsView_Select_Need_Statistics_File);
                dialog.setHelpAvailable(false);
                dialog.setTitle(Messages.StatisticsView_Select_File);
                int open = dialog.open();
                if (open == 0) {
                    Object[] selected = dialog.getResult();
                    StatisticianRunner runner = new StatisticianRunner(StatisticsView.this);
                    runner.noProjectRun(selected);
                    StatisticsView.this.setSaveToDBActionEnabled(false);
                    StatisticsView.this.setSaveToXLSActionEnabled(false);
                }
            }
        };
        this.fileSelectionAction.setText(Messages.StatisticsView_Select_File);
        this.fileSelectionAction.setToolTipText(Messages.StatisticsView_Select_Need_Statistics_File);
        this.fileSelectionAction.setImageDescriptor(AuroraPlugin.getImageDescriptor("icons/file.png"));
        this.projectSelectionAction = new Action(){

            public void run() {
                ResourceListSelectionDialog dialog = new ResourceListSelectionDialog(StatisticsView.this.getSite().getShell(), (IContainer)AuroraPlugin.getWorkspace().getRoot(), 4);
                dialog.setHelpAvailable(false);
                dialog.setTitle(Messages.StatisticsView_Select_Project);
                int open = dialog.open();
                if (open == 0) {
                    Object[] selected = dialog.getResult();
                    StatisticianRunner runner = new StatisticianRunner(StatisticsView.this);
                    runner.projectRun(selected);
                    StatisticsView.this.setSaveToDBActionEnabled(false);
                    StatisticsView.this.setSaveToXLSActionEnabled(false);
                }
            }
        };
        this.projectSelectionAction.setText(Messages.StatisticsView_Select_Project);
        this.projectSelectionAction.setToolTipText(Messages.StatisticsView_Select_Need_Statistics_Project);
        this.projectSelectionAction.setImageDescriptor(AuroraPlugin.getImageDescriptor("icons/project.png"));
        this.saveToXLSAction = new Action(){

            public void run() {
                FileDialog dialog = new FileDialog(StatisticsView.this.getSite().getShell(), 8192);
                dialog.setFilterExtensions(new String[]{"*.xls", "*.*"});
                final String path = dialog.open();
                if (path == null) {
                    return;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            HSSFWorkbook workbook = new HSSFWorkbook();
                            HSSFSheet sheet = workbook.createSheet();
                            HSSFRow row = sheet.createRow(0);
                            int i = 0;
                            while (i < oViewColTitles.length) {
                                HSSFCell cell = row.createCell(i);
                                cell.setCellType(1);
                                cell.setCellValue(oViewColTitles[i]);
                                ++i;
                            }
                            this.fillExcelContent(sheet);
                            sheet.autoSizeColumn(1);
                            sheet.autoSizeColumn(2);
                            FileOutputStream fOut = new FileOutputStream(path);
                            workbook.write((OutputStream)fOut);
                            fOut.flush();
                            fOut.close();
                        }
                        catch (IOException e) {
                            DialogUtil.logErrorException(e);
                        }
                    }
                });
            }

            private void fillExcelContent(HSSFSheet sheet) {
                StatisticsResult result = (StatisticsResult)StatisticsView.this.objectViewer.getInput();
                List listAll = result.getProjectObjects();
                int i = 0;
                while (i < listAll.size()) {
                    HSSFRow row = sheet.createRow(i + 1);
                    HSSFCell cell = row.createCell(0);
                    cell.setCellType(1);
                    cell.setCellValue(((ProjectObject)listAll.get(i)).getType());
                    cell = row.createCell(1);
                    cell.setCellType(1);
                    cell.setCellValue(((ProjectObject)listAll.get(i)).getName());
                    cell = row.createCell(2);
                    cell.setCellType(1);
                    cell.setCellValue(((ProjectObject)listAll.get(i)).getPath());
                    cell = row.createCell(3);
                    cell.setCellType(1);
                    cell.setCellValue(this.conversion(((ProjectObject)listAll.get(i)).getFileSize()));
                    cell = row.createCell(4);
                    cell.setCellType(1);
                    cell.setCellValue(this.conversion(((ProjectObject)listAll.get(i)).getScriptSize()));
                    cell = row.createCell(5);
                    cell.setCellType(0);
                    cell.setCellValue((double)((ProjectObject)listAll.get(i)).getTags().size());
                    cell = row.createCell(6);
                    cell.setCellType(0);
                    cell.setCellValue((double)((ProjectObject)listAll.get(i)).getDependencies().size());
                    cell = row.createCell(7);
                    cell.setCellType(0);
                    cell.setCellValue((double)((ProjectObject)listAll.get(i)).getReferenced());
                    ++i;
                }
            }

            private String conversion(int num) {
                String value = Integer.toString(num);
                DecimalFormat df = new DecimalFormat("0.00");
                double v = Double.parseDouble(value);
                if (value.length() > 3 && value.length() <= 6) {
                    return String.valueOf(df.format(v /= 1024.0)) + " KB";
                }
                if (value.length() > 6) {
                    return String.valueOf(df.format(v /= 1048576.0)) + " MB";
                }
                return String.valueOf((int)v) + " Byte";
            }
        };
        this.saveToXLSAction.setText(Messages.StatisticsView_Export_Excel);
        this.saveToXLSAction.setToolTipText(Messages.StatisticsView_Export_Excel);
        this.saveToXLSAction.setImageDescriptor(AuroraPlugin.getImageDescriptor("icons/palette/toolbar_btn_05.png"));
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.objectViewer.getControl().getShell(), (String)"Sample View", (String)message);
    }

    public void setFocus() {
        this.objectViewer.getControl().setFocus();
    }

    public void setSaveToDBActionEnabled(boolean bool) {
        this.saveToDBAction.setEnabled(bool);
    }

    public void setSaveToXLSActionEnabled(boolean bool) {
        this.saveToXLSAction.setEnabled(bool);
    }
}

