/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.statistics.wizard.dialog;

import aurora.ide.api.statistics.DatabaseAction;
import aurora.ide.api.statistics.model.StatisticsProject;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.helpers.DBManager;
import aurora.ide.helpers.DialogUtil;
import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SecondLoadDataWizardPage
extends WizardPage {
    private StatisticsProject[] projects;
    private Combo cboProjectName;
    private Text txtStorer;
    private Text txtStorerDate;
    private Text txtRepositoryType;
    private Text txtRepositoryRevesion;
    private Text txtRepositoryPath;
    private StatisticsProject statisticsProject;
    private IProject project;

    public SecondLoadDataWizardPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
    }

    public StatisticsProject getStatisticsProject() {
        return this.statisticsProject;
    }

    public IProject getProject() {
        return this.project;
    }

    public void init(IProject project) {
        this.project = project;
        Connection con = null;
        try {
            try {
                DBManager db = new DBManager(project);
                con = db.getConnection();
                this.projects = DatabaseAction.readAllProject((Connection)con);
            }
            catch (SQLException e) {
                DialogUtil.logErrorException(e);
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException e2) {
                    DialogUtil.logErrorException(e2);
                    return;
                }
                return;
            }
            catch (ApplicationException e) {
                DialogUtil.showExceptionMessageBox(e);
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (SQLException e3) {
                    DialogUtil.logErrorException(e3);
                    return;
                }
                return;
            }
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e) {
                DialogUtil.logErrorException(e);
                return;
            }
        }
        int i = 0;
        while (i < this.projects.length) {
            int j = i + 1;
            while (j < this.projects.length) {
                int sj;
                int si = Integer.parseInt(this.projects[i].getProjectId());
                if (si < (sj = Integer.parseInt(this.projects[j].getProjectId()))) {
                    StatisticsProject temp = this.projects[i];
                    this.projects[i] = this.projects[j];
                    this.projects[j] = temp;
                }
                ++j;
            }
            String s = String.valueOf(this.projects[i].getProjectId()) + ":" + this.projects[i].getProjectName();
            this.cboProjectName.add(s);
            this.cboProjectName.setData(s, (Object)this.projects[i]);
            ++i;
        }
    }

    private void fillInfo(StatisticsProject sProject) {
        this.txtStorer.setText(sProject.getStorer());
        this.txtStorerDate.setText(sProject.getStoreDate());
        this.txtRepositoryType.setText(sProject.getRepositoryType());
        this.txtRepositoryRevesion.setText(sProject.getRepositoryRevision());
        this.txtRepositoryPath.setText(sProject.getRepositoryPath());
        this.statisticsProject = sProject;
        this.setPageComplete(true);
    }

    public void clear() {
        this.cboProjectName.removeAll();
        this.txtStorer.setText("");
        this.txtStorerDate.setText("");
        this.txtRepositoryType.setText("");
        this.txtRepositoryRevesion.setText("");
        this.txtRepositoryPath.setText("");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.setTitle("\u8f7d\u5165\u6570\u636e");
        this.setDescription("\u9009\u62e9\u9879\u76ee");
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        Label lblProjectName = new Label(container, 0);
        lblProjectName.setText("\u9879\u76ee\u540d\uff1a");
        GridData gbProjectName = new GridData(768);
        this.cboProjectName = new Combo(container, 12);
        this.cboProjectName.setLayoutData((Object)gbProjectName);
        this.cboProjectName.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Combo bo = (Combo)e.getSource();
                SecondLoadDataWizardPage.this.fillInfo((StatisticsProject)bo.getData(bo.getText()));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label lblRepositoryType = new Label(container, 0);
        lblRepositoryType.setText("\u8d44\u6e90\u5e93\u7c7b\u578b\uff1a");
        GridData gdRepositoryType = new GridData(768);
        this.txtRepositoryType = new Text(container, 2056);
        this.txtRepositoryType.setLayoutData((Object)gdRepositoryType);
        Label lblRepositoryRevesion = new Label(container, 0);
        lblRepositoryRevesion.setText("\u8d44\u6e90\u5e93\u7248\u672c\uff1a");
        GridData gdRepositoryRevesion = new GridData(768);
        this.txtRepositoryRevesion = new Text(container, 2056);
        this.txtRepositoryRevesion.setLayoutData((Object)gdRepositoryRevesion);
        Label lblRepositoryPath = new Label(container, 0);
        lblRepositoryPath.setText("\u8d44\u6e90\u5e93\u8def\u5f84\uff1a");
        GridData gdRepositoryPath = new GridData(768);
        this.txtRepositoryPath = new Text(container, 2056);
        this.txtRepositoryPath.setLayoutData((Object)gdRepositoryPath);
        Label lblStorer = new Label(container, 0);
        lblStorer.setText("\u4fdd\u5b58\u4eba\uff1a");
        GridData gdStorer = new GridData(768);
        this.txtStorer = new Text(container, 2056);
        this.txtStorer.setLayoutData((Object)gdStorer);
        Label lblStorerDate = new Label(container, 0);
        lblStorerDate.setText("\u4fdd\u5b58\u65f6\u95f4\uff1a");
        GridData gdStorerDate = new GridData(768);
        this.txtStorerDate = new Text(container, 2056);
        this.txtStorerDate.setLayoutData((Object)gdStorerDate);
        this.setControl((Control)container);
    }
}

