/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.builder;

import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToStringBuilder<T> {
    private static ToStringStyle defaultStyle = ToStringStyle.DEFAULT_STYLE;
    private final StringBuffer buffer;
    private final T object;
    private final ToStringStyle style;

    public static ToStringStyle getDefaultStyle() {
        return defaultStyle;
    }

    public static String reflectionToString(Object object) {
        return ReflectionToStringBuilder.toString(object);
    }

    public static String reflectionToString(Object object, ToStringStyle style) {
        return ReflectionToStringBuilder.toString(object, style);
    }

    public static String reflectionToString(Object object, ToStringStyle style, boolean outputTransients) {
        return ReflectionToStringBuilder.toString(object, style, outputTransients, false, null);
    }

    public static <T> String reflectionToString(T object, ToStringStyle style, boolean outputTransients, Class<? super T> reflectUpToClass) {
        return ReflectionToStringBuilder.toString(object, style, outputTransients, false, reflectUpToClass);
    }

    public static void setDefaultStyle(ToStringStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("The style must not be null");
        }
        defaultStyle = style;
    }

    public ToStringBuilder(T object) {
        this(object, ToStringBuilder.getDefaultStyle(), null);
    }

    public ToStringBuilder(T object, ToStringStyle style) {
        this(object, style, null);
    }

    public ToStringBuilder(T object, ToStringStyle style, StringBuffer buffer) {
        if (style == null) {
            style = ToStringBuilder.getDefaultStyle();
        }
        if (buffer == null) {
            buffer = new StringBuffer(512);
        }
        this.buffer = buffer;
        this.style = style;
        this.object = object;
        style.appendStart(buffer, object);
    }

    public ToStringBuilder<T> append(boolean value) {
        this.style.append(this.buffer, null, value);
        return this;
    }

    public ToStringBuilder<T> append(boolean[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder<T> append(byte value) {
        this.style.append(this.buffer, (String)null, value);
        return this;
    }

    public ToStringBuilder<T> append(byte[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder<T> append(char value) {
        this.style.append(this.buffer, (String)null, value);
        return this;
    }

    public ToStringBuilder<T> append(char[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder<T> append(double value) {
        this.style.append(this.buffer, null, value);
        return this;
    }

    public ToStringBuilder<T> append(double[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder<T> append(float value) {
        this.style.append(this.buffer, (String)null, value);
        return this;
    }

    public ToStringBuilder<T> append(float[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder<T> append(int value) {
        this.style.append(this.buffer, (String)null, value);
        return this;
    }

    public ToStringBuilder<T> append(int[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder<T> append(long value) {
        this.style.append(this.buffer, (String)null, value);
        return this;
    }

    public ToStringBuilder<T> append(long[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder<T> append(Object obj) {
        this.style.append(this.buffer, null, obj, null);
        return this;
    }

    public ToStringBuilder<T> append(Object[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder<T> append(short value) {
        this.style.append(this.buffer, (String)null, value);
        return this;
    }

    public ToStringBuilder<T> append(short[] array) {
        this.style.append(this.buffer, (String)null, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, boolean value) {
        this.style.append(this.buffer, fieldName, value);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, boolean[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, boolean[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, byte value) {
        this.style.append(this.buffer, fieldName, value);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, byte[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, byte[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, char value) {
        this.style.append(this.buffer, fieldName, value);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, char[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, char[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, double value) {
        this.style.append(this.buffer, fieldName, value);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, double[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, double[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, float value) {
        this.style.append(this.buffer, fieldName, value);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, float[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, float[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, int value) {
        this.style.append(this.buffer, fieldName, value);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, int[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, int[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, long value) {
        this.style.append(this.buffer, fieldName, value);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, long[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, long[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, Object obj) {
        this.style.append(this.buffer, fieldName, obj, null);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, Object obj, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, obj, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, Object[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, Object[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, short value) {
        this.style.append(this.buffer, fieldName, value);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, short[] array) {
        this.style.append(this.buffer, fieldName, array, (Boolean)null);
        return this;
    }

    public ToStringBuilder<T> append(String fieldName, short[] array, boolean fullDetail) {
        this.style.append(this.buffer, fieldName, array, (Boolean)fullDetail);
        return this;
    }

    public ToStringBuilder<T> appendAsObjectToString(Object object) {
        ObjectUtils.identityToString(this.getStringBuffer(), object);
        return this;
    }

    public ToStringBuilder<T> appendSuper(String superToString) {
        if (superToString != null) {
            this.style.appendSuper(this.buffer, superToString);
        }
        return this;
    }

    public ToStringBuilder<T> appendToString(String toString) {
        if (toString != null) {
            this.style.appendToString(this.buffer, toString);
        }
        return this;
    }

    public T getObject() {
        return this.object;
    }

    public StringBuffer getStringBuffer() {
        return this.buffer;
    }

    public ToStringStyle getStyle() {
        return this.style;
    }

    public String toString() {
        if (this.getObject() == null) {
            this.getStringBuffer().append(this.getStyle().getNullText());
        } else {
            this.style.appendEnd(this.getStringBuffer(), this.getObject());
        }
        return this.getStringBuffer().toString();
    }
}

