/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta;

import aurora.ide.helpers.FileCopyer;
import aurora.ide.helpers.FileDeleter;
import aurora.ide.meta.gef.editors.source.gen.core.GeneratorManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class MetaPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "aurora.ide.meta";
    private static MetaPlugin plugin;
    public static boolean isDemonstrate;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.uipTemplateConfirm();
        this.sourceGenTemplateConfirm();
    }

    private void uipTemplateConfirm() {
        IPath template = this.getStateLocation().append("template");
        File tplt = template.toFile();
        if (tplt.isDirectory() && tplt.exists()) {
            return;
        }
        this.copyTemplateFile();
    }

    private void sourceGenTemplateConfirm() {
        File ver;
        IPath template = GeneratorManager.getDefaultSourceGenTemplatePath();
        File tplt = template.toFile();
        if (tplt.isDirectory() && tplt.exists() && (ver = template.append("config").append("1.0.xml").toFile()).exists()) {
            return;
        }
        FileDeleter.deleteDirectory((File)tplt);
        this.copySourceGenTemplateFiles();
    }

    public void copySourceGenTemplateFiles() {
        URL ts = FileLocator.find((Bundle)Platform.getBundle((String)PLUGIN_ID), (IPath)new Path("source.gen"), null);
        try {
            ts = FileLocator.toFileURL((URL)ts);
            IPath template = GeneratorManager.getDefaultSourceGenTemplatePath();
            File tplt = template.toFile();
            FileCopyer.copyDirectory((File)new File(ts.getFile()), (File)tplt);
        }
        catch (IOException e) {
            this.getLog().log((IStatus)new Status(4, PLUGIN_ID, "template failed init. ", (Throwable)e));
        }
    }

    public void copyTemplateFile() {
        URL ts = FileLocator.find((Bundle)Platform.getBundle((String)PLUGIN_ID), (IPath)new Path("template"), null);
        try {
            ts = FileLocator.toFileURL((URL)ts);
            IPath template = this.getStateLocation().append("template");
            File tplt = template.toFile();
            FileCopyer.copyDirectory((File)new File(ts.getFile()), (File)tplt);
        }
        catch (IOException e) {
            this.getLog().log((IStatus)new Status(4, PLUGIN_ID, "template failed init. ", (Throwable)e));
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static MetaPlugin getDefault() {
        return plugin;
    }

    public static InputStream openFileStream(String path) throws IOException {
        return FileLocator.openStream((Bundle)Platform.getBundle((String)PLUGIN_ID), (IPath)new Path(path), (boolean)false);
    }

    public IDialogSettings getDialogSettingsSection(String name) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(name);
        if (section == null) {
            section = dialogSettings.addNewSection(name);
        }
        return section;
    }
}

