/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer;

import aurora.ide.editor.textpage.ColorManager;
import aurora.ide.editor.textpage.SQLConfiguration;
import aurora.ide.meta.exception.ResourceNotFoundException;
import aurora.ide.meta.gef.designer.CreateTableAction;
import aurora.ide.meta.gef.designer.gen.SqlGenerator;
import aurora.ide.meta.gef.designer.model.BMModel;
import aurora.ide.meta.gef.editors.PrototypeImagesUtils;
import aurora.ide.meta.project.AuroraMetaProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class CreateTablePage
extends FormPage {
    public static final String java_editor_font_key = "org.eclipse.jdt.ui.editors.textfont";
    private BMModel model;
    private IProject aProj;
    private StyledText styledText;
    private String[] sqlArr;

    public CreateTablePage(String id, String title) {
        super(id, title);
    }

    public CreateTablePage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public void setModel(BMModel model) {
        this.model = model;
    }

    public void refresh() {
        IFile inputFile = (IFile)this.getEditor().getAdapter(IFile.class);
        String name = inputFile.getName();
        int idx = name.indexOf(46);
        if (idx != -1) {
            name = name.substring(0, idx);
        }
        this.sqlArr = new SqlGenerator(this.model, name).gen();
        String text = this.join(this.sqlArr);
        if (!text.equals(this.styledText.getText())) {
            this.styledText.setText(text);
        }
        this.styledText.forceFocus();
    }

    private String join(String[] strs) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(s).append(";\n");
            ++n2;
        }
        return sb.toString();
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.refresh();
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm sform = managedForm.getForm();
        sform.setLayout((Layout)new FillLayout(256));
        sform.setText("SQL Source Code");
        toolkit.decorateFormHeading(sform.getForm());
        this.createActions(sform.getToolBarManager());
        Composite body = sform.getBody();
        body.setLayout((Layout)new FillLayout(256));
        SourceViewer sourceViewer = new SourceViewer(body, null, 2824);
        sourceViewer.configure((SourceViewerConfiguration)new SQLConfiguration(new ColorManager()));
        Document document = new Document();
        sourceViewer.setDocument((IDocument)document);
        this.styledText = sourceViewer.getTextWidget();
        toolkit.paintBordersFor((Composite)this.styledText);
        this.setFont();
    }

    private void setFont() {
        IPreferenceStore pStore = PlatformUI.getWorkbench().getPreferenceStore();
        pStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals(CreateTablePage.java_editor_font_key)) {
                    String str = event.getNewValue().toString();
                    FontData[] fds = PreferenceConverter.basicGetFontData((String)str);
                    CreateTablePage.this.styledText.setFont(new Font(null, fds));
                }
            }
        });
        String str = pStore.getString(java_editor_font_key);
        FontData[] fds = PreferenceConverter.basicGetFontData((String)str);
        this.styledText.setFont(new Font(null, fds));
    }

    private void createActions(IToolBarManager tbm) {
        IFile file = (IFile)this.getEditor().getAdapter(IFile.class);
        try {
            AuroraMetaProject amp = new AuroraMetaProject(file.getProject());
            this.aProj = amp.getAuroraProject();
        }
        catch (ResourceNotFoundException e) {
            throw new RuntimeException(e);
        }
        final Action forceAction = new Action("force override", 2){
            {
                this.setImageDescriptor(PrototypeImagesUtils.getImageDescriptor("lightning_plus.png"));
            }
        };
        Action whoAction = new Action("Standered Who", 2){

            public void run() {
                CreateTablePage.this.model.setWhoEnabled(this.isChecked());
                CreateTablePage.this.refresh();
            }
        };
        whoAction.setImageDescriptor(PrototypeImagesUtils.getImageDescriptor("person.png"));
        tbm.add((IAction)new CreateTableAction(this.aProj){

            public String[] getSQLs() {
                return CreateTablePage.this.sqlArr;
            }

            public boolean isForce() {
                return forceAction.isChecked();
            }
        });
        tbm.add((IAction)whoAction);
        tbm.add((IAction)forceAction);
        tbm.update(true);
    }
}

