/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.actions;

import aurora.ide.meta.extensions.ComponentFactory;
import aurora.ide.meta.gef.editors.PrototypeImagesUtils;
import aurora.ide.meta.gef.editors.actions.TypeChangeAction;
import aurora.ide.meta.gef.editors.models.commands.ChangeTypeCommand;
import aurora.ide.meta.gef.editors.parts.ComponentPart;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.BOX;
import aurora.plugin.source.gen.screen.model.CheckBox;
import aurora.plugin.source.gen.screen.model.Container;
import aurora.plugin.source.gen.screen.model.FieldSet;
import aurora.plugin.source.gen.screen.model.Form;
import aurora.plugin.source.gen.screen.model.HBox;
import aurora.plugin.source.gen.screen.model.Input;
import aurora.plugin.source.gen.screen.model.VBox;
import java.util.ArrayList;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public class TypeChangeUtil {
    private CommandStack commandStack;

    public TypeChangeUtil(CommandStack commandStack) {
        this.commandStack = commandStack;
    }

    public Action[] getActionFor(AuroraComponent ac) {
        ArrayList<TypeChangeAction> als = new ArrayList<TypeChangeAction>();
        if (ac instanceof Input) {
            String[] types = new String[]{"textField", "numberField", "comboBox", "lov", "datePicker", "dateTimePicker"};
            if (ac instanceof CheckBox) {
                String[] stringArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    InputTypeChangeAction action = new InputTypeChangeAction(s);
                    action.setInput((Input)ac);
                    als.add(action);
                    ++n2;
                }
            } else {
                String[] stringArray = types;
                int n = types.length;
                int n3 = 0;
                while (n3 < n) {
                    String s = stringArray[n3];
                    if (s.equals(ac.getComponentType())) {
                        s = "checkBox";
                    }
                    InputTypeChangeAction action = new InputTypeChangeAction(s);
                    action.setInput((Input)ac);
                    als.add(action);
                    ++n3;
                }
            }
        } else if (ac instanceof Form) {
            BoxChangeAction action = new BoxChangeAction("fieldSet");
            action.setModelType((BOX)((Form)ac), FieldSet.class);
            als.add(action);
        } else if (ac instanceof FieldSet) {
            BoxChangeAction action = new BoxChangeAction("form");
            action.setModelType((BOX)((FieldSet)ac), Form.class);
            als.add(action);
        } else if (ac instanceof HBox) {
            BoxChangeAction action = new BoxChangeAction("VBox");
            action.setModelType((BOX)((HBox)ac), VBox.class);
            als.add(action);
        } else if (ac instanceof VBox) {
            BoxChangeAction action = new BoxChangeAction("HBox");
            action.setModelType((BOX)((VBox)ac), HBox.class);
            als.add(action);
        }
        return als.toArray(new Action[als.size()]);
    }

    public IAction[] getActionFor(IStructuredSelection ss) {
        ArrayList<TypeChangeAction> als = new ArrayList<TypeChangeAction>();
        Object ele = ss.getFirstElement();
        AuroraComponent ac = (AuroraComponent)((ComponentPart)ele).getModel();
        if (ss.size() == 1) {
            return this.getActionFor(ac);
        }
        if (ac instanceof Input) {
            String[] types;
            String[] stringArray = types = new String[]{"textField", "numberField", "comboBox", "lov", "datePicker", "dateTimePicker", "checkBox"};
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                InputsTypeChangeAction action = new InputsTypeChangeAction(s);
                action.setSelection(ss);
                als.add(action);
                ++n2;
            }
        } else if (ac instanceof Form) {
            BoxChangeAction action = new BoxChangeAction("fieldSet");
            action.setModelType((BOX)((Form)ac), FieldSet.class);
            als.add(action);
        } else if (ac instanceof FieldSet) {
            BoxChangeAction action = new BoxChangeAction("form");
            action.setModelType((BOX)((FieldSet)ac), Form.class);
            als.add(action);
        } else if (ac instanceof HBox) {
            BoxChangeAction action = new BoxChangeAction("VBox");
            action.setModelType((BOX)((HBox)ac), VBox.class);
            als.add(action);
        } else if (ac instanceof VBox) {
            BoxChangeAction action = new BoxChangeAction("HBox");
            action.setModelType((BOX)((VBox)ac), HBox.class);
            als.add(action);
        }
        return (IAction[])als.toArray(new Action[als.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class BoxChangeAction
    extends TypeChangeAction {
        private BOX oldCmp;
        private BOX newCmp;
        private Class<? extends BOX> newCls;

        public BoxChangeAction(String string) {
            super(string);
            String imgKey = "";
            if ("form".equals(string)) {
                imgKey = "palette/form.png";
            } else if ("fieldSet".equalsIgnoreCase(string)) {
                imgKey = "palette/fieldset.png";
            } else if ("hBox".equalsIgnoreCase(string)) {
                imgKey = "palette/hbox.png";
            } else if ("vBox".equalsIgnoreCase(string)) {
                imgKey = "palette/vbox.png";
            }
            this.setImageDescriptor(PrototypeImagesUtils.getImageDescriptor(imgKey));
        }

        public void setModelType(BOX oldType, Class<? extends BOX> newType) {
            this.oldCmp = oldType;
            this.newCls = newType;
        }

        public void run() {
            ChangeTypeCommand cmd = new ChangeTypeCommand(this);
            TypeChangeUtil.this.commandStack.execute((Command)cmd);
        }

        @Override
        public void apply() {
            try {
                this.newCmp = this.newCls.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.newCmp == null) {
                return;
            }
            Container cont = this.oldCmp.getParent();
            int idx = cont.getChildren().indexOf(this.oldCmp);
            cont.removeChild(idx);
            this.newCmp.setRow(this.oldCmp.getRow());
            this.newCmp.setCol(this.oldCmp.getCol());
            this.newCmp.setPrompt(this.oldCmp.getPrompt());
            this.newCmp.setTitle(this.oldCmp.getTitle());
            this.newCmp.setSectionType(this.oldCmp.getSectionType());
            for (AuroraComponent a : this.oldCmp.getChildren()) {
                this.newCmp.addChild(a);
            }
            cont.addChild((AuroraComponent)this.newCmp, idx);
        }

        @Override
        public void unApply() {
            Container cont = this.newCmp.getParent();
            int idx = cont.getChildren().indexOf(this.newCmp);
            cont.removeChild(idx);
            this.oldCmp.getChildren().clear();
            for (AuroraComponent a : this.newCmp.getChildren()) {
                this.oldCmp.addChild(a);
            }
            cont.addChild((AuroraComponent)this.oldCmp, idx);
            this.oldCmp.setRow(this.newCmp.getRow());
            this.oldCmp.setCol(this.newCmp.getCol());
            this.oldCmp.setPrompt(this.newCmp.getPrompt());
            this.oldCmp.setTitle(this.newCmp.getTitle());
            this.oldCmp.setSectionType(this.newCmp.getSectionType());
        }
    }

    class InputTypeChangeAction
    extends TypeChangeAction {
        public static final int TYPE_CHANGE_MODE1 = 1;
        public static final int TYPE_CHANGE_MODE2 = 2;
        public static final int TYPE_CHANGE_MODE3 = 4;
        private String newType;
        private String oldType;
        private Input input;
        private Input newInput;
        private int type_change_mode;

        public InputTypeChangeAction(String text) {
            super(text);
            this.type_change_mode = 1;
            this.newType = text;
            String imageKey = "";
            if ("comboBox".equals(text)) {
                imageKey = "palette/itembar_01.png";
            } else if ("datePicker".equals(text) || "dateTimePicker".equals(text)) {
                imageKey = "palette/itembar_02.png";
            } else if ("lov".endsWith(text)) {
                imageKey = "palette/itembar_03.png";
            } else if ("numberField".endsWith(text)) {
                imageKey = "palette/itembar_05.png";
            } else if ("textField".equals(text)) {
                imageKey = "palette/itembar_04.png";
            } else if ("checkBox".equals(text)) {
                imageKey = "palette/checkbox_01.png";
            }
            this.setImageDescriptor(PrototypeImagesUtils.getImageDescriptor(imageKey));
        }

        public void setInput(Input input) {
            this.input = input;
            this.oldType = input.getComponentType();
            if ("checkBox".equals(this.newType)) {
                this.type_change_mode = 2;
            } else if (input.getClass().equals(CheckBox.class)) {
                this.type_change_mode = 4;
            }
        }

        public void run() {
            ChangeTypeCommand cmd = new ChangeTypeCommand(this);
            TypeChangeUtil.this.commandStack.execute((Command)cmd);
        }

        public void apply() {
            this.newInput = (Input)ComponentFactory.createComponent(this.newType);
            this.newInput.setReadOnly(this.input.isReadOnly());
            this.newInput.setRequired(this.input.isRequired());
            this.newInput.setPrompt(this.input.getPrompt());
            this.newInput.setName(this.input.getName());
            this.newInput.setEmptyText(this.input.getEmptyText());
            this.newInput.setTypeCase(this.input.getTypeCase());
            Container cont = this.input.getParent();
            int idx = cont.getChildren().indexOf(this.input);
            cont.removeChild(idx);
            cont.addChild((AuroraComponent)this.newInput, idx);
        }

        public void unApply() {
            Container cont = this.newInput.getParent();
            int idx = cont.getChildren().indexOf(this.newInput);
            cont.removeChild(idx);
            cont.addChild((AuroraComponent)this.input, idx);
            this.input.setReadOnly(this.newInput.isReadOnly());
            this.input.setRequired(this.newInput.isRequired());
            this.input.setPrompt(this.newInput.getPrompt());
            this.input.setName(this.newInput.getName());
            this.input.setEmptyText(this.newInput.getEmptyText());
            this.input.setTypeCase(this.newInput.getTypeCase());
        }
    }

    public class InputsTypeChangeAction
    extends TypeChangeAction {
        private ArrayList<TypeChangeAction> runningActions;
        private String newType;

        public InputsTypeChangeAction(String text) {
            super(text);
            this.runningActions = new ArrayList();
            this.newType = text;
            String imageKey = "";
            if ("comboBox".equals(text)) {
                imageKey = "palette/itembar_01.png";
            } else if ("datePicker".equals(text) || "dateTimePicker".equals(text)) {
                imageKey = "palette/itembar_02.png";
            } else if ("lov".endsWith(text)) {
                imageKey = "palette/itembar_03.png";
            } else if ("numberField".endsWith(text)) {
                imageKey = "palette/itembar_05.png";
            } else if ("textField".equals(text)) {
                imageKey = "palette/itembar_04.png";
            } else if ("checkBox".equals(text)) {
                imageKey = "palette/checkbox_01.png";
            }
            this.setImageDescriptor(PrototypeImagesUtils.getImageDescriptor(imageKey));
        }

        public void run() {
            for (IAction iAction : this.runningActions) {
                iAction.run();
            }
        }

        public void apply() {
            for (TypeChangeAction a : this.runningActions) {
                a.apply();
            }
        }

        public void unApply() {
            for (TypeChangeAction a : this.runningActions) {
                a.unApply();
            }
        }

        public void setSelection(IStructuredSelection ss) {
            Object[] array;
            Object[] objectArray = array = ss.toArray();
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                AuroraComponent ac = (AuroraComponent)((ComponentPart)object).getModel();
                InputTypeChangeAction action = new InputTypeChangeAction(this.newType);
                action.setInput((Input)ac);
                this.runningActions.add(action);
                ++n2;
            }
        }
    }
}

