/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.composite;

import aurora.ide.AuroraPlugin;
import aurora.ide.builder.ResourceUtil;
import aurora.ide.meta.exception.ResourceNotFoundException;
import aurora.ide.meta.gef.editors.composite.IPathChangeListener;
import aurora.ide.meta.gef.editors.property.MutilInputResourceSelector;
import aurora.ide.meta.project.AuroraMetaProject;
import aurora.ide.search.core.Util;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class ScreenUIPBrowseButton {
    private List<IPathChangeListener> listeners;
    private String openPath;
    private IProject auroraProject;
    private Button button;

    public IProject getAuroraProject() {
        return this.auroraProject;
    }

    public void setAuroraProject(IProject auroraProject) {
        this.auroraProject = auroraProject;
    }

    public ScreenUIPBrowseButton(Composite parent, int style) {
        this.button = new Button(parent, style);
        this.addSelectionListener(parent);
    }

    public void addListener(IPathChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IPathChangeListener>();
        }
        this.listeners.add(listener);
    }

    private void addSelectionListener(final Composite parent) {
        this.button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MutilInputResourceSelector fss = new MutilInputResourceSelector(parent.getShell());
                fss.setExtFilter(new String[]{"screen", "uip"});
                IContainer uipFolder = ScreenUIPBrowseButton.this.getUIPFolder();
                if (ScreenUIPBrowseButton.this.auroraProject == null) {
                    fss.setInput(uipFolder);
                } else {
                    String webHome = ResourceUtil.getWebHome((IProject)ScreenUIPBrowseButton.this.auroraProject);
                    IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(webHome);
                    fss.setInputs(new IContainer[]{(IContainer)res, uipFolder});
                }
                IResource obj = fss.getSelection();
                if (obj instanceof IFile) {
                    IFile file = (IFile)obj;
                    String fileExtension = file.getFileExtension();
                    if ("uip".equalsIgnoreCase(fileExtension)) {
                        IPath path = file.getFullPath();
                        if (uipFolder != null) {
                            path = path.makeRelativeTo(uipFolder.getFullPath());
                        }
                        ScreenUIPBrowseButton.this.setOpenPath(path.toString());
                        return;
                    }
                    if ("screen".equalsIgnoreCase(fileExtension)) {
                        IPath path = file.getFullPath();
                        IContainer findWebInf = Util.findWebInf((IResource)file);
                        if (findWebInf != null) {
                            IContainer web = findWebInf.getParent();
                            path = path.makeRelativeTo(web.getFullPath());
                        }
                        ScreenUIPBrowseButton.this.setOpenPath(path.toString());
                        return;
                    }
                }
                ScreenUIPBrowseButton.this.setOpenPath(null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public IContainer getUIPFolder() {
        IFile activeIFile = AuroraPlugin.getActiveIFile();
        IProject proj = activeIFile.getProject();
        AuroraMetaProject mProj = new AuroraMetaProject(proj);
        try {
            return mProj.getScreenFolder();
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            return mProj.getProject();
        }
    }

    public String getOpenPath() {
        return this.openPath;
    }

    public void setOpenPath(String openPath) {
        this.openPath = openPath;
        if (this.listeners != null) {
            for (IPathChangeListener l : this.listeners) {
                l.pathChanged(openPath);
            }
        }
    }

    public void setText(String string) {
        this.button.setText(string);
    }

    public void setEnabled(boolean enabled) {
        this.button.setEnabled(enabled);
    }
}

