/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.figures;

import aurora.ide.libs.AuroraImagesUtils;
import aurora.ide.meta.gef.editors.PrototypeImagesUtils;
import aurora.ide.meta.gef.editors.figures.ColorConstants;
import aurora.ide.meta.gef.editors.figures.IResourceDispose;
import aurora.ide.meta.gef.editors.figures.ResourceDisposer;
import aurora.ide.meta.gef.editors.figures.ToolbarFigure;
import aurora.ide.meta.gef.util.BoundsConvert;
import aurora.ide.meta.gef.util.MessageUtil;
import aurora.ide.meta.gef.util.TextStyleUtil;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.Button;
import aurora.plugin.source.gen.screen.model.StyledStringText;
import aurora.plugin.source.gen.screen.model.ToolbarButton;
import java.util.Arrays;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class ToolbarButtonFigure
extends Figure
implements IResourceDispose {
    private static Image bgImg = PrototypeImagesUtils.getImage("btn.gif");
    private static String[] buttonTypes = new String[]{"add", "save", "delete", "clear", "excel"};
    private static Image stdimg = PrototypeImagesUtils.getImage("aurora/toolbar_btn.gif");
    private static Image defaultimg = PrototypeImagesUtils.getImage("aurora/default.gif");
    private ToolbarButton model = null;
    private ResourceDisposer disposer = new ResourceDisposer();

    public void handleFocusGained(FocusEvent event) {
        super.handleFocusGained(event);
    }

    protected void paintFigure(Graphics g) {
        String text;
        super.paintFigure(g);
        g.pushState();
        Rectangle rect = this.getBounds();
        Dimension dim = BoundsConvert.getSize((AuroraComponent)this.model);
        IFigure parentFigure = this.getParent();
        if (!(parentFigure instanceof ToolbarFigure)) {
            g.drawImage(bgImg, 0, 0, 3, 2, rect.x, rect.y, 3, 2);
            g.drawImage(bgImg, 0, 6, 1, 2, rect.x + 3, rect.y, dim.width - 6, 2);
            g.drawImage(bgImg, 3, 0, 3, 2, rect.x + dim.width - 3, rect.y, 3, 2);
            g.drawImage(bgImg, 0, 24, 3, 1, rect.x, rect.y + 2, 3, dim.height - 4);
            g.drawImage(bgImg, 3, 24, 3, 1, rect.x + dim.width - 3, rect.y + 2, 3, dim.height - 4);
            g.drawImage(bgImg, 0, 1096, 1, dim.height - 4, rect.x + 3, rect.y + 2, dim.width - 6, dim.height - 4);
            g.drawImage(bgImg, 0, 4, 3, 2, rect.x, rect.y + dim.height - 2, 3, 2);
            g.drawImage(bgImg, 0, 16, 1, 2, rect.x + 3, rect.y + dim.height - 2, dim.width - 3, 2);
            g.drawImage(bgImg, 3, 4, 3, 2, rect.x + dim.width - 3, rect.y + dim.height - 2, 3, 2);
        }
        if ("".equals(text = this.model.getText())) {
            text = MessageUtil.getButtonText((Button)this.model);
        }
        Dimension textExtents = FigureUtilities.getTextExtents((String)text, (Font)this.getFont());
        g.setForegroundColor(ColorConstants.BLACK);
        if (!this.hasIcon()) {
            if (!TextStyleUtil.isTextLayoutUseless((AuroraComponent)this.model, "text")) {
                this.paintStyledText(g, text, "text", rect.x + (dim.width - textExtents.width) / 2, rect.y + (dim.height - textExtents.height) / 2);
            } else {
                g.drawString(text, rect.x + (dim.width - textExtents.width) / 2, rect.y + (dim.height - textExtents.height) / 2);
            }
        } else {
            Rectangle r1 = this.getImgRect();
            Rectangle r2 = new Rectangle(rect.x + (dim.width - textExtents.width - 16) / 2, rect.y + (dim.height - r1.height) / 2, 16, 17);
            g.drawImage(this.getBgImage(), r1, r2);
            if (!TextStyleUtil.isTextLayoutUseless((AuroraComponent)this.model, "text")) {
                this.paintStyledText(g, text, "text", rect.x + 2 + (dim.width - textExtents.width) / 2 + 8, rect.y + (dim.height - textExtents.height) / 2);
            } else {
                g.drawString(text, rect.x + 2 + (dim.width - textExtents.width) / 2 + 8, rect.y + (dim.height - textExtents.height) / 2);
            }
        }
        g.popState();
    }

    private boolean hasIcon() {
        String iconByteData = this.model.getIconByteData();
        return !"".equals(iconByteData) || this.isStdButton((Button)this.model);
    }

    private boolean isStdButton(Button model) {
        return Arrays.asList(Button.std_types).indexOf(model.getButtonType()) > 0;
    }

    protected void paintStyledText(Graphics g, String text, String property_id, int x, int y) {
        g.pushState();
        this.disposer.disposeResource(property_id);
        TextLayout tl = new TextLayout(null);
        tl.setText(text);
        tl.setFont(this.getFont());
        Object obj = this.model.getPropertyValue(String.valueOf(property_id) + "_text_style");
        TextStyle ts = null;
        ts = obj instanceof StyledStringText ? TextStyleUtil.createTextStyle((StyledStringText)obj, Display.getDefault(), this.getFont()) : new TextStyle();
        tl.setStyle(ts, 0, text.length() - 1);
        g.drawTextLayout(tl, x, y);
        this.disposer.handleResource(property_id, (Resource)tl);
        g.popState();
    }

    private Rectangle getImgRect() {
        if (!"".equals(this.model.getIconByteData())) {
            return new Rectangle(0, 0, 16, 16);
        }
        String btype = this.model.getButtonType();
        int i = 0;
        while (i < buttonTypes.length) {
            if (buttonTypes[i].equals(btype)) {
                return new Rectangle(0, 17 * i, 16, 17);
            }
            ++i;
        }
        return null;
    }

    private Image getBgImage() {
        byte[] iconByteData;
        if (!"".equals(this.model.getIconByteData()) && (iconByteData = AuroraImagesUtils.toBytes((String)this.model.getIconByteData())) != null) {
            ImageData idd = AuroraImagesUtils.toImageData((byte[])iconByteData);
            ImageDescriptor id = ImageDescriptor.createFromImageData((ImageData)idd);
            Image image = id.createImage();
            return image;
        }
        return this.isStdButton((Button)this.model) ? stdimg : defaultimg;
    }

    public void setModel(ToolbarButton model) {
        this.model = model;
    }

    public void disposeResource() {
        this.disposer.disposeResource();
        this.disposer = null;
    }
}

