/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models.commands;

import aurora.ide.meta.extensions.ComponentFactory;
import aurora.ide.meta.gef.Util;
import aurora.ide.meta.gef.editors.EditorMode;
import aurora.ide.meta.gef.editors.models.commands.DropBMCommand;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.BOX;
import aurora.plugin.source.gen.screen.model.Container;
import aurora.plugin.source.gen.screen.model.Dataset;
import aurora.plugin.source.gen.screen.model.GridColumn;
import aurora.plugin.source.gen.screen.model.Label;
import aurora.plugin.source.gen.screen.model.ScreenBody;
import java.util.List;
import uncertain.composite.CompositeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindDropModelCommand
extends DropBMCommand {
    private Container container;
    private Object data;
    private EditorMode editorMode;

    public EditorMode getEditorMode() {
        return this.editorMode;
    }

    public void setEditorMode(EditorMode editorMode) {
        this.editorMode = editorMode;
    }

    public void execute() {
        List fields = (List)this.data;
        if (this.container instanceof BOX || this.container instanceof ScreenBody) {
            this.fillForm(fields);
        }
        if (this.container instanceof GridColumn) {
            this.fillGrid(fields);
        }
    }

    private boolean isQueryNameMap(CompositeMap f) {
        return "query-field".equals(f.getName());
    }

    private boolean isRefFieldMap(CompositeMap f) {
        return "ref-field".equals(f.getName());
    }

    private void fillGrid(List<CompositeMap> fields) {
        Dataset ds = Util.findDataset(this.container);
        String model = ds == null ? null : ds.getModel();
        for (CompositeMap f : fields) {
            if (this.isQueryNameMap(f)) continue;
            if ((model == null || "".equals(model.trim())) && ds != null) {
                ds.setModel(f.getString((Object)"model", ""));
            }
            String string = Util.getPrompt(f, "");
            GridColumn gc = new GridColumn();
            gc.setPrompt(string);
            String name = f.getString((Object)"name");
            name = name == null ? "" : name;
            gc.setName(name);
            if (this.getEditorMode().isForCreate() || this.getEditorMode().isForUpdate()) {
                if (this.isRefFieldMap(f)) continue;
                String type = Util.getType(f);
                gc.setEditor(type);
            }
            this.container.addChild((AuroraComponent)gc);
        }
    }

    private void fillForm(List<CompositeMap> fields) {
        Dataset ds = Util.findDataset(this.container);
        String model = ds == null ? null : ds.getModel();
        for (CompositeMap field : fields) {
            String name;
            if (this.isQueryNameMap(field) && (ds == null || "resultdataset".equalsIgnoreCase(ds.getComponentType()))) continue;
            if ((model == null || "".equals(model.trim())) && ds != null) {
                ds.setModel(field.getString((Object)"model", ""));
            }
            name = (name = (String)field.get((Object)"field")) == null ? field.getString((Object)"name") : name;
            name = name == null ? "" : name;
            String type = this.getEditorMode().isForDisplay() ? Label.Label : Util.getType(field);
            AuroraComponent input = ComponentFactory.createComponent(type);
            input.setComponentType(type);
            input.setName(name);
            input.setPrompt(Util.getPrompt(field, ""));
            this.container.addChild(input);
        }
    }

    public boolean canUndo() {
        return false;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        this.container = container;
    }
}

