/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.parts;

import aurora.ide.meta.MetaPlugin;
import aurora.ide.meta.gef.editors.figures.InputField;
import aurora.ide.meta.gef.editors.figures.PromptCellEditorLocator;
import aurora.ide.meta.gef.editors.figures.SimpleDataCellEditorLocator;
import aurora.ide.meta.gef.editors.layout.InputFieldLayout;
import aurora.ide.meta.gef.editors.models.commands.ChangeTextStyleCommand;
import aurora.ide.meta.gef.editors.parts.ComponentPart;
import aurora.ide.meta.gef.editors.policies.ComponentDirectEditPolicy;
import aurora.ide.meta.gef.editors.policies.NodeDirectEditManager;
import aurora.ide.meta.gef.editors.wizard.dialog.TextEditDialog;
import aurora.ide.prototype.consultant.demonstrate.Demonstrating;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.Input;
import aurora.plugin.source.gen.screen.model.StyledStringText;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.TextCellEditor;

public class InputPart
extends ComponentPart {
    private String type;
    protected DirectEditManager manager;

    protected IFigure createFigure() {
        InputField inputField = new InputField();
        Input model = this.getModel();
        inputField.setModel(model);
        return inputField;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        String stringPropertyValue = this.getModel().getStringPropertyValue("fsd_meaning");
        if ("".equals(stringPropertyValue) || stringPropertyValue == null) {
            this.getFigure().setToolTip(null);
        } else {
            this.getFigure().setToolTip((IFigure)new Label(stringPropertyValue));
        }
    }

    public Input getModel() {
        return (Input)super.getModel();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ComponentDirectEditPolicy());
    }

    public int getResizeDirection() {
        return 24;
    }

    public Rectangle layout() {
        InputFieldLayout layout = new InputFieldLayout();
        return layout.layout(this);
    }

    public Command getCommand(Request request) {
        return super.getCommand(request);
    }

    public EditPolicy getEditPolicy(Object key) {
        return super.getEditPolicy(key);
    }

    public void performRequest(Request req) {
        Point location;
        if ("open".equals(req.getType()) && req instanceof LocationRequest) {
            if (MetaPlugin.isDemonstrate) {
                new Demonstrating(this).demonstrating(this.getViewer().getControl().getShell());
                return;
            }
            location = ((LocationRequest)req).getLocation();
            Rectangle dataBounds = this.getPromptBounds();
            if (!dataBounds.contains(location)) {
                this.performEditStyledStringText("prompt");
            } else {
                this.performEditStyledStringText("input_simple_data");
            }
        }
        if (req.getType().equals("direct edit") && req instanceof DirectEditRequest) {
            location = ((DirectEditRequest)req).getLocation();
            InputField figure = (InputField)this.getFigure();
            Rectangle dataBounds = this.getPromptBounds();
            if (!dataBounds.contains(location)) {
                this.performPromptDirectEditRequest(figure);
            } else {
                this.performSimpleDataDirectEditRequest(figure);
            }
        } else {
            super.performRequest(req);
        }
    }

    protected void performEditStyledStringText(String propertyID) {
        Object obj;
        TextEditDialog ted = new TextEditDialog(this.getViewer().getControl().getShell());
        StyledStringText sst = new StyledStringText();
        if ("prompt".equals(propertyID)) {
            sst.setAlignment(131072);
        }
        if ((obj = this.getModel().getPropertyValue(String.valueOf(propertyID) + "_text_style")) instanceof StyledStringText) {
            sst = (StyledStringText)obj;
        }
        sst.setText(this.getModel().getStringPropertyValue(propertyID));
        ted.setStyledStringText(sst);
        if (ted.open() == 0) {
            sst = ted.getStyledStringText();
            ChangeTextStyleCommand command = new ChangeTextStyleCommand((AuroraComponent)this.getModel(), propertyID, sst.getText(), sst);
            this.getViewer().getEditDomain().getCommandStack().execute((Command)command);
        }
    }

    protected Rectangle getPromptBounds() {
        InputField figure = (InputField)this.getFigure();
        Rectangle bounds = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)bounds);
        int labelWidth = figure.getLabelWidth();
        Rectangle dataBounds = bounds.getCopy().setX(bounds.x + labelWidth);
        return dataBounds;
    }

    protected void performSimpleDataDirectEditRequest(InputField figure) {
        if (MetaPlugin.isDemonstrate && "comboBox".equals(this.getModel().getComponentType())) {
            new Demonstrating(this).demonstrating(this.getViewer().getControl().getShell());
        } else {
            NodeDirectEditManager manager = new NodeDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, new SimpleDataCellEditorLocator(figure), "input_simple_data");
            manager.show();
        }
    }

    protected void performPromptDirectEditRequest(InputField figure) {
        NodeDirectEditManager manager = new NodeDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, new PromptCellEditorLocator(figure), "prompt");
        manager.show();
    }
}

