/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.property;

import aurora.ide.meta.gef.editors.property.EditWizard;
import aurora.ide.meta.gef.util.ImageUtil;
import aurora.plugin.source.gen.screen.model.IDialogEditableObject;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogCellEditor
extends CellEditor
implements SelectionListener,
MouseListener {
    private Button button;
    private CLabel label;
    private IDialogEditableObject value;
    private Class<? extends EditWizard> clazz;
    Shell shell;

    public DialogCellEditor(Composite parent, Class<? extends EditWizard> clazz) {
        super(parent, 0);
        this.clazz = clazz;
    }

    protected DialogCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected DialogCellEditor(Composite parent) {
        super(parent);
    }

    protected Control createControl(Composite parent) {
        this.shell = parent.getShell();
        Composite com = new Composite(parent, 0);
        com.setBackground(parent.getBackground());
        com.setLayout((Layout)new SimpleLayout());
        this.label = new CLabel(com, 0);
        this.label.setBackground(parent.getBackground());
        this.label.addMouseListener((MouseListener)this);
        this.button = new Button(com, 0x800000);
        this.button.setText("...");
        this.button.addSelectionListener((SelectionListener)this);
        return com;
    }

    protected CLabel getLabel() {
        return this.label;
    }

    protected Button getButton() {
        return this.button;
    }

    protected Object doGetValue() {
        return this.value;
    }

    protected void doSetFocus() {
    }

    protected void doSetValue(Object value) {
        if (value == null) {
            return;
        }
        this.value = (IDialogEditableObject)value;
        this.label.setText(this.value.getDescripition());
        this.label.setImage(ImageUtil.getImage((IDialogEditableObject)value));
    }

    public void activate(ColumnViewerEditorActivationEvent activationEvent) {
        if (activationEvent.eventType != 5) {
            super.activate(activationEvent);
        }
    }

    protected void showDialog() {
        try {
            EditWizard wizard = this.clazz.newInstance();
            IDialogEditableObject objClone = this.value == null ? null : this.value.clone();
            wizard.setDialogEdiableObject(objClone);
            WizardDialog wd = new WizardDialog(this.shell, (IWizard)wizard);
            if (wd.open() == 0) {
                this.value = objClone;
                if (this.value != null && !this.label.isDisposed()) {
                    this.label.setText(this.value.getDescripition());
                    this.label.setImage(ImageUtil.getImage(this.value));
                }
                this.fireApplyEditorValue();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        this.showDialog();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (this.getButton().getEnabled()) {
            this.showDialog();
        }
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    private class SimpleLayout
    extends Layout {
        private int width = 17;

        private SimpleLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            return new Point(800, 20);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Point size = composite.getSize();
            DialogCellEditor.this.label.setBounds(0, 0, size.x - this.width, size.y);
            DialogCellEditor.this.button.setBounds(size.x - this.width, 0, this.width, size.y);
        }
    }
}

