/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.template.handle;

import aurora.ide.meta.gef.designer.BMCompositeMap;
import aurora.ide.meta.gef.editors.template.BMReference;
import aurora.ide.meta.gef.editors.template.handle.TemplateConfig;
import aurora.ide.meta.gef.editors.template.handle.TemplateHandle;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.Container;
import aurora.plugin.source.gen.screen.model.Grid;
import aurora.plugin.source.gen.screen.model.GridColumn;
import aurora.plugin.source.gen.screen.model.Label;
import aurora.plugin.source.gen.screen.model.Renderer;
import aurora.plugin.source.gen.screen.model.ScreenBody;
import java.util.List;
import java.util.Map;
import uncertain.composite.CompositeMap;

public class DisplayTemplateHandle
extends TemplateHandle {
    private Map<String, List<String>> refRelat;

    public DisplayTemplateHandle(TemplateConfig config) {
        super(config);
    }

    public void fill(ScreenBody viewDiagram) {
        this.setColNum(viewDiagram, 1);
        this.viewDiagram = viewDiagram;
        for (BMReference bm : this.config.getModelRelated().keySet()) {
            for (Container ac : this.config.getModelRelated().get(bm)) {
                BMCompositeMap bmc = new BMCompositeMap(bm.getModel());
                this.refRelat = this.getReferenceRelation(bmc);
                this.fillContainer(ac, bm, bmc);
            }
        }
    }

    protected void fillBox(Container ac, BMCompositeMap bmc) {
        ac.getChildren().clear();
        for (CompositeMap map : this.getFieldsWithoutPK(bmc)) {
            String renderer = null;
            if (this.isDateType(map)) {
                renderer = "Aurora.formatDate";
            }
            String filedName = map.getString((Object)"name");
            ac.addChild((AuroraComponent)this.createLabel(map.getString((Object)"prompt"), filedName, renderer));
        }
    }

    private Label createLabel(String prompt, String name, String renderer) {
        Label label = new Label();
        label.setName(name);
        label.setPrompt(prompt);
        if (renderer != null) {
            label.setRenderer(renderer);
        }
        return label;
    }

    protected void fillGrid(Grid grid, BMCompositeMap bmc) {
        int i = 0;
        while (i < grid.getChildren().size()) {
            if (grid.getChildren().get(i) instanceof GridColumn) {
                grid.getChildren().remove(i);
                --i;
            }
            ++i;
        }
        for (CompositeMap map : this.getFieldsWithoutPK(bmc)) {
            String filedName = map.getString((Object)"name");
            GridColumn gc = this.createGridColumn(map);
            grid.addCol(gc);
        }
        grid.setNavbarType("complex");
        grid.setSelectionMode("multiple");
        this.config.get("grid").add(grid);
    }

    private GridColumn createGridColumn(CompositeMap map, CompositeMap ref) {
        GridColumn gc = new GridColumn();
        gc.setName(ref.getString((Object)"name"));
        gc.setPrompt(map.getString((Object)"prompt"));
        if (this.isDateType(map)) {
            Renderer r = new Renderer();
            r.setFunctionName("Aurora.formatDate");
            r.setRendererType("INNER_FUNCTION");
            gc.setRenderer(r);
        }
        return gc;
    }
}

