/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.wizard;

import aurora.ide.builder.ResourceUtil;
import aurora.ide.helpers.DialogUtil;
import aurora.ide.meta.exception.ResourceNotFoundException;
import aurora.ide.meta.gef.editors.property.ResourceSelector;
import aurora.ide.meta.gef.editors.wizard.CreateMetaWizard;
import aurora.ide.meta.project.AuroraMetaProject;
import aurora.ide.search.core.Util;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddModelWizardPage
extends WizardPage {
    private Composite composite;
    private TableViewer viewer;
    private Table table;
    private CreateMetaWizard wizard;

    private AddModelWizardPage() {
        super("aurora.wizard.model.Page");
        this.setTitle("\u9009\u62e9BM\u6587\u4ef6");
        this.setDescription("\u9009\u62e9\u5c06\u5728\u6b21\u539f\u578b\u8bbe\u8ba1\u6587\u4ef6\u4e2d\u9700\u8981\u7528\u5230\u7684BM\u6587\u4ef6\u3002");
        this.setPageComplete(true);
    }

    public AddModelWizardPage(CreateMetaWizard wizard) {
        this();
        this.wizard = wizard;
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout());
        this.setControl((Control)this.composite);
        this.createViewer();
    }

    private void createViewer() {
        Composite container = this.composite;
        this.viewer = new TableViewer(container, 68386);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        container.setLayout((Layout)gl);
        this.table = this.viewer.getTable();
        GridData gd = new GridData(1808);
        this.table.setLayoutData((Object)gd);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn tableColumn = new TableColumn(this.table, 0);
        tableColumn.setWidth(300);
        tableColumn.setText("BM-Path");
        gd = new GridData(1040);
        Composite c = new Composite(container, 0);
        gl = new GridLayout();
        c.setLayoutData((Object)gd);
        c.setLayout((Layout)gl);
        gl.numColumns = 1;
        Button addFile = new Button(c, 0);
        addFile.setText("\u589e\u52a0");
        addFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddModelWizardPage.this.addFile();
            }
        });
        Button delete = new Button(c, 0);
        delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items;
                TableItem[] tableItemArray = items = AddModelWizardPage.this.table.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem i = tableItemArray[n2];
                    boolean checked = i.getChecked();
                    if (checked) {
                        AddModelWizardPage.this.viewer.remove(i.getData());
                    }
                    ++n2;
                }
            }
        });
        delete.setText("\u5220\u9664");
    }

    public IFile openResourceSelector(Shell shell, String[] exts, IContainer root) {
        ResourceSelector fss = new ResourceSelector(shell);
        fss.setExtFilter(exts);
        fss.setInput(root);
        IResource obj = fss.getSelection();
        if (!(obj instanceof IFile)) {
            return null;
        }
        return (IFile)obj;
    }

    protected void addFile() {
        String[] as = new String[]{"bm"};
        IContainer bmHome = this.getBMHome();
        if (bmHome == null || !bmHome.exists()) {
            DialogUtil.showWarningMessageBox((String)"\u627e\u4e0d\u5230BM\u4e3b\u76ee\u5f55\uff0c\u9700\u8981\u914d\u7f6e\u5173\u8054\u5de5\u7a0b\u3002");
            return;
        }
        IFile file = this.openResourceSelector(this.getShell(), as, bmHome);
        if (file == null || !file.exists()) {
            return;
        }
        String bmpkg = Util.toBMPKG((IFile)file);
        this.viewer.add((Object)bmpkg);
    }

    public List<String> getModels() {
        TableItem[] items;
        ArrayList<String> models = new ArrayList<String>();
        TableItem[] tableItemArray = items = this.table.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem o = tableItemArray[n2];
            models.add(o.getData().toString());
            ++n2;
        }
        return models;
    }

    private IContainer getBMHome() {
        IProject metaProject = this.wizard.getMetaProject();
        if (metaProject == null) {
            return null;
        }
        AuroraMetaProject metaPro = new AuroraMetaProject(metaProject);
        try {
            IProject auroraProj = metaPro.getAuroraProject();
            IFolder bmHomeFolder = ResourceUtil.getBMHomeFolder((IProject)auroraProj);
            return bmHomeFolder;
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof String[]) {
                return (String[])parent;
            }
            return null;
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            switch (index) {
                case 0: {
                    return obj.toString();
                }
            }
            return "";
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

