/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.wizard.dialog;

import aurora.ide.meta.gef.control.ConsultantDemonstratingComposite;
import aurora.ide.meta.gef.editors.EditorMode;
import aurora.ide.meta.gef.editors.parts.ExtSysLovAuroraPartFactory;
import aurora.ide.meta.gef.editors.wizard.dialog.LovDialogInput;
import aurora.ide.prototype.consultant.demonstrate.LOVDemonstrating;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.Button;
import aurora.plugin.source.gen.screen.model.Combox;
import aurora.plugin.source.gen.screen.model.DatePicker;
import aurora.plugin.source.gen.screen.model.DemonstrateBind;
import aurora.plugin.source.gen.screen.model.Form;
import aurora.plugin.source.gen.screen.model.Grid;
import aurora.plugin.source.gen.screen.model.GridColumn;
import aurora.plugin.source.gen.screen.model.HBox;
import aurora.plugin.source.gen.screen.model.LOV;
import aurora.plugin.source.gen.screen.model.NumberField;
import aurora.plugin.source.gen.screen.model.ScreenBody;
import aurora.plugin.source.gen.screen.model.TextField;
import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DemonstratingDialog
extends Dialog {
    private LovDialogInput input;
    private LOVDemonstrating demon;
    private File project;

    public DemonstratingDialog(Shell parentShell, LOVDemonstrating demon) {
        super(parentShell);
        this.demon = demon;
    }

    protected Point getInitialSize() {
        return new Point(500, 530);
    }

    protected org.eclipse.swt.widgets.Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        return super.createButton(parent, id, label, defaultButton);
    }

    protected Control createButtonBar(Composite parent) {
        return super.createButtonBar(parent);
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected Control createContents(Composite parent) {
        return super.createContents(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout());
        ConsultantDemonstratingComposite vsEditor = new ConsultantDemonstratingComposite(this);
        ScreenBody viewDiagram = new ScreenBody();
        viewDiagram.addChild((AuroraComponent)this.createForm());
        viewDiagram.addChild((AuroraComponent)this.createButtons());
        viewDiagram.addChild((AuroraComponent)this.createGrid());
        vsEditor.setInput(viewDiagram);
        vsEditor.createPartControl(container);
        vsEditor.getControl().setLayoutData((Object)new GridData(1808));
        return container;
    }

    protected HBox createButtons() {
        HBox hb = new HBox();
        Button child = new Button();
        child.setText("\u67e5\u8be2");
        hb.addChild((AuroraComponent)child);
        child = new Button();
        child.setText("\u786e\u5b9a");
        hb.addChild((AuroraComponent)child);
        return hb;
    }

    public Form createForm() {
        List<DemonstrateBind> bindModels;
        Form form = new Form();
        form.setSize(450, 85);
        form.setCol(2);
        if (this.input != null && (bindModels = this.input.getBindModels()) != null) {
            for (DemonstrateBind db : bindModels) {
                AuroraComponent createInput;
                String editor = db.getForQueryEditor();
                if ("".equals(editor) || (createInput = this.createInput(db)) == null) continue;
                form.addChild(createInput);
            }
        }
        return form;
    }

    private AuroraComponent createInput(DemonstrateBind db) {
        TextField ac = null;
        if ("textField".equals(db.getForQueryEditor())) {
            ac = new TextField();
        }
        if ("numberField".equals(db.getForQueryEditor())) {
            ac = new NumberField();
        }
        if ("comboBox".equals(db.getForQueryEditor())) {
            ac = new Combox();
        }
        if ("lov".equals(db.getForQueryEditor())) {
            ac = new LOV();
        }
        if ("datePicker".equals(db.getForQueryEditor())) {
            ac = new DatePicker();
        }
        if (ac != null) {
            ac.setPrompt(db.getColumnPrompt());
        }
        return ac;
    }

    private AuroraComponent createTextField(int i) {
        TextField textField = new TextField();
        return this.cf((AuroraComponent)textField, i);
    }

    private AuroraComponent cf(AuroraComponent ac, int i) {
        if (this.input != null) {
            if (i >= this.input.getCol()) {
                return null;
            }
            String name = this.input.get(i, 0);
            String value = this.input.get(i, 1);
            ac.setPropertyValue("prompt", (Object)name);
            ac.setPropertyValue("input_simple_data", (Object)value);
        }
        return ac;
    }

    private AuroraComponent createCombox(int i) {
        Combox combox = new Combox();
        return this.cf((AuroraComponent)combox, i);
    }

    public Grid createGrid() {
        Grid grid = new Grid();
        grid.setSize(450, 300);
        if (this.input == null || this.input.getCol() == 0) {
            grid.addCol(new GridColumn());
            grid.addCol(new GridColumn());
            grid.addCol(new GridColumn());
        } else {
            List<DemonstrateBind> bindModels = this.input.getBindModels();
            if (bindModels != null) {
                int i = 0;
                while (i < bindModels.size()) {
                    GridColumn cc;
                    DemonstrateBind db = bindModels.get(i);
                    if (db.isForDisplay() && (cc = this.createGridColumn(i)) != null) {
                        cc.setPrompt(db.getColumnPrompt());
                        grid.addChild((AuroraComponent)cc);
                    }
                    ++i;
                }
            }
        }
        grid.setPropertyValue("navBarType", (Object)"complex");
        return grid;
    }

    public GridColumn createGridColumn(int i) {
        GridColumn gridColumn = new GridColumn();
        if (this.input != null && this.input.getCol() > 0) {
            int row = this.input.getRow();
            if (i >= this.input.getCol()) {
                return null;
            }
            int max = row < 9 ? row : 9;
            int j = 0;
            while (j < max) {
                String s = this.input.get(i, j);
                if (s == null) break;
                gridColumn.setPropertyValue("grid_column_simple_data_" + (j + 1), (Object)s);
                ++j;
            }
        }
        return gridColumn;
    }

    public void setInput(Object input) {
        this.input = (LovDialogInput)input;
    }

    public void applyValue(String value) {
        this.demon.applyValue(value);
        this.close();
    }

    public EditPartFactory getPartFactory(EditorMode editorMode) {
        return new ExtSysLovAuroraPartFactory(editorMode);
    }

    public IPath getActiveFilePath() {
        return new Path("");
    }

    public File getProject() {
        return this.project;
    }

    public void setProject(File project) {
        this.project = project;
    }

    public void applyValue(String value, int idx) {
        if (this.input == null) {
            return;
        }
        List<DemonstrateBind> bindModels = this.input.getBindModels();
        if (bindModels != null) {
            int i = 0;
            while (i < bindModels.size()) {
                DemonstrateBind db = bindModels.get(i);
                AuroraComponent ac = db.getBindModel();
                if (ac != null) {
                    this.demon.applyValue(ac, this.input.get(i, idx - 1));
                }
                ++i;
            }
        }
        this.applyValue(value);
    }
}

