/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.wizard.dialog;

import aurora.ide.libs.AuroraImagesUtils;
import aurora.plugin.source.gen.screen.model.StyledStringText;
import java.io.IOException;
import java.io.InputStream;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class TextEditDialog
extends Dialog {
    private Display display;
    private Shell shell;
    private StyledStringText styledStringText;
    private int alignmentStyle;
    static final ResourceBundle resources = ResourceBundle.getBundle("aurora.ide.meta.gef.editors.wizard.dialog.examples_texteditor");
    private CoolBar coolBar;
    private StyledText styledText;
    private ToolItem boldControl;
    private ToolItem italicControl;
    private ToolItem leftAlignmentItem;
    private ToolItem centerAlignmentItem;
    private ToolItem rightAlignmentItem;
    private MenuItem underlineSingleItem;
    private MenuItem underlineDoubleItem;
    private MenuItem underlineErrorItem;
    private MenuItem underlineSquiggleItem;
    private MenuItem borderSolidItem;
    private MenuItem borderDashItem;
    private MenuItem borderDotItem;
    private boolean insert = true;
    private StyleRange[] selectedRanges;
    private int newCharCount;
    private int start;
    private int styleState;
    private String link;
    private static Image iBold;
    private static Image iItalic;
    private static Image iUnderline;
    private static Image iStrikeout;
    private static Image iLeftAlignment;
    private static Image iRightAlignment;
    private static Image iCenterAlignment;
    private static Image iJustifyAlignment;
    private static Image iCopy;
    private static Image iCut;
    private static Image iLink;
    private static Image iPaste;
    private static Image iTextForeground;
    private static Image iTextBackground;
    private static Image iBaselineUp;
    private static Image iBaselineDown;
    private static Image iBulletList;
    private static Image iNumberedList;
    private static Image iBlockSelection;
    private static Image iBorderStyle;
    private Font font;
    private Font textFont;
    private Color textForeground;
    private Color textBackground;
    private Color strikeoutColor;
    private Color underlineColor;
    private Color borderColor;
    private static final int BOLD = 1;
    private static final int ITALIC = 2;
    private static final int FONT_STYLE = 3;
    private static final int STRIKEOUT = 8;
    private static final int FOREGROUND = 16;
    private static final int BACKGROUND = 32;
    private static final int FONT = 64;
    private static final int BASELINE_UP = 128;
    private static final int BASELINE_DOWN = 256;
    private static final int UNDERLINE_SINGLE = 512;
    private static final int UNDERLINE_DOUBLE = 1024;
    private static final int UNDERLINE_ERROR = 2048;
    private static final int UNDERLINE_SQUIGGLE = 4096;
    private static final int UNDERLINE_LINK = 8192;
    private static final int UNDERLINE = 15872;
    private static final int BORDER_SOLID = 0x800000;
    private static final int BORDER_DASH = 0x1000000;
    private static final int BORDER_DOT = 0x2000000;
    private static final int BORDER = 0x3800000;

    public TextEditDialog(Shell shell) {
        super(shell);
        this.display = shell.getDisplay();
        this.shell = shell;
    }

    static String getResourceString(String key) {
        try {
            return resources.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
        catch (NullPointerException e) {
            return "!" + key + "!";
        }
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        return super.createButton(parent, id, label, defaultButton);
    }

    protected Control createButtonBar(Composite parent) {
        return super.createButtonBar(parent);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
    }

    protected void initializeBounds() {
        super.initializeBounds();
        this.getShell().setSize(600, 250);
    }

    protected Control createContents(Composite parent) {
        return super.createContents(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.initResources();
        this.createToolbar(dialogArea);
        this.coolBar.setLayoutData((Object)new GridData(768));
        this.styledText = new StyledText(dialogArea, 2816);
        this.styledText.setLayoutData((Object)new GridData(1808));
        this.styledText.setFocus();
        this.installListeners();
        this.initStyledText();
        this.updateToolBar();
        return dialogArea;
    }

    private void initStyledText() {
        int alignment;
        if (this.styledStringText == null) {
            return;
        }
        String text = this.styledStringText.getText();
        if (text == null || "".equals(text)) {
            return;
        }
        this.styledText.setText(text);
        String fontName = this.styledStringText.getFontName();
        if (fontName != null && !"".equals(fontName) && this.styledStringText.getFontSize() > 0) {
            this.textFont = new Font((Device)Display.getDefault(), fontName, this.styledStringText.getFontSize(), 0);
            this.setStyle(64);
        }
        if (this.styledStringText.isBold()) {
            this.setStyle(1);
        }
        if (this.styledStringText.isItalic()) {
            this.setStyle(2);
        }
        if (this.styledStringText.isStrikeout()) {
            if (this.styledStringText.getStrikeoutColor() != null && !"-1,-1,-1".equals(this.styledStringText.getStrikeoutColor())) {
                this.strikeoutColor = new Color((Device)Display.getDefault(), AuroraImagesUtils.toRGB((String)this.styledStringText.getStrikeoutColor()));
            }
            this.setStyle(8);
        }
        if (this.styledStringText.isUnderline()) {
            if (this.styledStringText.getUnderlineStyle() != 4) {
                this.underlineSingleItem.setSelection((this.styleState & 0x200) != 0);
                this.underlineDoubleItem.setSelection((this.styleState & 0x400) != 0);
                this.underlineErrorItem.setSelection((this.styleState & 0x800) != 0);
                this.underlineSquiggleItem.setSelection((this.styleState & 0x1000) != 0);
                if (this.styledStringText.getUnderlineColor() != null && !"-1,-1,-1".equals(this.styledStringText.getUnderlineColor())) {
                    this.underlineColor = new Color((Device)Display.getDefault(), AuroraImagesUtils.toRGB((String)this.styledStringText.getUnderlineColor()));
                }
            }
            switch (this.styledStringText.getUnderlineStyle()) {
                case 0: {
                    this.setStyle(512);
                    break;
                }
                case 1: {
                    this.setStyle(1024);
                    break;
                }
                case 3: {
                    this.setStyle(4096);
                    break;
                }
                case 2: {
                    this.setStyle(2048);
                    break;
                }
                case 4: {
                    this.setLink();
                }
            }
        }
        if (this.styledStringText.getTextBackground() != null && !"-1,-1,-1".equals(this.styledStringText.getTextBackground())) {
            this.textBackground = new Color((Device)Display.getDefault(), AuroraImagesUtils.toRGB((String)this.styledStringText.getTextBackground()));
            this.setStyle(32);
        }
        if (this.styledStringText.getTextForeground() != null && !"-1,-1,-1".equals(this.styledStringText.getTextForeground())) {
            this.textForeground = new Color((Device)Display.getDefault(), AuroraImagesUtils.toRGB((String)this.styledStringText.getTextForeground()));
            this.setStyle(16);
        }
        this.updateAlignmentStyle((alignment = this.styledStringText.getAlignment()) == -1 ? 16384 : alignment);
    }

    private void createToolbar(Composite parent) {
        final Composite shell = parent;
        this.coolBar = new CoolBar(parent, 0x800000);
        ToolBar styleToolBar = new ToolBar((Composite)this.coolBar, 0x800000);
        this.boldControl = new ToolItem(styleToolBar, 32);
        this.boldControl.setImage(iBold);
        this.boldControl.setToolTipText(TextEditDialog.getResourceString("Bold"));
        this.boldControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditDialog.this.setStyle(1);
            }
        });
        this.italicControl = new ToolItem(styleToolBar, 32);
        this.italicControl.setImage(iItalic);
        this.italicControl.setToolTipText(TextEditDialog.getResourceString("Italic"));
        this.italicControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditDialog.this.setStyle(2);
            }
        });
        final Menu underlineMenu = new Menu((Decorations)shell.getShell(), 8);
        this.underlineSingleItem = new MenuItem(underlineMenu, 16);
        this.underlineSingleItem.setText(TextEditDialog.getResourceString("Single_menuitem"));
        this.underlineSingleItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TextEditDialog.this.underlineSingleItem.getSelection()) {
                    TextEditDialog.this.setStyle(512);
                }
            }
        });
        this.underlineSingleItem.setSelection(true);
        this.underlineDoubleItem = new MenuItem(underlineMenu, 16);
        this.underlineDoubleItem.setText(TextEditDialog.getResourceString("Double_menuitem"));
        this.underlineDoubleItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TextEditDialog.this.underlineDoubleItem.getSelection()) {
                    TextEditDialog.this.setStyle(1024);
                }
            }
        });
        this.underlineSquiggleItem = new MenuItem(underlineMenu, 16);
        this.underlineSquiggleItem.setText(TextEditDialog.getResourceString("Squiggle_menuitem"));
        this.underlineSquiggleItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TextEditDialog.this.underlineSquiggleItem.getSelection()) {
                    TextEditDialog.this.setStyle(4096);
                }
            }
        });
        this.underlineErrorItem = new MenuItem(underlineMenu, 16);
        this.underlineErrorItem.setText(TextEditDialog.getResourceString("Error_menuitem"));
        this.underlineErrorItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TextEditDialog.this.underlineErrorItem.getSelection()) {
                    TextEditDialog.this.setStyle(2048);
                }
            }
        });
        MenuItem underlineColorItem = new MenuItem(underlineMenu, 8);
        underlineColorItem.setText(TextEditDialog.getResourceString("Color_menuitem"));
        underlineColorItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog dialog = new ColorDialog(shell.getShell());
                RGB rgb = TextEditDialog.this.underlineColor != null ? TextEditDialog.this.underlineColor.getRGB() : null;
                dialog.setRGB(rgb);
                RGB newRgb = dialog.open();
                if (newRgb != null) {
                    if (!newRgb.equals((Object)rgb)) {
                        TextEditDialog.this.disposeResource((Resource)TextEditDialog.this.underlineColor);
                        TextEditDialog.this.underlineColor = new Color((Device)Display.getDefault(), newRgb);
                    }
                    if (TextEditDialog.this.underlineSingleItem.getSelection()) {
                        TextEditDialog.this.setStyle(512);
                    } else if (TextEditDialog.this.underlineDoubleItem.getSelection()) {
                        TextEditDialog.this.setStyle(1024);
                    } else if (TextEditDialog.this.underlineErrorItem.getSelection()) {
                        TextEditDialog.this.setStyle(2048);
                    } else if (TextEditDialog.this.underlineSquiggleItem.getSelection()) {
                        TextEditDialog.this.setStyle(4096);
                    }
                }
            }
        });
        final ToolItem underlineControl = new ToolItem(styleToolBar, 4);
        underlineControl.setImage(iUnderline);
        underlineControl.setToolTipText(TextEditDialog.getResourceString("Underline"));
        underlineControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 4) {
                    Rectangle rect = underlineControl.getBounds();
                    Point pt = new Point(rect.x, rect.y + rect.height);
                    underlineMenu.setLocation(TextEditDialog.this.display.map((Control)underlineControl.getParent(), null, pt));
                    underlineMenu.setVisible(true);
                } else if (TextEditDialog.this.underlineSingleItem.getSelection()) {
                    TextEditDialog.this.setStyle(512);
                } else if (TextEditDialog.this.underlineDoubleItem.getSelection()) {
                    TextEditDialog.this.setStyle(1024);
                } else if (TextEditDialog.this.underlineErrorItem.getSelection()) {
                    TextEditDialog.this.setStyle(2048);
                } else if (TextEditDialog.this.underlineSquiggleItem.getSelection()) {
                    TextEditDialog.this.setStyle(4096);
                }
            }
        });
        ToolItem strikeoutControl = new ToolItem(styleToolBar, 4);
        strikeoutControl.setImage(iStrikeout);
        strikeoutControl.setToolTipText(TextEditDialog.getResourceString("Strikeout"));
        strikeoutControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 4) {
                    ColorDialog dialog = new ColorDialog(shell.getShell());
                    RGB rgb = TextEditDialog.this.strikeoutColor != null ? TextEditDialog.this.strikeoutColor.getRGB() : null;
                    dialog.setRGB(rgb);
                    RGB newRgb = dialog.open();
                    if (newRgb == null) {
                        return;
                    }
                    if (!newRgb.equals((Object)rgb)) {
                        TextEditDialog.this.disposeResource((Resource)TextEditDialog.this.strikeoutColor);
                        TextEditDialog.this.strikeoutColor = new Color((Device)Display.getDefault(), newRgb);
                    }
                }
                TextEditDialog.this.setStyle(8);
            }
        });
        ToolItem foregroundItem = new ToolItem(styleToolBar, 4);
        foregroundItem.setImage(iTextForeground);
        foregroundItem.setToolTipText(TextEditDialog.getResourceString("TextForeground"));
        foregroundItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 4 || TextEditDialog.this.textForeground == null) {
                    ColorDialog dialog = new ColorDialog(shell.getShell());
                    RGB rgb = TextEditDialog.this.textForeground != null ? TextEditDialog.this.textForeground.getRGB() : null;
                    dialog.setRGB(rgb);
                    RGB newRgb = dialog.open();
                    if (newRgb == null) {
                        return;
                    }
                    if (!newRgb.equals((Object)rgb)) {
                        TextEditDialog.this.disposeResource((Resource)TextEditDialog.this.textForeground);
                        TextEditDialog.this.textForeground = new Color((Device)Display.getDefault(), newRgb);
                    }
                }
                TextEditDialog.this.setStyle(16);
            }
        });
        ToolItem backgroundItem = new ToolItem(styleToolBar, 4);
        backgroundItem.setImage(iTextBackground);
        backgroundItem.setToolTipText(TextEditDialog.getResourceString("TextBackground"));
        backgroundItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 4 || TextEditDialog.this.textBackground == null) {
                    ColorDialog dialog = new ColorDialog(shell.getShell());
                    RGB rgb = TextEditDialog.this.textBackground != null ? TextEditDialog.this.textBackground.getRGB() : null;
                    dialog.setRGB(rgb);
                    RGB newRgb = dialog.open();
                    if (newRgb == null) {
                        return;
                    }
                    if (!newRgb.equals((Object)rgb)) {
                        TextEditDialog.this.disposeResource((Resource)TextEditDialog.this.textBackground);
                        TextEditDialog.this.textBackground = new Color((Device)Display.getDefault(), newRgb);
                    }
                }
                TextEditDialog.this.setStyle(32);
            }
        });
        ToolItem linkItem = new ToolItem(styleToolBar, 8);
        linkItem.setImage(iLink);
        linkItem.setToolTipText(TextEditDialog.getResourceString("Link"));
        linkItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditDialog.this.setLink();
            }
        });
        CoolItem coolItem = new CoolItem(this.coolBar, 0);
        coolItem.setControl((Control)styleToolBar);
        ToolBar alignmentToolBar = new ToolBar((Composite)this.coolBar, 0x800000);
        this.leftAlignmentItem = new ToolItem(alignmentToolBar, 16);
        this.leftAlignmentItem.setImage(iLeftAlignment);
        this.leftAlignmentItem.setToolTipText(TextEditDialog.getResourceString("AlignLeft"));
        this.leftAlignmentItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditDialog.this.updateAlignmentStyle(16384);
            }
        });
        this.centerAlignmentItem = new ToolItem(alignmentToolBar, 16);
        this.centerAlignmentItem.setImage(iCenterAlignment);
        this.centerAlignmentItem.setToolTipText(TextEditDialog.getResourceString("Center_menuitem"));
        this.centerAlignmentItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditDialog.this.updateAlignmentStyle(0x1000000);
            }
        });
        this.rightAlignmentItem = new ToolItem(alignmentToolBar, 16);
        this.rightAlignmentItem.setImage(iRightAlignment);
        this.rightAlignmentItem.setToolTipText(TextEditDialog.getResourceString("AlignRight"));
        this.rightAlignmentItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextEditDialog.this.updateAlignmentStyle(131072);
            }
        });
        coolItem = new CoolItem(this.coolBar, 0);
        coolItem.setControl((Control)alignmentToolBar);
        CoolItem[] coolItems = this.coolBar.getItems();
        int i = 0;
        while (i < coolItems.length) {
            CoolItem item = coolItems[i];
            Control control = item.getControl();
            Point size = control.computeSize(-1, -1);
            item.setMinimumSize(size);
            size = item.computeSize(size.x, size.y);
            item.setPreferredSize(size);
            item.setSize(size);
            ++i;
        }
    }

    protected void updateAlignmentStyle(int style) {
        this.alignmentStyle = style;
        this.leftAlignmentItem.setSelection((0x4000 & style) != 0);
        this.centerAlignmentItem.setSelection((0x1000000 & style) != 0);
        this.rightAlignmentItem.setSelection((0x20000 & style) != 0);
    }

    protected void okPressed() {
        this.styledStringText = this.createStyledStringText();
        super.okPressed();
    }

    public boolean close() {
        this.releaseResources();
        return super.close();
    }

    private void disposeRanges(StyleRange[] ranges) {
        StyleRange[] allRanges = this.styledText.getStyleRanges(0, this.styledText.getCharCount(), false);
        int i = 0;
        while (i < ranges.length) {
            Object data;
            StyleRange style = ranges[i];
            boolean disposeFg = true;
            boolean disposeBg = true;
            boolean disposeStrike = true;
            boolean disposeUnder = true;
            boolean disposeBorder = true;
            boolean disposeFont = true;
            int j = 0;
            while (j < allRanges.length) {
                StyleRange s = allRanges[j];
                if (disposeFont && style.font == s.font) {
                    disposeFont = false;
                }
                if (disposeFg && style.foreground == s.foreground) {
                    disposeFg = false;
                }
                if (disposeBg && style.background == s.background) {
                    disposeBg = false;
                }
                if (disposeStrike && style.strikeoutColor == s.strikeoutColor) {
                    disposeStrike = false;
                }
                if (disposeUnder && style.underlineColor == s.underlineColor) {
                    disposeUnder = false;
                }
                if (disposeBorder && style.borderColor == s.borderColor) {
                    disposeBorder = false;
                }
                ++j;
            }
            if (disposeFont && style.font != this.textFont && style.font != null) {
                style.font.dispose();
            }
            if (disposeFg && style.foreground != this.textForeground && style.foreground != null) {
                style.foreground.dispose();
            }
            if (disposeBg && style.background != this.textBackground && style.background != null) {
                style.background.dispose();
            }
            if (disposeStrike && style.strikeoutColor != this.strikeoutColor && style.strikeoutColor != null) {
                style.strikeoutColor.dispose();
            }
            if (disposeUnder && style.underlineColor != this.underlineColor && style.underlineColor != null) {
                style.underlineColor.dispose();
            }
            if (disposeBorder && style.borderColor != this.borderColor && style.borderColor != null) {
                style.borderColor.dispose();
            }
            if ((data = style.data) != null) {
                if (data instanceof Image) {
                    ((Image)data).dispose();
                }
                if (data instanceof Control) {
                    ((Control)data).dispose();
                }
            }
            ++i;
        }
    }

    private void disposeResource(Resource resource) {
        if (resource == null) {
            return;
        }
        StyleRange[] styles = this.styledText.getStyleRanges(0, this.styledText.getCharCount(), false);
        int index = 0;
        while (index < styles.length) {
            if (styles[index].font == resource || styles[index].foreground == resource || styles[index].background == resource || styles[index].strikeoutColor == resource || styles[index].underlineColor == resource || styles[index].borderColor == resource) break;
            ++index;
        }
        if (index == styles.length) {
            resource.dispose();
        }
    }

    private void handleKeyDown(Event event) {
        if (event.keyCode == 0x1000009) {
            this.insert = !this.insert;
        }
    }

    private void handleModify(ModifyEvent event) {
        if (this.newCharCount > 0 && this.start >= 0) {
            int borderStyle;
            int underlineStyle;
            StyleRange style = new StyleRange();
            if (this.textFont != null && !this.textFont.equals((Object)this.styledText.getFont())) {
                style.font = this.textFont;
            }
            style.fontStyle = 0;
            if (this.boldControl.getSelection()) {
                style.fontStyle |= 1;
            }
            if (this.italicControl.getSelection()) {
                style.fontStyle |= 2;
            }
            if ((this.styleState & 0x10) != 0) {
                style.foreground = this.textForeground;
            }
            if ((this.styleState & 0x20) != 0) {
                style.background = this.textBackground;
            }
            if ((underlineStyle = this.styleState & 0x3E00) != 0) {
                style.underline = true;
                style.underlineColor = this.underlineColor;
                switch (underlineStyle) {
                    case 512: {
                        style.underlineStyle = 0;
                        break;
                    }
                    case 1024: {
                        style.underlineStyle = 1;
                        break;
                    }
                    case 4096: {
                        style.underlineStyle = 3;
                        break;
                    }
                    case 2048: {
                        style.underlineStyle = 2;
                        break;
                    }
                    case 8192: {
                        style.underlineColor = null;
                        if (this.link != null && this.link.length() > 0) {
                            style.underlineStyle = 4;
                            style.data = this.link;
                            break;
                        }
                        style.underline = false;
                    }
                }
            }
            if ((this.styleState & 8) != 0) {
                style.strikeout = true;
                style.strikeoutColor = this.strikeoutColor;
            }
            if ((borderStyle = this.styleState & 0x3800000) != 0) {
                style.borderColor = this.borderColor;
                switch (borderStyle) {
                    case 0x1000000: {
                        style.borderStyle = 2;
                        break;
                    }
                    case 0x2000000: {
                        style.borderStyle = 4;
                        break;
                    }
                    case 0x800000: {
                        style.borderStyle = 1;
                    }
                }
            }
            StyleRange[] styles = new StyleRange[]{style};
            int[] nArray = new int[2];
            nArray[1] = this.styledText.getText().length();
            int[] ranges = nArray;
            this.styledText.setStyleRanges(0, this.styledText.getText().length(), ranges, styles);
        }
        this.disposeRanges(this.selectedRanges);
    }

    private void handleVerifyText(VerifyEvent event) {
        this.start = event.start;
        this.newCharCount = event.text.length();
        int replaceCharCount = event.end - this.start;
        this.selectedRanges = this.styledText.getStyleRanges(this.start, replaceCharCount, false);
    }

    private void initResources() {
        iBold = iBold == null ? this.loadImage(Display.getDefault(), "bold") : iBold;
        iItalic = iItalic == null ? this.loadImage(Display.getDefault(), "italic") : iItalic;
        iUnderline = iUnderline == null ? this.loadImage(Display.getDefault(), "underline") : iUnderline;
        iStrikeout = iStrikeout == null ? this.loadImage(Display.getDefault(), "strikeout") : iStrikeout;
        iBlockSelection = iBlockSelection == null ? this.loadImage(Display.getDefault(), "fullscrn") : iBlockSelection;
        iBorderStyle = iBorderStyle == null ? this.loadImage(Display.getDefault(), "resize") : iBorderStyle;
        iLeftAlignment = iLeftAlignment == null ? this.loadImage(Display.getDefault(), "left") : iLeftAlignment;
        iRightAlignment = iRightAlignment == null ? this.loadImage(Display.getDefault(), "right") : iRightAlignment;
        iCenterAlignment = iCenterAlignment == null ? this.loadImage(Display.getDefault(), "center") : iCenterAlignment;
        iJustifyAlignment = iJustifyAlignment == null ? this.loadImage(Display.getDefault(), "justify") : iJustifyAlignment;
        iCut = iCut == null ? this.loadImage(Display.getDefault(), "cut") : iCut;
        iCopy = iCopy == null ? this.loadImage(Display.getDefault(), "copy") : iCopy;
        iPaste = iPaste == null ? this.loadImage(Display.getDefault(), "paste") : iPaste;
        iTextForeground = iTextForeground == null ? this.loadImage(Display.getDefault(), "textForeground") : iTextForeground;
        iTextBackground = iTextBackground == null ? this.loadImage(Display.getDefault(), "textBackground") : iTextBackground;
        iBaselineUp = iBaselineUp == null ? this.loadImage(Display.getDefault(), "font_big") : iBaselineUp;
        iBaselineDown = iBaselineDown == null ? this.loadImage(Display.getDefault(), "font_sml") : iBaselineDown;
        iBulletList = iBulletList == null ? this.loadImage(Display.getDefault(), "para_bul") : iBulletList;
        iNumberedList = iNumberedList == null ? this.loadImage(Display.getDefault(), "para_num") : iNumberedList;
        iLink = iLink == null ? new Image((Device)Display.getDefault(), ((Object)((Object)this)).getClass().getResourceAsStream("link_obj.gif")) : iLink;
    }

    private void installListeners() {
        this.styledText.addCaretListener(new CaretListener(){

            public void caretMoved(CaretEvent event) {
            }
        });
        this.styledText.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                TextEditDialog.this.handleKeyDown(event);
            }
        });
        this.styledText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                TextEditDialog.this.handleVerifyText(event);
            }
        });
        this.styledText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                TextEditDialog.this.handleModify(event);
            }
        });
    }

    private Image loadImage(Display display, String fileName) {
        Image image = null;
        try {
            InputStream sourceStream = ((Object)((Object)this)).getClass().getResourceAsStream(String.valueOf(fileName) + ".ico");
            ImageData source = new ImageData(sourceStream);
            ImageData mask = source.getTransparencyMask();
            image = new Image((Device)display, source, mask);
            sourceStream.close();
        }
        catch (IOException e) {
            this.showError(TextEditDialog.getResourceString("Error"), e.getMessage());
        }
        return image;
    }

    private void releaseResources() {
        if (this.textFont != null) {
            this.textFont.dispose();
        }
        this.textFont = null;
        if (this.textForeground != null) {
            this.textForeground.dispose();
        }
        this.textForeground = null;
        if (this.textBackground != null) {
            this.textBackground.dispose();
        }
        this.textBackground = null;
        if (this.strikeoutColor != null) {
            this.strikeoutColor.dispose();
        }
        this.strikeoutColor = null;
        if (this.underlineColor != null) {
            this.underlineColor.dispose();
        }
        this.underlineColor = null;
        if (this.borderColor != null) {
            this.borderColor.dispose();
        }
        this.borderColor = null;
        if (this.font != null) {
            this.font.dispose();
        }
        this.font = null;
    }

    private void setStyle(int style) {
        this.setStyle(style, 0, this.styledText.getText().length());
        this.updateStyleState(style, 16);
        this.updateStyleState(style, 32);
        this.updateStyleState(style, 15872);
        this.updateStyleState(style, 8);
        this.updateStyleState(style, 0x3800000);
    }

    private void setStyle(int style, int start, int length) {
        if (length == 0) {
            return;
        }
        StyleRange newRange = new StyleRange();
        if ((style & 0x40) != 0) {
            newRange.font = this.textFont;
        }
        if ((style & 3) != 0) {
            newRange.fontStyle = style & 3;
        }
        if ((style & 0x10) != 0) {
            newRange.foreground = this.textForeground;
        }
        if ((style & 0x20) != 0) {
            newRange.background = this.textBackground;
        }
        if ((style & 0x80) != 0) {
            newRange.rise = newRange.rise + 1;
        }
        if ((style & 0x100) != 0) {
            newRange.rise = newRange.rise - 1;
        }
        if ((style & 8) != 0) {
            newRange.strikeout = true;
            newRange.strikeoutColor = this.strikeoutColor;
        }
        if ((style & 0x3E00) != 0) {
            newRange.underline = true;
            newRange.underlineColor = this.underlineColor;
            switch (style & 0x3E00) {
                case 512: {
                    newRange.underlineStyle = 0;
                    break;
                }
                case 1024: {
                    newRange.underlineStyle = 1;
                    break;
                }
                case 2048: {
                    newRange.underlineStyle = 2;
                    break;
                }
                case 4096: {
                    newRange.underlineStyle = 3;
                    break;
                }
                case 8192: {
                    newRange.underlineColor = null;
                    if (this.link != null && this.link.length() > 0) {
                        newRange.underlineStyle = 4;
                        newRange.data = this.link;
                        break;
                    }
                    newRange.underline = false;
                }
            }
        }
        if ((style & 0x3800000) != 0) {
            switch (style & 0x3800000) {
                case 0x1000000: {
                    newRange.borderStyle = 2;
                    break;
                }
                case 0x2000000: {
                    newRange.borderStyle = 4;
                    break;
                }
                case 0x800000: {
                    newRange.borderStyle = 1;
                }
            }
            newRange.borderColor = this.borderColor;
        }
        int newRangeStart = start;
        int newRangeLength = length;
        int[] ranges = this.styledText.getRanges(start, length);
        StyleRange[] styles = this.styledText.getStyleRanges(start, length, false);
        int maxCount = ranges.length * 2 + 2;
        int[] newRanges = new int[maxCount];
        StyleRange[] newStyles = new StyleRange[maxCount / 2];
        int count = 0;
        int i = 0;
        while (i < ranges.length) {
            int rangeStart = ranges[i];
            int rangeLength = ranges[i + 1];
            StyleRange range = styles[i / 2];
            if (rangeStart > newRangeStart) {
                newRangeLength = rangeStart - newRangeStart;
                newRanges[count] = newRangeStart;
                newRanges[count + 1] = newRangeLength;
                newStyles[count / 2] = newRange;
                count += 2;
            }
            newRangeStart = rangeStart + rangeLength;
            newRangeLength = start + length - newRangeStart;
            StyleRange mergedRange = new StyleRange((TextStyle)range);
            mergedRange.fontStyle = range.fontStyle;
            if ((style & 0x40) != 0) {
                mergedRange.font = newRange.font;
            }
            if ((style & 3) != 0) {
                mergedRange.fontStyle = range.fontStyle ^ newRange.fontStyle;
            }
            if (mergedRange.font != null && ((style & 0x40) != 0 || (style & 3) != 0)) {
                boolean change = false;
                FontData[] fds = mergedRange.font.getFontData();
                int j = 0;
                while (j < fds.length) {
                    FontData fd = fds[j];
                    if (fd.getStyle() != mergedRange.fontStyle) {
                        fds[j].setStyle(mergedRange.fontStyle);
                        change = true;
                    }
                    ++j;
                }
                if (change) {
                    mergedRange.font = new Font((Device)Display.getDefault(), fds);
                }
            }
            if ((style & 0x10) != 0) {
                Color color = mergedRange.foreground = newRange.foreground != range.foreground ? newRange.foreground : null;
            }
            if ((style & 0x20) != 0) {
                Color color = mergedRange.background = newRange.background != range.background ? newRange.background : null;
            }
            if ((style & 0x80) != 0) {
                mergedRange.rise = mergedRange.rise + 1;
            }
            if ((style & 0x100) != 0) {
                mergedRange.rise = mergedRange.rise - 1;
            }
            if ((style & 8) != 0) {
                mergedRange.strikeout = !range.strikeout || range.strikeoutColor != newRange.strikeoutColor;
                Color color = mergedRange.strikeoutColor = mergedRange.strikeout ? newRange.strikeoutColor : null;
            }
            if ((style & 0x3E00) != 0) {
                if ((style & 0x2000) != 0) {
                    mergedRange.underline = this.link != null && this.link.length() > 0 ? !range.underline || range.underlineStyle != newRange.underlineStyle || range.data != newRange.data : false;
                    mergedRange.underlineColor = null;
                } else {
                    mergedRange.underline = !range.underline || range.underlineStyle != newRange.underlineStyle || range.underlineColor != newRange.underlineColor;
                    mergedRange.underlineColor = mergedRange.underline ? newRange.underlineColor : null;
                }
                mergedRange.underlineStyle = mergedRange.underline ? newRange.underlineStyle : 0;
                Object object = mergedRange.data = mergedRange.underline ? newRange.data : null;
            }
            if ((style & 0x3800000) != 0) {
                if (range.borderStyle != newRange.borderStyle || range.borderColor != newRange.borderColor) {
                    mergedRange.borderStyle = newRange.borderStyle;
                    mergedRange.borderColor = newRange.borderColor;
                } else {
                    mergedRange.borderStyle = 0;
                    mergedRange.borderColor = null;
                }
            }
            newRanges[count] = rangeStart;
            newRanges[count + 1] = rangeLength;
            newStyles[count / 2] = mergedRange;
            count += 2;
            i += 2;
        }
        if (newRangeLength > 0) {
            newRanges[count] = newRangeStart;
            newRanges[count + 1] = newRangeLength;
            newStyles[count / 2] = newRange;
            count += 2;
        }
        if (count > 0 && count < maxCount) {
            int[] tmpRanges = new int[count];
            StyleRange[] tmpStyles = new StyleRange[count / 2];
            System.arraycopy(newRanges, 0, tmpRanges, 0, count);
            System.arraycopy(newStyles, 0, tmpStyles, 0, count / 2);
            newRanges = tmpRanges;
            newStyles = tmpStyles;
        }
        this.styledText.setStyleRanges(start, length, newRanges, newStyles);
        this.disposeRanges(styles);
    }

    private void showError(String title, String message) {
        MessageBox messageBox = new MessageBox(this.shell, 65);
        messageBox.setText(title);
        messageBox.setMessage(message);
        messageBox.open();
    }

    private void updateStyleState(int style, int changingStyle) {
        if ((style & changingStyle) != 0) {
            if ((style & changingStyle) == (this.styleState & changingStyle)) {
                this.styleState &= ~changingStyle;
            } else {
                this.styleState &= ~changingStyle;
                this.styleState |= style;
            }
        }
    }

    private void setLink() {
        this.link = "http://aurora.hand-china.com/";
        this.setStyle(8192);
    }

    private void updateToolBar() {
        StyleRange range;
        this.styleState = 0;
        this.link = null;
        boolean bold = false;
        boolean italic = false;
        Font font = null;
        StyleRange styleRange = range = this.styledText.getText().length() > 0 ? this.styledText.getStyleRangeAtOffset(0) : null;
        if (range != null) {
            if (range.font != null) {
                font = range.font;
                FontData[] fds = font.getFontData();
                int i = 0;
                while (i < fds.length) {
                    int fontStyle = fds[i].getStyle();
                    if (!bold && (fontStyle & 1) != 0) {
                        bold = true;
                    }
                    if (!italic && (fontStyle & 2) != 0) {
                        italic = true;
                    }
                    ++i;
                }
            } else {
                bold = (range.fontStyle & 1) != 0;
                boolean bl = italic = (range.fontStyle & 2) != 0;
            }
            if (range.foreground != null) {
                this.styleState |= 0x10;
                if (this.textForeground != range.foreground) {
                    this.disposeResource((Resource)this.textForeground);
                    this.textForeground = range.foreground;
                }
            }
            if (range.background != null) {
                this.styleState |= 0x20;
                if (this.textBackground != range.background) {
                    this.disposeResource((Resource)this.textBackground);
                    this.textBackground = range.background;
                }
            }
            if (range.underline) {
                switch (range.underlineStyle) {
                    case 0: {
                        this.styleState |= 0x200;
                        break;
                    }
                    case 1: {
                        this.styleState |= 0x400;
                        break;
                    }
                    case 3: {
                        this.styleState |= 0x1000;
                        break;
                    }
                    case 2: {
                        this.styleState |= 0x800;
                        break;
                    }
                    case 4: {
                        this.styleState |= 0x2000;
                        this.link = (String)range.data;
                    }
                }
                if (range.underlineStyle != 4) {
                    this.underlineSingleItem.setSelection((this.styleState & 0x200) != 0);
                    this.underlineDoubleItem.setSelection((this.styleState & 0x400) != 0);
                    this.underlineErrorItem.setSelection((this.styleState & 0x800) != 0);
                    this.underlineSquiggleItem.setSelection((this.styleState & 0x1000) != 0);
                    this.disposeResource((Resource)this.underlineColor);
                    this.underlineColor = range.underlineColor;
                }
            }
            if (range.strikeout) {
                this.styleState |= 8;
                this.disposeResource((Resource)this.strikeoutColor);
                this.strikeoutColor = range.strikeoutColor;
            }
            if (range.borderStyle != 0) {
                switch (range.borderStyle) {
                    case 1: {
                        this.styleState |= 0x800000;
                        break;
                    }
                    case 2: {
                        this.styleState |= 0x1000000;
                        break;
                    }
                    case 4: {
                        this.styleState |= 0x2000000;
                    }
                }
                this.borderSolidItem.setSelection((this.styleState & 0x800000) != 0);
                this.borderDashItem.setSelection((this.styleState & 0x1000000) != 0);
                this.borderDotItem.setSelection((this.styleState & 0x2000000) != 0);
                this.disposeResource((Resource)this.borderColor);
                this.borderColor = range.borderColor;
            }
        }
        this.boldControl.setSelection(bold);
        this.italicControl.setSelection(italic);
        this.disposeResource((Resource)this.textFont);
        this.textFont = font;
    }

    public StyledStringText createStyledStringText() {
        StyleRange[] styleRanges = this.styledText.getStyleRanges();
        StyledStringText sst = new StyledStringText();
        sst.setText(this.styledText.getText());
        if (styleRanges.length == 0) {
            return sst;
        }
        StyleRange styleRange = styleRanges[0];
        Font font = styleRange.font == null ? this.styledText.getFont() : styleRange.font;
        sst.setFontName(font.getFontData()[0].getName());
        sst.setFontSize(font.getFontData()[0].getHeight());
        sst.setBold((styleRange.fontStyle & 1) != 0);
        sst.setItalic((styleRange.fontStyle & 2) != 0);
        if (styleRange.background != null) {
            sst.setTextBackground(AuroraImagesUtils.toString((RGB)styleRange.background.getRGB()));
        }
        if (styleRange.foreground != null) {
            sst.setTextForeground(AuroraImagesUtils.toString((RGB)styleRange.foreground.getRGB()));
        }
        if (styleRange.strikeout) {
            sst.setStrikeout(styleRange.strikeout);
            if (styleRange.strikeoutColor != null) {
                sst.setStrikeoutColor(AuroraImagesUtils.toString((RGB)styleRange.strikeoutColor.getRGB()));
            }
        }
        if (styleRange.underline) {
            sst.setUnderline(styleRange.underline);
            if (styleRange.underlineColor != null) {
                sst.setUnderlineColor(AuroraImagesUtils.toString((RGB)styleRange.underlineColor.getRGB()));
            }
            sst.setUnderlineStyle(styleRange.underlineStyle);
        }
        sst.setAlignment(this.alignmentStyle);
        return sst;
    }

    public StyledStringText getStyledStringText() {
        return this.styledStringText;
    }

    public void setStyledStringText(StyledStringText styledStringText) {
        this.styledStringText = styledStringText;
    }
}

