/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.util;

import aurora.ide.libs.AuroraImagesUtils;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.StyledStringText;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class TextStyleUtil {
    private static final int BOLD = 1;
    private static final int ITALIC = 2;

    public static TextStyle createTextStyle(StyledStringText styledStringText, Display display, Font font) {
        TextStyle ts = new TextStyle();
        if (styledStringText == null) {
            return ts;
        }
        int fontStyle = 0;
        if (styledStringText.isBold()) {
            fontStyle |= 1;
        }
        if (styledStringText.isItalic()) {
            fontStyle |= 2;
        }
        ts.font = new Font((Device)display, font.getFontData()[0].getName(), font.getFontData()[0].getHeight(), fontStyle);
        if (styledStringText.isStrikeout()) {
            if (styledStringText.getStrikeoutColor() != null && !"-1,-1,-1".equals(styledStringText.getStrikeoutColor())) {
                ts.strikeoutColor = new Color((Device)display, AuroraImagesUtils.toRGB((String)styledStringText.getStrikeoutColor()));
            }
            ts.strikeout = true;
        }
        if (styledStringText.isUnderline()) {
            if (styledStringText.getUnderlineStyle() != 4 && styledStringText.getUnderlineColor() != null && !"-1,-1,-1".equals(styledStringText.getUnderlineColor())) {
                ts.underlineColor = new Color((Device)display, AuroraImagesUtils.toRGB((String)styledStringText.getUnderlineColor()));
            }
            ts.underlineStyle = styledStringText.getUnderlineStyle();
            ts.underline = styledStringText.isUnderline();
        }
        if (styledStringText.getTextBackground() != null && !"-1,-1,-1".equals(styledStringText.getTextBackground())) {
            ts.background = new Color((Device)display, AuroraImagesUtils.toRGB((String)styledStringText.getTextBackground()));
        }
        if (styledStringText.getTextForeground() != null && !"-1,-1,-1".equals(styledStringText.getTextForeground())) {
            ts.foreground = new Color((Device)display, AuroraImagesUtils.toRGB((String)styledStringText.getTextForeground()));
        }
        return ts;
    }

    public static boolean isTextLayoutUseless(AuroraComponent ac, String pro_id) {
        Object obj = ac.getPropertyValue(String.valueOf(pro_id) + "_text_style");
        return !(obj instanceof StyledStringText) || ((StyledStringText)obj).isUseless();
    }

    public static void dispose(TextStyle ts) {
        if (ts.font != null) {
            if (!ts.font.isDisposed()) {
                ts.font.dispose();
            }
            ts.font = null;
        }
        if (ts.strikeoutColor != null) {
            if (!ts.strikeoutColor.isDisposed()) {
                ts.strikeoutColor.dispose();
            }
            ts.strikeoutColor = null;
        }
        if (ts.underlineColor != null) {
            if (!ts.underlineColor.isDisposed()) {
                ts.underlineColor.dispose();
            }
            ts.underlineColor = null;
        }
        if (ts.background != null) {
            if (!ts.background.isDisposed()) {
                ts.background.dispose();
            }
            ts.background = null;
        }
        if (ts.foreground != null) {
            if (!ts.foreground.isDisposed()) {
                ts.foreground.dispose();
            }
            ts.foreground = null;
        }
    }

    public static Point getTextAlignment(Rectangle rect, String text, Font font, int alignmentStyle) {
        Rectangle cr = rect.getCopy();
        Dimension textExtents = FigureUtilities.getTextExtents((String)text, (Font)font);
        int right = cr.x + cr.width - textExtents.width;
        int left = cr.x + 2;
        int center = cr.getCenter().x - textExtents.width / 2;
        center = cr.width - textExtents.width <= 0 ? left : center;
        int y = cr.height - textExtents.height;
        y = y <= 0 ? cr.y : cr.y + y / 2;
        int x = left;
        if ((0x20000 & alignmentStyle) != 0) {
            x = right;
        }
        if ((0x1000000 & alignmentStyle) != 0) {
            x = center;
        }
        return new Point(x, y);
    }
}

