/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.project;

import aurora.ide.AuroraProjectNature;
import aurora.ide.meta.project.AuroraMetaProject;
import aurora.ide.meta.project.AuroraMetaProjectNature;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.ide.undo.CreateFolderOperation;
import org.eclipse.ui.ide.undo.CreateProjectOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class CreateMetaProjectWizard
extends BasicNewProjectResourceWizard {
    private WizardNewProjectCreationPage mainPage;
    private IProject newProject;
    private Combo auroraProjectNameField;

    public void addPages() {
        this.mainPage = new WizardNewProjectCreationPage("basicNewProjectPage"){
            private String initialProjectFieldValue;
            Text projectNameField;
            private Listener nameModifyListener;
            private static final int SIZING_TEXT_FIELD_WIDTH = 250;
            {
                this.nameModifyListener = new Listener(){

                    public void handleEvent(Event e) {
                        boolean valid = this.validatePage();
                        this.setPageComplete(valid);
                    }
                };
            }

            public void createControl(Composite parent) {
                Composite composite = new Composite(parent, 0);
                this.initializeDialogUnits((Control)parent);
                composite.setLayout((Layout)new GridLayout());
                composite.setLayoutData((Object)new GridData(1808));
                Composite projectGroup = new Composite(composite, 0);
                GridLayout layout = new GridLayout();
                layout.numColumns = 2;
                projectGroup.setLayout((Layout)layout);
                projectGroup.setLayoutData((Object)new GridData(768));
                this.createProjectNameGroup(projectGroup);
                this.createAruoraProjectNameGroup(projectGroup);
                this.setPageComplete(this.validatePage());
                this.setErrorMessage(null);
                this.setMessage(null);
                this.setControl((Control)composite);
                Dialog.applyDialogFont((Control)composite);
            }

            private final void createProjectNameGroup(Composite projectGroup) {
                Label projectLabel = new Label(projectGroup, 0);
                projectLabel.setText("Project name: ");
                projectLabel.setFont(projectGroup.getFont());
                this.projectNameField = new Text(projectGroup, 2048);
                GridData data = new GridData(768);
                data.widthHint = 250;
                this.projectNameField.setLayoutData((Object)data);
                this.projectNameField.setFont(projectGroup.getFont());
                if (this.initialProjectFieldValue != null) {
                    this.projectNameField.setText(this.initialProjectFieldValue);
                }
                this.projectNameField.addListener(24, this.nameModifyListener);
            }

            private final void createAruoraProjectNameGroup(Composite projectGroup) {
                Label projectLabel = new Label(projectGroup, 0);
                projectLabel.setText("Aurora Project name: ");
                projectLabel.setFont(projectGroup.getFont());
                CreateMetaProjectWizard.this.auroraProjectNameField = new Combo(projectGroup, 8);
                GridData data = new GridData(768);
                data.widthHint = 250;
                CreateMetaProjectWizard.this.auroraProjectNameField.setLayoutData((Object)data);
                CreateMetaProjectWizard.this.auroraProjectNameField.setFont(projectGroup.getFont());
                CreateMetaProjectWizard.this.auroraProjectNameField.select(0);
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IProject[] projects = workspace.getRoot().getProjects();
                CreateMetaProjectWizard.this.auroraProjectNameField.add("");
                IProject[] iProjectArray = projects;
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject p = iProjectArray[n2];
                    boolean hasAuroraNature = false;
                    try {
                        hasAuroraNature = AuroraProjectNature.hasAuroraNature((IProject)p);
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    if (hasAuroraNature) {
                        CreateMetaProjectWizard.this.auroraProjectNameField.add(p.getName());
                    }
                    ++n2;
                }
            }

            public IProject getProjectHandle() {
                return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
            }

            public String getProjectName() {
                if (this.projectNameField == null) {
                    return this.initialProjectFieldValue;
                }
                return this.getProjectNameFieldValue();
            }

            private String getProjectNameFieldValue() {
                if (this.projectNameField == null) {
                    return "";
                }
                return this.projectNameField.getText().trim();
            }

            public void setInitialProjectName(String name) {
                this.initialProjectFieldValue = name == null ? null : name.trim();
            }

            protected boolean validatePage() {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                String projectFieldContents = this.getProjectNameFieldValue();
                if (projectFieldContents.equals("")) {
                    this.setErrorMessage(null);
                    this.setMessage("Project name must be specified.");
                    return false;
                }
                IStatus nameStatus = workspace.validateName(projectFieldContents, 4);
                if (!nameStatus.isOK()) {
                    this.setErrorMessage(nameStatus.getMessage());
                    return false;
                }
                IProject handle = this.getProjectHandle();
                if (handle.exists()) {
                    this.setErrorMessage("A project with that name already exists in the workspace.");
                    return false;
                }
                this.setErrorMessage(null);
                this.setMessage(null);
                return true;
            }

            public boolean useDefaults() {
                return true;
            }

            public void setVisible(boolean visible) {
                this.getControl().setVisible(visible);
                if (visible) {
                    this.projectNameField.setFocus();
                }
            }
        };
        this.mainPage.setTitle("Project");
        this.mainPage.setDescription("Create an aurora meta project.");
        this.addPage((IWizardPage)this.mainPage);
    }

    public IProject getAuroraProjectHandle() {
        if (this.auroraProjectNameField == null) {
            return null;
        }
        String trim = this.auroraProjectNameField.getText().trim();
        if ("".equals(trim)) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(trim);
    }

    public boolean performFinish() {
        this.createNewProject();
        if (this.newProject == null) {
            return false;
        }
        this.createFolders();
        IProject auroraProjectHandle = this.getAuroraProjectHandle();
        String name = auroraProjectHandle == null ? "" : auroraProjectHandle.getName();
        AuroraMetaProject amp = new AuroraMetaProject(this.newProject);
        amp.setAuroraProject(name);
        this.updatePerspective();
        this.selectAndReveal((IResource)this.newProject);
        return true;
    }

    private void createFolders() {
        if (this.newProject == null) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                IFolder[] fs;
                IFolder model = CreateMetaProjectWizard.this.newProject.getFolder("model_prototype");
                IFolder screen = CreateMetaProjectWizard.this.newProject.getFolder("ui_prototype");
                IFolder[] iFolderArray = fs = new IFolder[]{model, screen};
                int n = fs.length;
                int n2 = 0;
                while (n2 < n) {
                    IFolder iFolder = iFolderArray[n2];
                    CreateFolderOperation op = new CreateFolderOperation(iFolder, null, "new folder");
                    try {
                        op.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)CreateMetaProjectWizard.this.getShell()));
                    }
                    catch (ExecutionException e) {
                        throw new InvocationTargetException(e);
                    }
                    ++n2;
                }
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private IProject createNewProject() {
        if (this.newProject != null) {
            return this.newProject;
        }
        IProject newProjectHandle = this.mainPage.getProjectHandle();
        URI location = null;
        if (!this.mainPage.useDefaults()) {
            location = this.mainPage.getLocationURI();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocationURI(location);
        description.setNatureIds(new String[]{"aurora.ide.meta.nature"});
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                CreateProjectOperation op = new CreateProjectOperation(description, "new aurora meta project");
                try {
                    op.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)CreateMetaProjectWizard.this.getShell()));
                }
                catch (ExecutionException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
        this.newProject = newProjectHandle;
        AuroraMetaProjectNature naturehandler = new AuroraMetaProjectNature();
        naturehandler.setProject(this.newProject);
        try {
            naturehandler.configure();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return this.newProject;
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
    }
}

