/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.prototype.consultant.demonstrate;

import aurora.ide.meta.gef.editors.models.commands.ChangePropertyCommand;
import aurora.ide.meta.gef.editors.parts.ComponentPart;
import aurora.ide.meta.gef.editors.wizard.dialog.DemonstratingDialog;
import aurora.ide.meta.gef.editors.wizard.dialog.LovDialogInput;
import aurora.ide.prototype.consultant.demonstrate.DemonstrateDSManager;
import aurora.plugin.source.gen.screen.model.AuroraComponent;
import aurora.plugin.source.gen.screen.model.DemonstrateDS;
import aurora.plugin.source.gen.screen.model.DemonstrateData;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.widgets.Shell;

public class LOVDemonstrating {
    private ComponentPart part;
    private String feature = "input_simple_data";

    public LOVDemonstrating(ComponentPart part) {
        this.part = part;
    }

    public void demonstrating(Shell shell) {
        DemonstratingDialog lov = new DemonstratingDialog(shell, this);
        lov.setInput(this.parseItems());
        lov.open();
    }

    public void applyValue(String value) {
        this.applyValue(this.part.getComponent(), value);
    }

    public void applyValue(AuroraComponent ac, String value) {
        ChangePropertyCommand command = new ChangePropertyCommand(ac, this.feature, value);
        this.part.getViewer().getEditDomain().getCommandStack().execute((Command)command);
    }

    private LovDialogInput parseItems() {
        DemonstrateDS demonstrateDS;
        DemonstrateData dd = (DemonstrateData)this.part.getComponent().getPropertyValue("demonstrate_data");
        if (dd == null) {
            return new LovDialogInput(0, 0);
        }
        String dsName = dd.getDemonstrateDSName();
        if (dsName != null && !"".equals(dsName) && (demonstrateDS = DemonstrateDSManager.getInstance().getDemonstrateDS(dsName)) != null) {
            return this.parseItems(demonstrateDS.getData());
        }
        String data = dd.getDemonstrateData();
        LovDialogInput parseItems = this.parseItems(data);
        if (parseItems == null) {
            return new LovDialogInput(0, 0);
        }
        List inputs = (List)dd.getPropertyValue("bind_component");
        parseItems.setBindModels(inputs);
        return parseItems;
    }

    private LovDialogInput parseItems(String demonstrateDS) {
        if (demonstrateDS == null || "".equals(demonstrateDS)) {
            return new LovDialogInput(0, 0);
        }
        StringReader sr = new StringReader(demonstrateDS);
        BufferedReader br = new BufferedReader(sr);
        String str = "";
        ArrayList<String> rows = new ArrayList<String>();
        int col = 0;
        try {
            while ((str = br.readLine()) != null) {
                rows.add(str);
                String[] split = str.split(",");
                int n = col = col > split.length ? col : split.length;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LovDialogInput input = new LovDialogInput(col, rows.size());
        int i = 0;
        while (i < rows.size()) {
            String s = (String)rows.get(i);
            String[] split = s.split(",");
            int j = 0;
            while (j < col) {
                input.add(j, i, j >= split.length ? "" : split[j]);
                ++j;
            }
            ++i;
        }
        return input;
    }

    public String getFeature() {
        return this.feature;
    }

    public void setFeature(String feature) {
        this.feature = feature;
    }
}

