/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.ServerDTVImpl;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSReaderMark;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class BaseInputStream
extends InputStream {
    final boolean isAdaptive;
    final boolean isStreaming;
    private String parentLoggingInfo = "";
    private static int lastLoggingID = 0;
    static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.InputStream");
    private String traceID;
    int streamPos = 0;
    int markedStreamPos = 0;
    TDSReaderMark currentMark;
    private ServerDTVImpl dtv;
    TDSReader tdsReader;
    int readLimit = 0;
    boolean isReadLimitSet = false;

    abstract byte[] getBytes() throws SQLServerException;

    private static synchronized int nextLoggingID() {
        return ++lastLoggingID;
    }

    public final String toString() {
        if (this.traceID == null) {
            this.traceID = this.getClass().getName() + "ID:" + BaseInputStream.nextLoggingID();
        }
        return this.traceID;
    }

    final void setLoggingInfo(String string) {
        this.parentLoggingInfo = string;
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.toString());
        }
    }

    BaseInputStream(TDSReader tDSReader, boolean bl, boolean bl2, ServerDTVImpl serverDTVImpl) {
        this.tdsReader = tDSReader;
        this.isAdaptive = bl;
        this.isStreaming = bl2;
        if (bl) {
            this.clearCurrentMark();
        } else {
            this.currentMark = tDSReader.mark();
        }
        this.dtv = serverDTVImpl;
    }

    final void clearCurrentMark() {
        this.currentMark = null;
        this.isReadLimitSet = false;
        if (this.isAdaptive && this.isStreaming) {
            this.tdsReader.stream();
        }
    }

    void closeHelper() throws IOException {
        if (this.isAdaptive && null != this.dtv) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(this.toString() + " closing the adaptive stream.");
            }
            this.dtv.setPositionAfterStreamed(this.tdsReader);
        }
        this.currentMark = null;
        this.tdsReader = null;
        this.dtv = null;
    }

    final void checkClosed() throws IOException {
        if (null == this.tdsReader) {
            throw new IOException(SQLServerException.getErrString("R_streamIsClosed"));
        }
    }

    public boolean markSupported() {
        return true;
    }

    void setReadLimit(int n) {
        if (this.isAdaptive && n > 0) {
            this.readLimit = n;
            this.isReadLimitSet = true;
        }
    }

    void resetHelper() throws IOException {
        this.checkClosed();
        if (null == this.currentMark) {
            throw new IOException(SQLServerException.getErrString("R_streamWasNotMarkedBefore"));
        }
        this.tdsReader.reset(this.currentMark);
    }
}

