/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.event.impl;

import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.event.TextEvent;
import com.topologi.diffx.event.impl.DiffXEventBase;
import com.topologi.diffx.xml.XMLWriter;
import java.io.IOException;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class LineEvent
extends DiffXEventBase
implements TextEvent {
    private final CharSequence characters;
    private final int lineNumber;
    private int fHashCode;

    public LineEvent(CharSequence line, int lineNumber) throws NullPointerException {
        if (line == null) {
            throw new NullPointerException("The line cannot be null, use \"\"");
        }
        this.characters = line;
        this.lineNumber = lineNumber;
    }

    public String toString() {
        return "line:" + this.lineNumber + ": \"" + this.getCharacters() + '\"';
    }

    public int hashCode() {
        if (this.fHashCode == 0) {
            this.fHashCode = new HashCodeBuilder(17, 37).append((Object)this.characters).toHashCode();
        }
        return this.fHashCode;
    }

    public boolean equals(DiffXEvent e) {
        if (this == e) {
            return true;
        }
        if (e.getClass() != LineEvent.class) {
            return false;
        }
        LineEvent ce = (LineEvent)e;
        return ce.characters.equals(this.characters);
    }

    public String getCharacters() {
        return ((Object)this.characters).toString();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.writeXML(((Object)this.characters).toString());
    }

    public StringBuffer toXML(StringBuffer xml) throws NullPointerException {
        xml.append(this.characters);
        return xml;
    }
}

