/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.sequence;

import com.topologi.diffx.event.DiffXEvent;
import com.topologi.diffx.format.DiffXFormatter;
import com.topologi.diffx.sequence.EventSequence;
import java.io.IOException;

public final class NaiveSequenceSlicer {
    final EventSequence sequence1;
    final EventSequence sequence2;
    EventSequence start = null;
    EventSequence end = null;

    public NaiveSequenceSlicer(EventSequence seq0, EventSequence seq1) {
        this.sequence1 = seq0;
        this.sequence2 = seq1;
    }

    public int sliceStart() throws IllegalStateException {
        if (this.start != null) {
            throw new IllegalStateException("The start buffer already contains a subsequence.");
        }
        this.start = new EventSequence();
        int count = 0;
        EventSequence.EventIterator i = this.sequence1.eventIterator();
        EventSequence.EventIterator j = this.sequence2.eventIterator();
        while (i.hasNext() && j.hasNext()) {
            DiffXEvent e = (DiffXEvent)i.next();
            if (j.next().equals(e)) {
                ++count;
                i.remove();
                j.remove();
                this.start.addEvent(e);
                continue;
            }
            return count;
        }
        return count;
    }

    public int sliceEnd() throws IllegalStateException {
        DiffXEvent e1;
        if (this.end != null) {
            throw new IllegalStateException("The end buffer already contains a subsequence.");
        }
        this.end = new EventSequence();
        int count = 0;
        int pos1 = this.sequence1.size() - 1;
        int pos2 = this.sequence2.size() - 1;
        while (pos1 >= 0 && pos2 >= 0 && (e1 = this.sequence1.getEvent(pos1)).equals(this.sequence2.getEvent(pos2))) {
            ++count;
            this.sequence1.removeEvent(pos1--);
            this.sequence2.removeEvent(pos2--);
            this.end.addEvent(0, e1);
        }
        return count;
    }

    public int sliceStart(DiffXFormatter formatter) throws IllegalStateException, NullPointerException, IOException {
        if (this.start != null) {
            throw new IllegalStateException("The start buffer already contains a subsequence.");
        }
        int count = 0;
        EventSequence.EventIterator i = this.sequence1.eventIterator();
        EventSequence.EventIterator j = this.sequence2.eventIterator();
        while (i.hasNext() && j.hasNext()) {
            DiffXEvent e = (DiffXEvent)i.next();
            if (!j.next().equals(e)) break;
            ++count;
            i.remove();
            j.remove();
            formatter.format(e);
        }
        return count;
    }

    public int sliceEnd(DiffXFormatter formatter) throws IllegalStateException, NullPointerException, IOException {
        int count = this.sliceEnd();
        this.formatEnd(formatter);
        return count;
    }

    public void formatStart(DiffXFormatter formatter) throws NullPointerException, IOException {
        if (this.start == null) {
            return;
        }
        for (int i = 0; i < this.start.size(); ++i) {
            formatter.format(this.start.getEvent(i));
        }
        this.start = null;
    }

    public void formatEnd(DiffXFormatter formatter) throws NullPointerException, IOException {
        if (this.end == null) {
            return;
        }
        for (int i = 0; i < this.end.size(); ++i) {
            formatter.format(this.end.getEvent(i));
        }
        this.end = null;
    }

    public EventSequence getStart() {
        return this.start;
    }

    public EventSequence getEnd() {
        return this.end;
    }
}

