/*
 * Decompiled with CFR 0.152.
 */
package com.topologi.diffx.xml;

import com.topologi.diffx.xml.XMLWriter;
import com.topologi.diffx.xml.esc.XMLEscapeWriter;
import com.topologi.diffx.xml.esc.XMLEscapeWriterUTF8;
import java.io.IOException;
import java.io.Writer;

abstract class XMLWriterBase
implements XMLWriter {
    final boolean indent;
    final Writer writer;
    static final String ENCODING = "utf-8";
    final XMLEscapeWriter writerEscape;
    int depth = 0;

    public XMLWriterBase(Writer writer) throws NullPointerException {
        this(writer, true);
    }

    public XMLWriterBase(Writer writer, boolean indent) throws NullPointerException {
        if (writer == null) {
            throw new NullPointerException("XMLWriter cannot use a null writer.");
        }
        this.writer = writer;
        this.writerEscape = new XMLEscapeWriterUTF8(writer);
        this.indent = indent;
    }

    public final void xmlDecl() throws IOException {
        this.writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
    }

    public void writeText(String text) throws IOException {
        this.writerEscape.writeText(text);
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            this.writeChar(text[i]);
        }
    }

    public void writeXML(String text) throws IOException {
        this.writer.write(text);
    }

    public void writeXML(char[] text, int off, int len) throws IOException {
        this.writer.write(text, off, len);
    }

    public void writeChar(char c) throws IOException {
        this.writerEscape.writeText(c);
    }

    public final void writeText(Object o) throws IOException {
        if (o != null) {
            this.writeText(o.toString());
        }
    }

    public void writeComment(String comment) throws IOException, IllegalArgumentException {
        if (comment != null && comment.indexOf("--") >= 0) {
            throw new IllegalArgumentException("A comment should not contain '--'.");
        }
        if (this.indent) {
            this.writer.write(10);
        }
        this.writer.write("<!-- ");
        this.writer.write(comment);
        this.writer.write(" -->");
        if (this.indent) {
            this.writer.write(10);
        }
    }

    public void writePI(String target, String data) throws IOException {
        this.writer.write("<?");
        this.writer.write(target);
        this.writer.write(32);
        this.writer.write(data);
        this.writer.write("?>");
        if (this.indent) {
            this.writer.write(10);
        }
    }

    void indent() throws IOException {
        if (this.indent) {
            for (int i = 0; i < this.depth; ++i) {
                this.writer.write("  ");
            }
        }
    }

    public void element(String name, String text) throws IOException {
        this.openElement(name);
        this.writeText(text);
        this.closeElement();
    }

    public final void write(String s) throws IOException {
        this.writer.write(s);
    }

    public final void write(char c) throws IOException {
        this.writer.write(c);
    }

    public final void flush() throws IOException {
        this.writer.flush();
    }

    public final void close() throws IOException {
        this.writer.close();
    }

    static final void doNothing() {
    }
}

