/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.ModelConverter;
import org.docx4j.model.Model;
import org.docx4j.model.SymbolModel;
import org.docx4j.model.TransformState;
import org.docx4j.model.table.TableModel;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Converter {
    private static final Logger log = Logger.getLogger(Converter.class);
    private static Converter instance = new Converter();
    private WordprocessingMLPackage wmlPackage;
    private Map<String, Class> modelClasses = new HashMap<String, Class>();
    private Map<String, ModelConverter> converters;

    public static Converter getInstance() {
        return instance;
    }

    public Converter() {
        this.modelClasses.put("w:tbl", TableModel.class);
        this.modelClasses.put("w:sym", SymbolModel.class);
        this.converters = new HashMap<String, ModelConverter>();
    }

    public void registerModel(String name, Class c) {
        this.modelClasses.put(name, c);
    }

    public void start(WordprocessingMLPackage wmlPackage) {
        if (wmlPackage == null) {
            log.error((Object)"wmlPackage was null!");
        }
        this.wmlPackage = wmlPackage;
        for (ModelConverter conv : this.converters.values()) {
            conv.start();
        }
    }

    public void stop() {
        for (ModelConverter conv : this.converters.values()) {
            conv.stop();
        }
    }

    public WordprocessingMLPackage getWmlPackage() {
        return this.wmlPackage;
    }

    public Converter registerModelConverter(String tag, ModelConverter writer) {
        if (!this.modelClasses.containsKey(tag)) {
            throw new IllegalArgumentException("No model registered for " + tag);
        }
        writer.setMainConverter(this);
        this.converters.put(tag, writer);
        return this;
    }

    public static Node toNode(Node node, NodeList childResults, Map<String, TransformState> modelStates) {
        Converter inst = Converter.getInstance();
        Class c = inst.modelClasses.get(node.getNodeName());
        if (c == null) {
            log.error((Object)("No model registered for " + node.getNodeName()));
            throw new IllegalArgumentException("No model registered for " + node.getNodeName());
        }
        log.debug((Object)("Using model " + c.getName() + " for node " + node.getNodeName()));
        try {
            Model model = (Model)c.newInstance();
            model.setWordMLPackage(inst.getWmlPackage());
            model.build(node, childResults);
            ModelConverter converter = inst.converters.get(node.getNodeName());
            if (converter == null) {
                log.warn((Object)("No writer registered for " + node.getNodeName()));
                log.info((Object)"Generating wml from model.");
                Object o = model.toJAXB();
                Document doc = XmlUtils.marshaltoW3CDomDocument(o);
                DocumentFragment docfrag = doc.createDocumentFragment();
                docfrag.appendChild(doc.getDocumentElement());
                return docfrag;
            }
            converter.setWordMLPackage(inst.getWmlPackage());
            return converter.toNode(model, modelStates.get(node.getNodeName()));
        }
        catch (Exception e) {
            log.error((Object)("Cannot convert " + node), (Throwable)e);
            return null;
        }
    }
}

